/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.AttachPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ExecutableProjectPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostListEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.CorefileFilter;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class DebugCorePanel
extends JPanel {
    private DocumentListener corefileValidateListener = null;
    private DocumentListener executableValidateListener = null;
    private JButton actionButton = null;
    private String autoString = null;
    private boolean readonly;
    private boolean noproject;
    private static Project lastSelectedProject = null;
    private final RequestProcessor RP = new RequestProcessor();
    private JButton corefileBrowseButton;
    private JLabel corefileLabel;
    private JTextField corefileTextField;
    private JLabel errorLabel;
    private JButton executableBrowseButton;
    private JComboBox executableComboBox;
    private JLabel executableLabel;
    private JPanel fill;
    private JTextArea guidanceTextArea;
    private JComboBox projectComboBox;
    private JLabel projectLabel;
    private JComboBox engineComboBox;
    private JLabel engineLabel;
    private static String lastHostChoice;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JButton hostsButton;
    private ResourceBundle bundle;

    public DebugCorePanel(String corePath, String[] exePaths, JButton actionButton, boolean readonly, String host) {
        this.actionButton = actionButton;
        this.readonly = readonly;
        this.initialize(corePath, exePaths, host);
    }

    private void initialize(String corePath, String[] exePaths, String host) {
        this.initComponents();
        if (this.readonly) {
            this.corefileTextField.setEditable(false);
            this.corefileBrowseButton.setEnabled(false);
            this.guidanceTextArea.setText(Catalog.get("LOADCORE_GUIDANCETEXT2"));
            Catalog.setAccessibleDescription(this.guidanceTextArea, "LOADCORE_GUIDANCETEXT2");
        }
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        if (corePath != null) {
            this.corefileTextField.setText(corePath);
        }
        this.initGui();
        this.guidanceTextArea.setBackground(this.getBackground());
        this.setPreferredSize(new Dimension(700, (int)this.getPreferredSize().getHeight()));
        this.corefileValidateListener = new CorefileValidateListener();
        this.executableValidateListener = new ExecutableValidateListener();
        this.corefileTextField.getDocument().addDocumentListener(this.corefileValidateListener);
        this.executableComboBox.setModel(new DefaultComboBoxModel<String>(exePaths));
        ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.executableValidateListener);
        if (host != null) {
            lastHostChoice = host;
        }
        this.initRemoteHost();
        this.initEngine();
        lastHostChoice = null;
        this.adjustAutoCore();
        this.validateAll();
        this.projectComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    DebugCorePanel.this.projectChanged();
                }
            }
        });
    }

    private void projectChanged() {
        this.validateAll();
    }

    private void validateProject() {
        MakeConfiguration conf;
        Project selectedProject = this.getSelectedProject();
        if (selectedProject != null && (conf = ConfigurationSupport.getProjectActiveConfiguration((Project)selectedProject)) != null) {
            EngineType projectDebuggerType = DebuggerManager.debuggerType((Configuration)conf);
            if (this.getEngine() != projectDebuggerType) {
                this.setError("ERROR_WRONG_FAMILY", false);
            }
        }
    }

    public EngineType getEngine() {
        Object selected = this.engineComboBox.getSelectedItem();
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        for (EngineType engineType : engineTypes) {
            if (!engineType.getDisplayName().equals(selected)) continue;
            return engineType;
        }
        assert (false) : "selected object doesn't have associated engine type " + selected;
        return null;
    }

    private int lookupAutoEntry() {
        int count = this.executableComboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!((String)this.executableComboBox.getItemAt(i)).equals(Catalog.get("AutoCoreExe"))) continue;
            return i;
        }
        return -1;
    }

    private void adjustAutoCore() {
        String exec = this.getExecutablePath();
        EngineDescriptor descriptor = new EngineDescriptor(this.getEngine());
        if (!descriptor.hasCapability(EngineCapability.DERIVE_EXECUTABLE)) {
            this.autoString = null;
            int i = this.lookupAutoEntry();
            if (this.executableComboBox.getItemCount() > 0 && i != -1) {
                this.executableComboBox.removeItemAt(i);
            }
            if (exec.equals(Catalog.get("AutoCoreExe"))) {
                exec = "";
            }
        } else {
            this.autoString = Catalog.get("AutoCoreExe");
            int i = this.lookupAutoEntry();
            if (i == -1) {
                this.executableComboBox.addItem(Catalog.get("AutoCoreExe"));
            }
            if (exec.isEmpty()) {
                exec = this.autoString;
            }
        }
        this.setExecutable(exec);
    }

    private void setExecutable(String exec) {
        ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).setText(exec);
    }

    private void engineComboBoxActionPerformed(ActionEvent evt) {
        this.adjustAutoCore();
        this.validateAll();
    }

    private void initEngine() {
        ActionListener engineComboBoxActionListener = this.engineComboBox.getActionListeners()[0];
        this.engineComboBox.removeActionListener(engineComboBoxActionListener);
        this.engineComboBox.removeAllItems();
        Collection<EngineType> engineTypes = EngineTypeManager.getEngineTypes(false);
        for (EngineType engineType : engineTypes) {
            this.engineComboBox.addItem(engineType.getDisplayName());
        }
        this.engineComboBox.addActionListener(engineComboBoxActionListener);
    }

    private void initRemoteHost() {
        CustomizableHostList hostlist;
        this.updateRemoteHostList();
        if (DebuggerManager.isStandalone() && (hostlist = DebuggerManager.get().getHostList()) != null) {
            hostlist.addRecordListListener(new RecordListListener(){

                @Override
                public void contentsChanged(RecordListEvent e) {
                    if (e.getHostName() != null) {
                        lastHostChoice = e.getHostName();
                    }
                    DebugCorePanel.this.updateRemoteHostList();
                }
            });
        }
        this.hostComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.hostComboBoxActionPerformed(evt);
            }
        });
    }

    private void hostComboBoxActionPerformed(ActionEvent evt) {
        JComboBox cb;
        String ac = evt.getActionCommand();
        if (ac != null && ac.equals("comboBoxChanged") && (cb = (JComboBox)evt.getSource()) != null && cb.getItemCount() > 0) {
            String hostName = this.getHostName();
            CndRemote.validate(hostName, new Runnable(){

                @Override
                public void run() {
                    DebugCorePanel.this.whenHostUpdated();
                }
            });
        }
    }

    private void whenHostUpdated() {
        this.validateAll();
    }

    private void validateAll() {
        final String corePath = this.getCorefilePath();
        final String execPath = this.getExecutablePath();
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                DebugCorePanel.this.clearError();
                if (DebugCorePanel.this.validateCorefilePath(corePath) && DebugCorePanel.this.validateExecutablePath(execPath)) {
                    DebugCorePanel.this.validateProject();
                }
            }
        });
    }

    private void updateRemoteHostList() {
        AttachPanel.fillHostsCombo(this.hostComboBox);
        AttachPanel.setHostChoice(lastHostChoice, this.hostComboBox);
    }

    public String getCorefilePath() {
        return this.corefileTextField.getText();
    }

    public String getHostName() {
        return this.hostComboBox.getSelectedItem().toString();
    }

    public String getExecutablePath() {
        return ((JTextField)this.executableComboBox.getEditor().getEditorComponent()).getText();
    }

    private void initComponents() {
        Catalog.setAccessibleDescription(this, "ACSD_DebugCoreFile");
        this.guidanceTextArea = new JTextArea();
        this.corefileLabel = new JLabel();
        this.corefileTextField = new JTextField();
        this.corefileBrowseButton = new JButton();
        this.executableLabel = new JLabel();
        this.executableComboBox = new JComboBox();
        this.executableBrowseButton = new JButton();
        this.projectLabel = new JLabel();
        this.projectComboBox = new JComboBox();
        this.engineLabel = new JLabel();
        this.engineComboBox = new JComboBox();
        this.hostComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.hostsButton = new JButton();
        this.fill = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        Catalog.setAccessibleName(this.guidanceTextArea, "ACSN_Guidance");
        this.guidanceTextArea.setEditable(false);
        this.guidanceTextArea.setLineWrap(true);
        this.guidanceTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_GUIDANCETEXT1"));
        Catalog.setAccessibleDescription(this.guidanceTextArea, "LOADCORE_GUIDANCETEXT1");
        this.guidanceTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.guidanceTextArea, gridBagConstraints);
        this.hostLabel.setText(Catalog.get("HOST_LBL"));
        this.hostLabel.setLabelFor(this.hostComboBox);
        this.hostLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Host"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        if (!DebuggerManager.isStandalone()) {
            this.hostsButton.setEnabled(false);
        }
        this.hostsButton.setText(Catalog.get("TITLE_Hosts"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.hostsButton, gridBagConstraints);
        this.hostsButton.setMnemonic(Catalog.getMnemonic("MNEM_Hosts"));
        Catalog.setAccessibleDescription(this.hostsButton, "ACSD_EditHosts");
        this.hostsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.hostsButtonActionPerformed(evt);
            }
        });
        this.engineLabel.setLabelFor(this.engineComboBox);
        this.engineLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Engine"));
        Catalog.setAccessibleDescription(this.engineComboBox, "ACSD_Engine");
        this.engineLabel.setText(Catalog.get("ASSOCIATED_ENGINE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.add((Component)this.engineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        this.add((Component)this.engineComboBox, gridBagConstraints);
        this.engineComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.engineComboBoxActionPerformed(evt);
            }
        });
        this.corefileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILE_MN").charAt(0));
        this.corefileLabel.setLabelFor(this.corefileTextField);
        this.corefileLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 0);
        this.add((Component)this.corefileLabel, gridBagConstraints);
        Catalog.setAccessibleDescription(this.corefileTextField, "ACSD_Corefile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.corefileTextField, gridBagConstraints);
        Catalog.setAccessibleDescription(this.corefileBrowseButton, "ACSD_CorefileBrowse");
        this.corefileBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("LOADCORE_COREFILEBROWSE_BUTTON_MN").charAt(0));
        this.corefileBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("BROWSE_BUTTON_TXT"));
        this.corefileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.corefileBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.corefileBrowseButton, gridBagConstraints);
        this.executableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_MN").charAt(0));
        this.executableLabel.setLabelFor(this.executableComboBox);
        this.executableLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 8, 0);
        this.add((Component)this.executableLabel, gridBagConstraints);
        this.executableComboBox.setEditable(true);
        this.executableComboBox.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ProgramPathname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 0);
        this.add((Component)this.executableComboBox, gridBagConstraints);
        Catalog.setAccessibleDescription(this.executableBrowseButton, "ACSD_ExecutableBrowse");
        this.executableBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("EXECUTABLEBROWSE_BUTTON_MN").charAt(0));
        this.executableBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("BROWSE_BUTTON_TXT"));
        this.executableBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebugCorePanel.this.executableBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 8, 12);
        this.add((Component)this.executableBrowseButton, gridBagConstraints);
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_MN").charAt(0));
        this.projectLabel.setLabelFor(this.projectComboBox);
        Catalog.setAccessibleDescription(this.projectComboBox, "ACSD_Project");
        this.projectLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common2/debugger/actions/Bundle").getString("ASSOCIATED_PROJECT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        if (!DebuggerManager.isStandalone()) {
            this.add((Component)this.projectLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 6, 12);
        if (!DebuggerManager.isStandalone()) {
            this.add((Component)this.projectComboBox, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fill, gridBagConstraints);
        this.errorLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    private void executableBrowseButtonActionPerformed(ActionEvent evt) {
        final String hostname = (String)this.hostComboBox.getSelectedItem();
        String startFolder = this.getExecutablePath();
        if (startFolder.isEmpty() && (startFolder = this.getCorefilePath()).isEmpty()) {
            startFolder = System.getProperty("user.home");
        }
        if (startFolder.equals(this.autoString)) {
            startFolder = this.getCorefilePath();
        }
        final String startF = startFolder;
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Host host = Host.byName(hostname);
                    ExecutionEnvironment exEnv = host.executionEnvironment();
                    ConnectionManager.getInstance().connectTo(exEnv);
                    FileChooserBuilder fcb = new FileChooserBuilder(exEnv);
                    FileChooserBuilder.JFileChooserEx fileChooser = fcb.createFileChooser(startF);
                    fileChooser.setDialogTitle(DebugCorePanel.this.getString("SelectExecutable"));
                    fileChooser.setApproveButtonText(DebugCorePanel.this.getString("CHOOSER_BUTTON"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfExecutableFileFilter());
                    SwingUtilities.invokeLater(new Runnable((JFileChooser)fileChooser){
                        final /* synthetic */ JFileChooser val$fileChooser;
                        {
                            this.val$fileChooser = jFileChooser;
                        }

                        @Override
                        public void run() {
                            int ret = this.val$fileChooser.showOpenDialog(DebugCorePanel.this);
                            if (ret == 1) {
                                return;
                            }
                            ((JTextField)DebugCorePanel.this.executableComboBox.getEditor().getEditorComponent()).setText(this.val$fileChooser.getSelectedFile().getPath());
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
    }

    private void hostsButtonActionPerformed(ActionEvent evt) {
        HostListEditor editor = new HostListEditor();
        editor.showDialog(this);
    }

    private void corefileBrowseButtonActionPerformed(ActionEvent evt) {
        final String hostname = (String)this.hostComboBox.getSelectedItem();
        String startFolder = this.getCorefilePath();
        if (startFolder.isEmpty()) {
            startFolder = System.getProperty("user.home");
        }
        final String startF = startFolder;
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Host host = Host.byName(hostname);
                    ExecutionEnvironment exEnv = host.executionEnvironment();
                    ConnectionManager.getInstance().connectTo(exEnv);
                    FileChooserBuilder fcb = new FileChooserBuilder(exEnv);
                    FileChooserBuilder.JFileChooserEx fileChooser = fcb.createFileChooser(startF);
                    fileChooser.setDialogTitle(DebugCorePanel.this.getString("CorefileChooser"));
                    fileChooser.setApproveButtonText(DebugCorePanel.this.getString("CHOOSER_BUTTON"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.addChoosableFileFilter(new CorefileFilter());
                    SwingUtilities.invokeLater(new Runnable((JFileChooser)fileChooser){
                        final /* synthetic */ JFileChooser val$fileChooser;
                        {
                            this.val$fileChooser = jFileChooser;
                        }

                        @Override
                        public void run() {
                            int ret = this.val$fileChooser.showOpenDialog(DebugCorePanel.this);
                            if (ret == 1) {
                                return;
                            }
                            DebugCorePanel.this.corefileTextField.setText(this.val$fileChooser.getSelectedFile().getPath());
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    // empty catch block
                }
            }
        });
    }

    private void initGui() {
        this.projectComboBox.removeAllItems();
        this.projectComboBox.addItem(this.getString("NO_PROJECT"));
        this.projectComboBox.addItem(this.getString("NEW_PROJECT"));
        ExecutableProjectPanel.fillProjectsCombo(this.projectComboBox, lastSelectedProject);
    }

    private boolean validateCorefilePath(String corePath) {
        if ((corePath = corePath.trim()).length() == 0) {
            this.setError("ERROR_CORE_NOT_SPECIFIED", true);
            return false;
        }
        Host host = Host.byName(this.getHostName());
        ExecutionEnvironment exEnv = host.executionEnvironment();
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)exEnv, (String)corePath)) {
                this.setError("ERROR_CORE_DONTEXIST", true);
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (exEnv.isLocal()) {
            File coreFile = new File(corePath);
            if (coreFile.isDirectory()) {
                this.setError("ERROR_NOTACOREFILE", true);
                return false;
            }
            FileObject fo = FileUtil.toFileObject((File)coreFile);
            if (fo == null) {
                this.setError("ERROR_CORE_DONTEXIST", true);
                return false;
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (Exception e) {
                this.setError("ERROR_CORE_DONTEXIST", true);
                return false;
            }
            if (!"application/x-core+elf".equals(IpeUtils.getMime(dataObject))) {
                this.setError("ERROR_NOTACOREFILE", true);
                return false;
            }
        }
        return true;
    }

    private boolean validateExecutablePath(String exePath) {
        if ((exePath = exePath.trim()).equals(this.autoString)) {
            return true;
        }
        Host host = Host.byName(this.getHostName());
        ExecutionEnvironment exEnv = host.executionEnvironment();
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)exEnv, (String)exePath)) {
                EngineDescriptor descriptor = new EngineDescriptor(this.getEngine());
                if (descriptor.hasCapability(EngineCapability.DERIVE_EXECUTABLE)) {
                    this.setError("ERROR_DONTEXIST", true);
                } else {
                    this.setError("DBG_ERROR_DONTEXIST", false);
                }
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (exEnv.isLocal()) {
            File exeFile = new File(exePath);
            if (exeFile.isDirectory()) {
                this.setError("ERROR_NOTAEXEFILE", true);
                return false;
            }
            FileObject fo = FileUtil.toFileObject((File)exeFile);
            if (fo == null) {
                this.setError("ERROR_NOTAEXEFILE", true);
                return false;
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (Exception e) {
                this.setError("ERROR_DONTEXIST", true);
                return false;
            }
            if (!MIMENames.isBinary((String)IpeUtils.getMime(dataObject))) {
                this.setError("ERROR_NOTAEXEFILE", true);
                return false;
            }
        }
        return true;
    }

    private boolean matchProject(String executable) {
        if (executable.equals(this.autoString)) {
            this.projectComboBox.setSelectedIndex(0);
            return true;
        }
        this.projectComboBox.setEnabled(true);
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            if (!executable.equalsIgnoreCase(this.projectComboBox.getItemAt(i).toString())) continue;
            this.projectComboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private void setError(final String errorMsg, final boolean disable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugCorePanel.this.errorLabel.setText(DebugCorePanel.this.getString(errorMsg));
                if (disable) {
                    DebugCorePanel.this.projectComboBox.setEnabled(false);
                }
                DebugCorePanel.this.actionButton.setEnabled(false);
            }
        });
    }

    private void clearError() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugCorePanel.this.errorLabel.setText(" ");
                DebugCorePanel.this.projectComboBox.setEnabled(true);
                DebugCorePanel.this.actionButton.setEnabled(true);
            }
        });
    }

    public Project getSelectedProject() {
        Object selectedItem = this.projectComboBox.getSelectedItem();
        if (selectedItem instanceof ExecutableProjectPanel.ProjectCBItem) {
            this.noproject = false;
            return ((ExecutableProjectPanel.ProjectCBItem)selectedItem).getProject();
        }
        this.noproject = this.projectComboBox.getSelectedIndex() == 0;
        return null;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(DebugCorePanel.class);
        }
        return this.bundle.getString(s);
    }

    public boolean asynchronous() {
        return false;
    }

    public void setLastSelectedProject(Project l) {
        lastSelectedProject = l;
    }

    public boolean getNoProject() {
        return this.noproject;
    }

    public class ExecutableValidateListener
    extends AttachPanel.AnyChangeDocumentListener {
        @Override
        protected void documentChanged(DocumentEvent e) {
            String pName = CndPathUtilitities.getBaseName((String)DebugCorePanel.this.getExecutablePath());
            DebugCorePanel.this.matchProject(pName);
            DebugCorePanel.this.validateAll();
        }
    }

    public class CorefileValidateListener
    extends AttachPanel.AnyChangeDocumentListener {
        @Override
        protected void documentChanged(DocumentEvent e) {
            DebugCorePanel.this.validateAll();
        }
    }
}

