/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.StateListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyUtils;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class RunToCursorInstAction
extends CallableSystemAction
implements StateListener {
    private NativeDebugger debugger = DebuggerManager.get().currentDebugger();

    public RunToCursorInstAction() {
        if (this.debugger != null) {
            this.debugger.addStateListener(this);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    static void runToDisLine(int lineNo) {
        String address = DisassemblyUtils.getLineAddress(lineNo);
        if (address == null || address.isEmpty()) {
            return;
        }
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger == null) {
            return;
        }
        debugger.runToCursorInst(address);
    }

    public void performAction() {
        int lineNo = EditorContextBridge.getCurrentLineNumber();
        if (lineNo < 0) {
            return;
        }
        RunToCursorInstAction.runToDisLine(lineNo);
    }

    public String getName() {
        return Catalog.get("LBL_RunToCursorInstAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    protected String iconResource() {
        return "org/netbeans/modules/cnd/debugger/common2/icons/run_to_cursor_instruction.png";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("ShortDescription", Catalog.get("TIP_RunToCursorInstAction"));
        this.setEnabled(false);
    }

    @Override
    public void update(State state) {
        if (state == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(state.isLoaded && state.isListening() && !state.isCore);
        }
    }
}

