/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.AttrValuePairs;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.SubBreakpointsXMLCodec;
import org.netbeans.modules.cnd.debugger.common2.utils.props.EnumProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.Property;
import org.netbeans.modules.cnd.debugger.common2.values.Enum;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;

class BreakpointXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private final HashMap<String, BreakpointType> types;
    private BreakpointBag bag;
    private NativeBreakpoint parent;
    private NativeBreakpoint currentBreakpoint;
    private NativeBreakpoint bpt;
    private static final String TAG_BREAKPOINT = "breakpoint";
    private static final String ATTR_BREAKPOINT_TYPE = "type";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String TAG_ATTRIBUTES = "attributes";
    private static final String TAG_ANNOTATIONS = "annotations";
    private static final String TAG_ANNOTATION = "annotation";
    private static final String ATTR_ANNOTATION_FILE = "file";
    private static final String ATTR_ANNOTATION_LINE = "line";
    private static final String ATTR_ANNOTATION_FS = "fileSystem";

    BreakpointXMLCodec(BreakpointBag bag, NativeBreakpoint parent, HashMap<String, BreakpointType> types) {
        this.bag = bag;
        this.parent = parent;
        this.types = types;
        if (parent == null || parent.isToplevel()) {
            this.registerXMLDecoder(new SubBreakpointsXMLCodec(this, types));
        }
    }

    BreakpointXMLCodec(NativeBreakpoint bpt) {
        this.bpt = bpt;
        this.types = null;
    }

    NativeBreakpoint currentBreakpoint() {
        return this.currentBreakpoint;
    }

    protected String tag() {
        return TAG_BREAKPOINT;
    }

    public void start(Attributes atts) {
        if (Log.Bpt.xml) {
            System.out.printf("BreakpointXMLCodec().start(%s)\n", this.tag());
        }
        String typeName = atts.getValue(ATTR_BREAKPOINT_TYPE);
        String dateString = atts.getValue(ATTR_TIMESTAMP);
        Date date = new Date(0L);
        try {
            date = new Date(Long.parseLong(dateString));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        NativeBreakpointType type = (NativeBreakpointType)this.types.get(typeName);
        try {
            int flags = 1;
            flags = this.parent == null ? (flags |= 2) : (this.parent.isMidlevel() ? (flags |= 4) : (flags |= 8));
            this.currentBreakpoint = type.newInstance(flags);
            this.currentBreakpoint.restoreTimestamp(date);
            if (this.bag != null) {
                if (Log.Bpt.xml) {
                    System.out.printf("\ttoplevel\n", new Object[0]);
                }
                this.bag.restore(this.currentBreakpoint);
            }
            if (this.parent != null) {
                if (Log.Bpt.xml) {
                    System.out.printf("\tsub-bpt\n", new Object[0]);
                }
                this.parent.restoringChild(this.currentBreakpoint);
            }
        }
        catch (Exception x) {
            ErrorManager.getDefault().annotate((Throwable)x, "Failed to parse bpt from XML");
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    public void end() {
        if (Log.Bpt.xml) {
            System.out.printf("BreakpointXMLCodec().end(%s)\n", this.tag());
        }
        if (this.currentBreakpoint == null) {
            if (Log.Bpt.xml) {
                System.out.printf("\tno currentBreakpoint\n", new Object[0]);
            }
            return;
        }
        if (this.bag == null) {
            if (this.parent != null) {
                if (Log.Bpt.xml) {
                    System.out.printf("\tsub-bpt\n", new Object[0]);
                }
                this.parent.restoredChild();
            } else if (Log.Bpt.xml) {
                System.out.printf("\tno parent and no bag\n", new Object[0]);
            }
        }
        this.currentBreakpoint = null;
    }

    public void startElement(String element, Attributes atts) {
        if (Log.Bpt.xml) {
            System.out.printf("BreakpointXMLCodec().startElement(%s)\n", element);
        }
        if (element.equals(TAG_ATTRIBUTES)) {
            if (this.currentBreakpoint != null) {
                this.currentBreakpoint.setAttrs(atts);
            }
        } else if (element.equals(TAG_ANNOTATION)) {
            String file = atts.getValue(ATTR_ANNOTATION_FILE);
            String line = atts.getValue(ATTR_ANNOTATION_LINE);
            String fsUrl = atts.getValue(ATTR_ANNOTATION_FS);
            try {
                int lineNo = Integer.parseInt(line);
                FileSystem fs = CndFileUtils.getLocalFileSystem();
                try {
                    if (fsUrl != null) {
                        fs = CndFileUtils.urlToFileObject((CharSequence)fsUrl).getFileSystem();
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (this.currentBreakpoint != null) {
                    this.currentBreakpoint.addAnnotation(EditorBridge.getLine(file, lineNo, fs), 0L);
                }
            }
            catch (NumberFormatException x) {
                ErrorManager.getDefault().annotate((Throwable)x, "Bad line number in annotation: " + line);
                ErrorManager.getDefault().notify(16, (Throwable)x);
            }
        }
    }

    public void endElement(String element, String currentText) {
        if (Log.Bpt.xml) {
            System.out.printf("BreakpointXMLCodec().endElement(%s)\n", element);
        }
    }

    private static AttrValuePair[] attributeAttrs(NativeBreakpoint bpt) {
        AttrValuePairs attrs = new AttrValuePairs();
        for (Property p : bpt) {
            String pname = p.name();
            Object pobject = p.getAsObject();
            if (pobject == null) continue;
            if (p instanceof EnumProperty) {
                Enum eobject = (Enum)pobject;
                attrs.add(pname, eobject.name());
                continue;
            }
            attrs.add(pname, pobject.toString());
        }
        return attrs.toArray();
    }

    private void encodeAnnotations(XMLEncoderStream xes) {
        DebuggerAnnotation[] annotations = this.bpt.annotations();
        if (annotations.length > 0) {
            xes.elementOpen(TAG_ANNOTATIONS);
            for (DebuggerAnnotation a : annotations) {
                ArrayList<AttrValuePair> annotationAttrs = new ArrayList<AttrValuePair>();
                String fileName = a.getFilename();
                if (fileName == null) continue;
                annotationAttrs.add(new AttrValuePair(ATTR_ANNOTATION_FILE, fileName));
                int lineNo = a.getLineNo();
                if (lineNo == 0) continue;
                annotationAttrs.add(new AttrValuePair(ATTR_ANNOTATION_LINE, "" + lineNo));
                DataObject dObj = EditorBridge.dataObjectForLine(a.getLine());
                if (dObj != null) {
                    try {
                        FileSystem fs = dObj.getPrimaryFile().getFileSystem();
                        if (!CndFileUtils.isLocalFileSystem((FileSystem)fs)) {
                            annotationAttrs.add(new AttrValuePair(ATTR_ANNOTATION_FS, ((Object)CndFileUtils.fileObjectToUrl((FileObject)fs.getRoot())).toString()));
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                xes.element(TAG_ANNOTATION, annotationAttrs.toArray(new AttrValuePair[annotationAttrs.size()]));
            }
            xes.elementClose(TAG_ANNOTATIONS);
        }
    }

    public void encode(XMLEncoderStream xes) {
        this.bpt.prepareForSaving();
        String type = this.bpt.getBreakpointType().id();
        String timestampStr = Long.toString(this.bpt.timestamp().getTime());
        AttrValuePair[] breakpointAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_BREAKPOINT_TYPE, type), new AttrValuePair(ATTR_TIMESTAMP, timestampStr)};
        xes.elementOpen(TAG_BREAKPOINT, breakpointAttrs);
        xes.element(TAG_ATTRIBUTES, BreakpointXMLCodec.attributeAttrs(this.bpt));
        this.encodeAnnotations(xes);
        SubBreakpointsXMLCodec encoder = new SubBreakpointsXMLCodec(this.bpt);
        encoder.encode(xes);
        xes.elementClose(TAG_BREAKPOINT);
    }
}

