/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpointType;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.util.HelpCtx;

public class EditBreakpointPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String PROP_TYPE = "type";
    private JComboBox combo_type;
    private JPanel custom_panel;
    private BreakpointPanel customizer;
    private boolean customizing = false;
    private List<BreakpointType> types = new ArrayList<BreakpointType>();

    public EditBreakpointPanel(NativeBreakpoint editableBreakpoint) {
        List breakpointTypes;
        if (editableBreakpoint != null) {
            this.customizing = true;
        }
        if ((breakpointTypes = DebuggerManager.getDebuggerManager().lookup(null, BreakpointType.class)) == null) {
            System.out.println("No BreakpointTypes");
        }
        if (breakpointTypes.size() == 0) {
            System.out.println("Zero BreakpointTypes");
        }
        this.initComponents();
        int defaultEntry = -1;
        int customizing_entry = 0;
        for (int btx = 0; btx < breakpointTypes.size(); ++btx) {
            String type;
            BreakpointType bt = (BreakpointType)breakpointTypes.get(btx);
            String category = bt.getCategoryDisplayName();
            if (this.customizing) {
                if (!editableBreakpoint.isOfType(bt)) continue;
                type = bt.getTypeDisplayName();
                customizing_entry = btx;
                this.types.add(bt);
                this.combo_type.addItem(type);
                continue;
            }
            if (!NativeBreakpointType.isOurs(category)) continue;
            type = bt.getTypeDisplayName();
            if (bt.isDefault()) {
                defaultEntry = this.combo_type.getItemCount();
            }
            this.types.add(bt);
            this.combo_type.addItem(type);
        }
        if (this.customizing) {
            this.combo_type.setSelectedIndex(0);
            NativeBreakpointType bt = editableBreakpoint.getBreakpointType();
            this.switchTo(bt, editableBreakpoint);
        } else {
            this.combo_type.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int x = EditBreakpointPanel.this.combo_type.getSelectedIndex();
                    BreakpointType bt = (BreakpointType)EditBreakpointPanel.this.types.get(x);
                    EditBreakpointPanel.this.switchTo(bt, null);
                }
            });
            if (defaultEntry != -1) {
                this.combo_type.setSelectedIndex(defaultEntry);
            }
        }
    }

    public Controller getController() {
        return this.customizer.getController();
    }

    private void initComponents() {
        if (this.customizing) {
            Catalog.setAccessibleDescription(this, "ACSD_CustomizeBreakpointPanel");
        } else {
            Catalog.setAccessibleDescription(this, "ACSD_NewBreakpointPanel");
        }
        this.setLayout(new GridBagLayout());
        JLabel lab_type = new JLabel();
        lab_type.setText(Catalog.get("CTL_Breakpoint_type"));
        lab_type.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Breakpoint_type"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 2;
        constraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)lab_type, constraints);
        this.combo_type = new JComboBox();
        Catalog.setAccessibleDescription(this.combo_type, "ACSD_Breakpoint_type");
        this.combo_type.setMaximumRowCount(12);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.insets = new Insets(12, 12, 0, 12);
        constraints.anchor = 17;
        this.add((Component)this.combo_type, constraints);
        if (this.customizing) {
            this.combo_type.setEnabled(false);
        }
        lab_type.setLabelFor(this.combo_type);
        this.custom_panel = new JPanel();
        this.custom_panel.setLayout(new BorderLayout());
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.insets = new Insets(9, 9, 0, 9);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.custom_panel, constraints);
    }

    private void switchTo(BreakpointType bt, NativeBreakpoint editableBreakpoint) {
        this.customizer = this.customizing ? ((NativeBreakpointType)bt).getCustomizer(editableBreakpoint) : ((NativeBreakpointType)bt).getCustomizer(null);
        this.custom_panel.removeAll();
        this.custom_panel.add((Component)this.customizer, "Center");
        this.revalidate();
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent != null) {
            parent.pack();
        }
        this.firePropertyChange(PROP_TYPE, null, null);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Breakpoints");
    }
}

