/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.terminal.api.IOTopComponent;
import org.netbeans.modules.terminal.api.TerminalContainer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ConsoleTopComponent
extends TopComponent
implements IOTopComponent {
    private static ConsoleTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common2/icons/debugger_console.png";
    private static final String PREFERRED_ID = "ConsoleTopComponent";
    private TerminalContainer tc;

    public ConsoleTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ConsoleTopComponent.class, (String)"CTL_ConsoleTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ConsoleTopComponent.class, (String)"HINT_ConsoleTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.initComponents2();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private static synchronized ConsoleTopComponent getDefault() {
        if (instance == null) {
            assert (SwingUtilities.isEventDispatchThread());
            instance = new ConsoleTopComponent();
        }
        return instance;
    }

    public static synchronized ConsoleTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ConsoleTopComponent.class.getName()).warning("Cannot find ConsoleTopComponent component. It will not be located properly in the window system.");
            return ConsoleTopComponent.getDefault();
        }
        if (win instanceof ConsoleTopComponent) {
            return (ConsoleTopComponent)win;
        }
        Logger.getLogger(ConsoleTopComponent.class.getName()).warning("There seem to be multiple components with the 'ConsoleTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ConsoleTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void open() {
        if (this.isOpened() && this.isShowing()) {
            return;
        }
        WindowManager wm = WindowManager.getDefault();
        Mode mode = wm.findMode((TopComponent)this);
        if (mode == null) {
            mode = wm.findMode("output");
        }
        mode.dockInto((TopComponent)this);
        super.open();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void requestActive() {
        super.requestActive();
        this.tc.requestFocusInWindow();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.tc.componentActivated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.tc.componentDeactivated();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public IOContainer ioContainer() {
        return this.tc.ioContainer();
    }

    public TopComponent topComponent() {
        return this;
    }

    private void initComponents2() {
        this.tc = TerminalContainer.createMuxable((TopComponent)this, (String)this.getName());
        this.add((Component)this.tc);
    }
}

