/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostListXMLReader;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostListXMLWriter;
import org.netbeans.modules.cnd.debugger.common2.utils.UserdirFile;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.AbstractRecordList;
import org.openide.ErrorManager;

public class CustomizableHostList
extends AbstractRecordList<CustomizableHost> {
    private static CustomizableHostList instance = null;
    private static int listMaxSize = 100;
    private static final String moduleFolderName = "DbxGui";
    private static final String folderName = "RemoteSettings";
    private static final String filename = "remotesettings";
    private static final UserdirFile userdirFile = new UserdirFile("DbxGui", "RemoteSettings", "remotesettings");

    public CustomizableHostList(int max) {
        super(max);
    }

    protected CustomizableHostList(CustomizableHostList that) {
        super(listMaxSize, that);
    }

    public static CustomizableHostList getInstance() {
        if (instance == null) {
            try {
                instance = new CustomizableHostList(listMaxSize);
                instance.restore(userdirFile);
                instance.addLocalhost();
            }
            catch (Exception e) {
                System.out.println("HostList - getInstance - e " + e);
                System.out.println("Cannot restore host list ...");
            }
        }
        return instance;
    }

    public static void saveList() {
        if (instance == null) {
            return;
        }
        instance.save(userdirFile);
    }

    public void save(UserdirFile userdirFile) {
        HostListXMLWriter xw = new HostListXMLWriter(userdirFile, this);
        try {
            xw.write();
            CustomizableHostList.clearDirty();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public void restore(UserdirFile userdirFile) {
        HostListXMLReader xr = new HostListXMLReader(userdirFile, this);
        try {
            xr.read();
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify(4096, (Throwable)x);
        }
    }

    @Override
    public CustomizableHostList cloneList() {
        return new CustomizableHostList(this);
    }

    @Override
    public String newKey() {
        return "<newhost>";
    }

    private void addLocalhost() {
        int i = this.getHostIndexByName("localhost");
        if (i == 0) {
            return;
        }
        if (i == -1) {
            this.addRecord(new CustomizableHost());
        } else {
            this.addRecord(this.getRecordAt(i), true);
        }
    }

    public CustomizableHost getHostByDispName(String hostname) {
        for (CustomizableHost host : this) {
            if (!host.displayName().equals(hostname)) continue;
            return host;
        }
        return null;
    }

    public CustomizableHost getHostByName(String hostname) {
        for (CustomizableHost host : this) {
            if (!host.getHostName().equals(hostname)) continue;
            return host;
        }
        return null;
    }

    public int getHostIndexByName(String hostname) {
        int i = 0;
        for (CustomizableHost host : this) {
            if (((Host)host).getHostName().equals(hostname)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

