/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionPropertySupport;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

class OptionDirectoryEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private OptionPropertySupport ops;
    private final String baseDir;
    private PropertyEnv env;
    private int dirOrFile;

    public OptionDirectoryEditor(OptionPropertySupport ops, String baseDir, int dirOrFile) {
        this.ops = ops;
        this.baseDir = baseDir;
        this.dirOrFile = dirOrFile;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    @Override
    public String getAsText() {
        return (String)this.getValue();
    }

    @Override
    public void setValue(Object v) {
        this.ops.setValue(v);
    }

    @Override
    public Object getValue() {
        Object o = this.ops.getValue();
        return o;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new DirectoryChooser(this, this.env, this.dirOrFile, this.baseDir, (String)this.ops.getValue());
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    static class DirectoryChooser
    extends FileChooser
    implements PropertyChangeListener {
        private final PropertyEditorSupport editor;
        private final String baseDir;

        private static String fullPath(String baseDir, String path) {
            String seed = path;
            if (seed.length() == 0) {
                seed = ".";
            }
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)seed)) {
                seed = baseDir + File.separatorChar + seed;
            }
            return seed;
        }

        public DirectoryChooser(PropertyEditorSupport editor, PropertyEnv env, int dirOrFile, String baseDir, String path) {
            super("Experiment Directory", "Select", dirOrFile, null, DirectoryChooser.fullPath(baseDir, path), true);
            this.editor = editor;
            this.baseDir = baseDir;
            this.setControlButtonsAreShown(false);
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File file;
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && (file = this.getSelectedFile()) != null) {
                String path = file.getPath();
                path = CndPathUtilitities.toAbsolutePath((String)this.baseDir, (String)path);
                this.editor.setValue(path);
            }
        }
    }
}

