/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

public class CopyTransformer
extends RefactoringVisitor {
    private String newName;
    private boolean insertImport;
    private String oldPackage;
    private String oldName;
    private String newPackage;

    public CopyTransformer(WorkingCopy workingCopy, String oldName, String newName, boolean insertImport, String oldPackage) {
        try {
            this.setWorkingCopy(workingCopy);
            this.newName = newName;
            this.insertImport = insertImport;
            this.oldPackage = oldPackage;
            this.oldName = oldName;
            this.newPackage = RetoucheUtils.getPackageName(workingCopy.getFileObject().getParent());
        }
        catch (ToPhaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree tree, Element p) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            CompilationUnitTree cut = tree;
            if (cut.getPackageName() != null && !"".equals(this.newPackage) && !this.newPackage.equals(cut.getPackageName().toString())) {
                this.rewrite(cut.getPackageName(), this.make.Identifier((CharSequence)this.newPackage));
            } else {
                cut = this.make.CompilationUnit(cut.getPackageAnnotations(), (ExpressionTree)("".equals(this.newPackage) ? null : this.make.Identifier((CharSequence)this.newPackage)), cut.getImports(), cut.getTypeDecls(), cut.getSourceFile());
            }
            if (this.insertImport && !"package-info".equals(this.newName)) {
                CompilationUnitTree tree2 = this.make.insertCompUnitImport(cut, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)(this.oldPackage + ".*")), false));
                this.rewrite(tree, tree2);
            }
        }
        return (Tree)super.visitCompilationUnit(tree, p);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            TypeElement currentClass = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (currentClass == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").severe("Cannot resolve tree " + tree + "\n file: " + this.workingCopy.getFileObject().getPath());
            } else if (!currentClass.getNestingKind().isNested() && (this.workingCopy.getCompilationUnit().getTypeDecls().size() == 1 || tree.getSimpleName().toString().equals(this.oldName) || tree.getSimpleName().toString().equals(this.oldName + "_1"))) {
                Tree nju = this.make.setLabel((Tree)tree, (CharSequence)this.newName);
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitClass(tree, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    private void renameUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        if (el instanceof TypeElement && ((TypeElement)el).getQualifiedName().toString().equals(this.newPackage + "." + this.oldName)) {
            Tree nju = this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, nju);
        }
    }
}

