/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;

public class FindUsagesVisitor
extends FindVisitor {
    private boolean findInComments = false;
    private Collection<UsageInComment> usagesInComments = Collections.emptyList();

    public FindUsagesVisitor(WorkingCopy workingCopy) {
        super(workingCopy);
    }

    public Collection<UsageInComment> getUsagesInComments() {
        return this.usagesInComments;
    }

    public FindUsagesVisitor(WorkingCopy workingCopy, boolean findInComments) {
        super(workingCopy);
        this.findInComments = findInComments;
        if (findInComments) {
            this.usagesInComments = new ArrayList<UsageInComment>();
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        if (this.findInComments) {
            String originalName = p.getSimpleName().toString();
            TokenSequence ts = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            while (ts.moveNext()) {
                Token t = ts.token();
                if (t.id() != JavaTokenId.BLOCK_COMMENT && t.id() != JavaTokenId.LINE_COMMENT && t.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                Scanner tokenizer = new Scanner(((Object)t.text()).toString());
                tokenizer.useDelimiter("[^a-zA-Z0-9_]");
                while (tokenizer.hasNext()) {
                    String current = tokenizer.next();
                    if (!current.equals(originalName)) continue;
                    this.usagesInComments.add(new UsageInComment(ts.offset() + tokenizer.match().start(), ts.offset() + tokenizer.match().end()));
                }
            }
        }
        return (Tree)super.visitCompilationUnit(node, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    @Override
    public Tree visitNewClass(NewClassTree node, Element p) {
        Trees trees = this.workingCopy.getTrees();
        ClassTree classTree = node.getClassBody();
        if (classTree != null && p.getKind() == ElementKind.CONSTRUCTOR) {
            Element anonClass = this.workingCopy.getTrees().getElement(TreePath.getPath(this.workingCopy.getCompilationUnit(), (Tree)classTree));
            if (anonClass == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").severe("FindUsages cannot resolve " + classTree);
            } else {
                for (ExecutableElement c : ElementFilter.constructorsIn(anonClass.getEnclosedElements())) {
                    MethodTree t = this.workingCopy.getTrees().getTree(c);
                    TreePath superCall = trees.getPath(this.workingCopy.getCompilationUnit(), ((ExpressionStatementTree)t.getBody().getStatements().get(0)).getExpression());
                    Element superCallElement = trees.getElement(superCall);
                    if (superCallElement == null || !((Object)superCallElement).equals(p) || this.workingCopy.getTreeUtilities().isSynthetic(superCall)) continue;
                    this.addUsage(superCall);
                }
            }
        } else {
            this.addIfMatch(this.getCurrentPath(), node, p);
        }
        return (Tree)super.visitNewClass(node, p);
    }

    private void addIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path) && (ElementKind.CONSTRUCTOR != elementToFind.getKind() || tree.getKind() != Tree.Kind.IDENTIFIER || !"super".contentEquals(((IdentifierTree)tree).getName()))) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element el = trees.getElement(path);
        if (el == null) {
            if ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)path.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id.contentEquals("*")) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                path = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(path);
                if (el == null) {
                    return;
                }
                Iterator iter = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return ((Object)id).equals(e.getSimpleName());
                    }
                }).iterator();
                if (iter.hasNext()) {
                    el = (Element)iter.next();
                }
                if (iter.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (elementToFind != null && elementToFind.getKind() == ElementKind.METHOD && el.getKind() == ElementKind.METHOD) {
            if (((Object)el).equals(elementToFind) || this.workingCopy.getElements().overrides((ExecutableElement)el, (ExecutableElement)elementToFind, (TypeElement)elementToFind.getEnclosingElement())) {
                this.addUsage(this.getCurrentPath());
            }
        } else if (((Object)el).equals(elementToFind)) {
            this.addUsage(this.getCurrentPath());
        }
    }

    public static class UsageInComment {
        int from;
        int to;

        public UsageInComment(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }
}

