/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class JavaPluginUtils {
    public static final Problem isSourceElement(Element el, CompilationInfo info) {
        Problem preCheckProblem = null;
        if (RetoucheUtils.isFromLibrary(el, info.getClasspathInfo())) {
            preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_CannotRefactorLibraryClass", (Object)(el.getKind() == ElementKind.PACKAGE ? el : el.getEnclosingElement())));
            return preCheckProblem;
        }
        FileObject file = SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo());
        if (!RetoucheUtils.isElementInOpenProject(file)) {
            preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
            return preCheckProblem;
        }
        return null;
    }

    public static TreePath findMethod(TreePath path) {
        while (path != null) {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
                return path;
            }
            if (path.getLeaf().getKind() == Tree.Kind.BLOCK && path.getParentPath() != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static TreePath findStatement(TreePath statementPath) {
        while (statementPath != null && (!StatementTree.class.isAssignableFrom(statementPath.getLeaf().getKind().asInterface()) || statementPath.getParentPath() != null && statementPath.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK)) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)statementPath.getLeaf().getKind())) {
                return null;
            }
            statementPath = statementPath.getParentPath();
        }
        return statementPath;
    }

    public static boolean isParentOf(TreePath parent, TreePath path) {
        Tree parentLeaf = parent.getLeaf();
        while (path != null && path.getLeaf() != parentLeaf) {
            path = path.getParentPath();
        }
        return path != null;
    }

    public static boolean isParentOf(TreePath parent, List<? extends TreePath> candidates) {
        for (TreePath treePath : candidates) {
            if (JavaPluginUtils.isParentOf(parent, treePath)) continue;
            return false;
        }
        return true;
    }

    public static Problem chainProblems(Problem p, Problem p1) {
        if (p == null) {
            return p1;
        }
        if (p1 == null) {
            return p;
        }
        Problem problem = p;
        while (problem.getNext() != null) {
            problem = problem.getNext();
        }
        problem.setNext(p1);
        return p;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror tm) {
        Element el;
        EnumSet<ElementKind> fm = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (tm instanceof DeclaredType && ((el = ((DeclaredType)tm).asElement()).getSimpleName().length() == 0 || fm.contains((Object)el.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> interfaces = ((TypeElement)el).getInterfaces();
            tm = interfaces.isEmpty() ? ((TypeElement)el).getSuperclass() : interfaces.get(0);
        }
        return tm;
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type = JavaPluginUtils.resolveCapturedTypeInt(info, tm);
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            return info.getElements().getTypeElement("java.lang.Object").asType();
        }
        return type;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        WildcardType orig = SourceUtils.resolveCapturedType((TypeMirror)tm);
        if (orig != null) {
            TypeMirror extendsBound;
            WildcardType rct;
            if (orig.getKind() == TypeKind.WILDCARD && (rct = SourceUtils.resolveCapturedType((TypeMirror)((extendsBound = orig.getExtendsBound()) != null ? extendsBound : orig.getSuperBound()))) != null) {
                return rct;
            }
            return orig;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                typeArguments.add(JavaPluginUtils.resolveCapturedTypeInt(info, typeMirror));
            }
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)tm;
            return info.getTypes().getArrayType(JavaPluginUtils.resolveCapturedTypeInt(info, at.getComponentType()));
        }
        return tm;
    }
}

