/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map packagePostfix = new HashMap();
    final AbstractRefactoring refactoring;
    final boolean isRenameRefactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    Set<ElementHandle<TypeElement>> classes;
    Set<ElementHandle<PackageElement>> packages;
    List<List<FileObject>> foldersToMove = new ArrayList<List<FileObject>>();
    Set<String> packageNames;

    public MoveRefactoringPlugin(MoveRefactoring move) {
        this((AbstractRefactoring)move, false);
        this.setup(move.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public MoveRefactoringPlugin(RenameRefactoring rename) {
        this((AbstractRefactoring)rename, true);
        FileObject fo = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        if (fo != null) {
            this.setup(Collections.singletonList(fo), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)rename.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    private MoveRefactoringPlugin(AbstractRefactoring refactoring, boolean isRenameRefactoring) {
        this.refactoring = refactoring;
        if (refactoring == null) {
            throw new NullPointerException();
        }
        this.isRenameRefactoring = isRenameRefactoring;
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        Problem preCheckProblem = null;
        for (FileObject file : this.filesToMove) {
            if (RetoucheUtils.isElementInOpenProject(file)) continue;
            preCheckProblem = MoveRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
        }
        return preCheckProblem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        if (this.isRenameRefactoring) {
            FileObject f = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            if (f != null) {
                String newName = ((RenameRefactoring)this.refactoring).getNewName();
                if (!RetoucheUtils.isValidPackageName(newName)) {
                    String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                    return new Problem(true, msg);
                }
                if (f.getParent().getFileObject(newName, f.getExt()) != null) {
                    String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{newName});
                    return new Problem(true, msg);
                }
            }
            return super.fastCheckParameters();
        }
        if (!this.isRenameRefactoring) {
            try {
                for (FileObject f : this.filesToMove) {
                    if (!RetoucheUtils.isJavaFile(f)) continue;
                    String targetPackageName = this.getTargetPackageName(f);
                    if (!RetoucheUtils.isValidPackageName(targetPackageName)) {
                        String s = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                        String msg = new MessageFormat(s).format(new Object[]{targetPackageName});
                        return new Problem(true, msg);
                    }
                    FileObject targetRoot = RetoucheUtils.getClassPathRoot((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
                    FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                    String pkgName = null;
                    if (targetF != null && !targetF.canWrite()) {
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                    }
                    pkgName = targetPackageName;
                    if (pkgName == null) {
                        pkgName = "";
                    } else if (pkgName.length() > 0) {
                        pkgName = pkgName + '.';
                    }
                    String fileName = f.getName();
                    if (targetF == null) continue;
                    FileObject[] children = targetF.getChildren();
                    for (int x = 0; x < children.length; ++x) {
                        if (!children[x].getName().equals(fileName) || !"java".equals(children[x].getExt()) || children[x].equals(f) || children[x].isVirtual()) continue;
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.fastCheckParameters();
    }

    private Problem checkProjectDeps(Set<FileObject> a) {
        if (!this.isRenameRefactoring) {
            HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
            for (FileObject file : this.filesToMove) {
                ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                if (cp == null) continue;
                FileObject root = cp.findOwnerRoot(file);
                sourceRoots.add(root);
            }
            URL target = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
            if (target == null) {
                return null;
            }
            try {
                FileObject r = RetoucheUtils.getClassPathRoot(target);
                URL targetUrl = URLMapper.findURL((FileObject)r, (int)1);
                Project targetProject = FileOwnerQuery.getOwner((FileObject)r);
                Set deps = SourceUtils.getDependentRoots((URL)targetUrl);
                for (FileObject sourceRoot : sourceRoots) {
                    URL sourceUrl = URLMapper.findURL((FileObject)sourceRoot, (int)0);
                    if (deps.contains(sourceUrl)) continue;
                    Project sourceProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                    for (FileObject affected : a) {
                        if (!FileOwnerQuery.getOwner((FileObject)affected).equals(sourceProject) || this.filesToMove.contains(affected) || sourceProject.equals(targetProject)) continue;
                        assert (sourceProject != null);
                        assert (targetProject != null);
                        String sourceName = ProjectUtils.getInformation((Project)sourceProject).getDisplayName();
                        String targetName = ProjectUtils.getInformation((Project)targetProject).getDisplayName();
                        return MoveRefactoringPlugin.createProblem(null, false, NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_MissingProjectDeps", (Object)sourceName, (Object)targetName));
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        Set files;
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        HashSet<FileObject> set = new HashSet<FileObject>();
        for (ElementHandle<TypeElement> elementHandle : this.classes) {
            files = idx.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(files);
        }
        for (ElementHandle elementHandle : this.packages) {
            files = idx.getResourcesForPackage(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(files);
        }
        set.addAll(this.filesToMove);
        return set;
    }

    private void initClasses() {
        this.classes = new HashSet<ElementHandle<TypeElement>>();
        this.packages = new HashSet<ElementHandle<PackageElement>>();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            int j = i;
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> trees = parameter.getCompilationUnit().getTypeDecls();
                        for (Tree tree : trees) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                            TypeElement klass = (TypeElement)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), tree));
                            MoveRefactoringPlugin.this.classes.add((ElementHandle<TypeElement>)ElementHandle.create((Element)klass));
                            PackageElement packageOf = parameter.getElements().getPackageOf(klass);
                            MoveRefactoringPlugin.this.packages.add((ElementHandle<PackageElement>)ElementHandle.create((Element)packageOf));
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private Problem initPackages() {
        if (this.foldersToMove.isEmpty()) {
            this.packageNames = Collections.emptySet();
            return null;
        }
        this.packageNames = new HashSet<String>();
        for (List<FileObject> folders : this.foldersToMove) {
            ClassPath cp = ClassPath.getClassPath((FileObject)folders.get(0), (String)"classpath/source");
            if (cp == null) {
                return new Problem(true, NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ClasspathNotFound", (Object)folders.get(0)));
            }
            for (FileObject folder : folders) {
                String pkgName = cp.getResourceName(folder, '.', false);
                this.packageNames.add(pkgName);
            }
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        this.fireProgressListenerStart(1, -1);
        this.initClasses();
        Problem p = this.initPackages();
        if (p != null) {
            return p;
        }
        Set<FileObject> a = this.getRelevantFiles();
        p = this.checkProjectDeps(a);
        this.fireProgressListenerStep(a.size());
        MoveTransformer t = new MoveTransformer(this);
        JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, t, null);
        Problem prob = this.createAndAddElements(a, task, elements, this.refactoring);
        this.fireProgressListenerStop();
        return prob != null ? prob : JavaPluginUtils.chainProblems(p, t.getProblem());
    }

    String getNewPackageName() {
        if (this.isRenameRefactoring) {
            return ((RenameRefactoring)this.refactoring).getNewName();
        }
        return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
    }

    String getTargetPackageName(FileObject fo) {
        if (this.isRenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject folder = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(folder);
            String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
            String postfix = FileUtil.getRelativePath((FileObject)folder, (FileObject)(fo.isFolder() ? fo : fo.getParent())).replace('/', '.');
            String t = this.concat(prefix, this.getNewPackageName(), postfix);
            return t;
        }
        if (this.packagePostfix != null) {
            if (fo == null) {
                return this.getNewPackageName();
            }
            String postfix = (String)this.packagePostfix.get(fo);
            String packageName = this.concat(null, this.getNewPackageName(), postfix);
            return packageName;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively) {
        this.setup(fileObjects, postfix, recursively, null);
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively, List<FileObject> sameRootList) {
        for (FileObject fo : fileObjects) {
            if (RetoucheUtils.isJavaFile(fo)) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                this.filesToMove.add(fo);
                continue;
            }
            if (!fo.isFolder()) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) continue;
            boolean addDot = !"".equals(postfix);
            ArrayList<FileObject> col = new ArrayList<FileObject>();
            for (FileObject fo2 : fo.getChildren()) {
                if (fo2.isFolder() && (!fo2.isFolder() || !recursively)) continue;
                col.add(fo2);
            }
            List<FileObject> curRootList = sameRootList;
            if (sameRootList == null) {
                curRootList = new ArrayList<FileObject>();
                this.foldersToMove.add(curRootList);
            }
            curRootList.add(fo);
            this.setup(col, postfix + (addDot ? "." : "") + fo.getName(), recursively, curRootList);
        }
    }

    private String concat(String s1, String s2, String s3) {
        String result = "";
        if (s1 != null && !"".equals(s1)) {
            result = result + s1 + ".";
        }
        result = result + s2;
        if (s3 != null && !"".equals(s3)) {
            result = result + ("".equals(result) ? "" : ".") + s3;
        }
        return result;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return null;
    }
}

