/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public static ShowUI SHOW = new ShowUI(){

        @Override
        public void show(RefactoringUI ui, TopComponent activetc) {
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }
    };

    public void doRename(final Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                Element selected = selectedElement.resolveElement(info);
                if (selected == null) {
                    RefactoringActionsProvider.logger().log(Level.INFO, "doRename: " + selectedElement, new NullPointerException("selected"));
                    return null;
                }
                if (selected.getKind() == ElementKind.CONSTRUCTOR) {
                    selected = selected.getEnclosingElement();
                    TreePath path = info.getTrees().getPath(selected);
                    if (path == null) {
                        RefactoringActionsProvider.logger().log(Level.INFO, "doRename: " + selected, new NullPointerException("selected"));
                        return null;
                    }
                    selectedElement = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                }
                if (selected.getKind() == ElementKind.PACKAGE) {
                    final FileObject pkg = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(selected.toString().replace('.', '/'));
                    if (pkg != null) {
                        NonRecursiveFolder folder = new NonRecursiveFolder(){

                            public FileObject getFolder() {
                                return pkg;
                            }
                        };
                        return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(folder));
                    }
                    if (selected.getSimpleName().length() != 0) {
                        return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(selectedElement, info));
                    }
                    TreePath path = selectedElement.resolve(info);
                    if (path != null && path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(selectedElement.getFileObject(), null, info));
                    }
                    return null;
                }
                if (selected instanceof TypeElement && !((TypeElement)selected).getNestingKind().isNested()) {
                    FileObject f = SourceUtils.getFile((Element)selected, (ClasspathInfo)info.getClasspathInfo());
                    if (f != null && selected.getSimpleName().toString().equals(f.getName())) {
                        return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(f == null ? info.getFileObject() : f, selectedElement, info));
                    }
                    return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(selectedElement, info));
                }
                return RefactoringActionsProvider.this.wrap(new RenameRefactoringUI(selectedElement, info));
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class)), true){
            RefactoringUI ui;

            @Override
            protected void treePathHandleResolved(TreePathHandle handle, CompilationInfo javac) {
                this.ui = this.renameFile ? new RenameRefactoringUI(handle.getFileObject(), handle, javac) : new RenameRefactoringUI(handle, javac);
            }

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> handles) {
                return RefactoringActionsProvider.this.wrap(this.ui);
            }
        } : new NodeToFileObjectTask(Collections.singleton(lookup.lookup(Node.class))){
            RefactoringUI ui;

            @Override
            protected void nodeTranslated(Node node, Collection<TreePathHandle> handles, CompilationInfo javac) {
                String newName = RefactoringActionsProvider.getName(lookup);
                this.ui = newName != null ? new RenameRefactoringUI(javac.getFileObject(), newName, handles == null || handles.isEmpty() ? null : handles.iterator().next(), javac) : new RenameRefactoringUI(javac.getFileObject(), handles == null || handles.isEmpty() ? null : handles.iterator().next(), javac);
            }

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                if (this.ui == null) {
                    String newName = RefactoringActionsProvider.getName(lookup);
                    this.ui = newName != null ? (this.pkg[0] != null ? new RenameRefactoringUI(this.pkg[0], newName) : new RenameRefactoringUI(selectedElements[0], newName, null, null)) : (this.pkg[0] != null ? new RenameRefactoringUI(this.pkg[0]) : new RenameRefactoringUI(selectedElements[0], null, null));
                }
                return RefactoringActionsProvider.this.wrap(this.ui);
            }
        });
        RetoucheUtils.invokeAfterScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
    }

    static String getActionName(Action action) {
        String arg = (String)action.getValue("Name");
        arg = arg.replace("&", "");
        return arg.replace("...", "");
    }

    public boolean canRename(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
        if (tph != null) {
            return RetoucheUtils.isRefactorable(tph.getFileObject());
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fo)) {
            return true;
        }
        return dob instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fo) && RetoucheUtils.isOnSourceClasspath(fo) && !RetoucheUtils.isClasspathRoot(fo);
    }

    public void doCopy(final Lookup lookup) {
        NodeToFileObjectTask task = new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handle) {
                return RefactoringActionsProvider.this.wrap(new CopyClassRefactoringUI(selectedElements[0], RefactoringActionsProvider.this.getTarget(lookup), RefactoringActionsProvider.this.getPaste(lookup)));
            }
        };
        RetoucheUtils.invokeAfterScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.copyAction()));
    }

    public boolean canCopy(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        ExplorerContext dict = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fob = this.getTarget(lookup);
        if (dict != null && dict.getTargetNode() != null && fob == null) {
            return false;
        }
        if (fob != null) {
            if (!fob.isFolder() || !RetoucheUtils.isOnSourceClasspath(fob)) {
                return false;
            }
            FileObject fo = dob.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fo)) {
                return true;
            }
        } else {
            FileObject fo = dob.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fo)) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        if (n.getLookup().lookup(TreePathHandle.class) != null) {
            return true;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        return dob != null && RetoucheUtils.isJavaFile(dob.getPrimaryFile()) && !"package-info".equals(dob.getName());
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                return RefactoringActionsProvider.this.wrap(new WhereUsedQueryUI(selectedElement, info));
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class)), true){
            RefactoringUI ui;

            @Override
            protected void treePathHandleResolved(TreePathHandle handle, CompilationInfo javac) {
                this.ui = new WhereUsedQueryUI(handle, javac);
            }

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> handles) {
                return RefactoringActionsProvider.this.wrap(this.ui);
            }
        } : new NodeToElementTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, CompilationInfo info) {
                if (selectedElement == null) {
                    return null;
                }
                return RefactoringActionsProvider.this.wrap(new WhereUsedQueryUI(selectedElement, info));
            }
        });
        RetoucheUtils.invokeAfterScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.whereUsedAction()));
    }

    public boolean canDelete(Lookup lookup) {
        if (SourceUtils.isScanInProgress()) {
            return false;
        }
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (RefactoringActionsProvider.isSelectionHeterogeneous(nodes)) {
            return false;
        }
        for (Node n : nodes) {
            TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
            if (tph != null) {
                return RetoucheUtils.isRefactorable(tph.getFileObject());
            }
            DataObject dataObject = (DataObject)n.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                return true;
            }
            if (RetoucheUtils.isRefactorable(fileObject)) continue;
            return false;
        }
        return !nodes.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        boolean b;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        boolean bl = b = lookup.lookup(ExplorerContext.class) != null;
        Runnable task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                Element selected = selectedElement.resolveElement(info);
                if (selected == null) {
                    RefactoringActionsProvider.logger().log(Level.INFO, "doDelete: " + selectedElement, new NullPointerException("selected"));
                    return null;
                }
                if (selected.getKind() == ElementKind.PACKAGE || selected.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                    FileObject file = SourceUtils.getFile((Element)selected, (ClasspathInfo)info.getClasspathInfo());
                    if (file == null) {
                        return null;
                    }
                    if (file.getName().equals(selected.getSimpleName().toString())) {
                        return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(new FileObject[]{file}, Collections.singleton(selectedElement), b));
                    }
                }
                return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(new TreePathHandle[]{selectedElement}));
            }
        } : (RefactoringActionsProvider.nodeHandle(lookup) ? new TreePathHandleTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(Collection<TreePathHandle> handles) {
                if (this.renameFile) {
                    FileObject[] files = new FileObject[handles.size()];
                    int i = 0;
                    for (TreePathHandle handle : handles) {
                        files[i++] = handle.getFileObject();
                    }
                    return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(files, handles, b));
                }
                return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(handles.toArray(new TreePathHandle[handles.size()])));
            }
        } : new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                if (this.pkg[0] != null) {
                    return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(this.pkg[0], b));
                }
                return RefactoringActionsProvider.this.wrap(new SafeDeleteUI(selectedElements, handles, b));
            }
        });
        RetoucheUtils.invokeAfterScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.safeDeleteAction()));
    }

    private FileObject getTarget(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Transferable orig = drop.getTransferable();
        if (orig == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        PasteType[] pt = n.getPasteTypes(orig);
        if (pt.length == 1) {
            return null;
        }
        return pt[1];
    }

    static String getName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }

    public boolean canMove(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        ExplorerContext drop = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fo = this.getTarget(lookup);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            if (!RetoucheUtils.isOnSourceClasspath(fo)) {
                return false;
            }
            HashSet<DataFolder> folders = new HashSet<DataFolder>();
            boolean jdoFound = false;
            for (Node n : nodes) {
                DataObject dob = (DataObject)n.getCookie(DataObject.class);
                if (dob == null) {
                    return false;
                }
                if (!RetoucheUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                    return false;
                }
                if (dob instanceof DataFolder) {
                    if (FileUtil.getRelativePath((FileObject)dob.getPrimaryFile(), (FileObject)fo) != null) {
                        return false;
                    }
                    folders.add((DataFolder)dob);
                    continue;
                }
                if (!RetoucheUtils.isJavaFile(dob.getPrimaryFile())) continue;
                jdoFound = true;
            }
            if (jdoFound) {
                return true;
            }
            for (DataFolder fold : folders) {
                Enumeration e = fold.children(true);
                while (e.hasMoreElements()) {
                    if (!RetoucheUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean result = false;
        block3: for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (dob instanceof DataFolder) {
                if (drop == null) {
                    return false;
                }
                if (!RetoucheUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RetoucheUtils.isClasspathRoot(dob.getPrimaryFile())) {
                    return false;
                }
                LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
                folders.add((DataFolder)dob);
                while (!folders.isEmpty()) {
                    DataFolder fold = (DataFolder)folders.remove();
                    Enumeration e = fold.children(true);
                    while (e.hasMoreElements()) {
                        if (RetoucheUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) {
                            result = true;
                            continue block3;
                        }
                        if (!(e instanceof DataFolder)) continue;
                        folders.add((DataFolder)e);
                    }
                }
            }
            if (!RetoucheUtils.isOnSourceClasspath(dob.getPrimaryFile())) {
                return false;
            }
            if (!RetoucheUtils.isJavaFile(dob.getPrimaryFile())) continue;
            result = true;
        }
        return result;
    }

    public void doMove(final Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable task = RefactoringActionsProvider.isFromEditor(ec) ? new TextComponentTask(ec){

            @Override
            protected RefactoringUI createRefactoringUI(TreePathHandle selectedElement, int startOffset, int endOffset, CompilationInfo info) {
                Element e = selectedElement.resolveElement(info);
                if (e == null) {
                    RefactoringActionsProvider.logger().log(Level.INFO, "doMove: " + selectedElement, new NullPointerException("e"));
                    return null;
                }
                if ((e.getKind().isClass() || e.getKind().isInterface()) && SourceUtils.getOutermostEnclosingTypeElement((Element)e) == e) {
                    try {
                        DataObject d;
                        FileObject fo = SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo());
                        if (fo != null && (d = DataObject.find((FileObject)SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()))).getName().equals(e.getSimpleName().toString())) {
                            return RefactoringActionsProvider.this.wrap(new MoveClassUI(d));
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (selectedElement.resolve(info).getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    try {
                        return RefactoringActionsProvider.this.wrap(new MoveClassUI(DataObject.find((FileObject)info.getFileObject())));
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    return RefactoringActionsProvider.this.wrap(new MoveClassUI(DataObject.find((FileObject)info.getFileObject())));
                }
                catch (DataObjectNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        } : new NodeToFileObjectTask(new HashSet(lookup.lookupAll(Node.class))){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] selectedElements, Collection<TreePathHandle> handles) {
                PasteType paste = RefactoringActionsProvider.this.getPaste(lookup);
                FileObject tar = RefactoringActionsProvider.this.getTarget(lookup);
                if (selectedElements.length == 1) {
                    if (!selectedElements[0].isFolder()) {
                        try {
                            return RefactoringActionsProvider.this.wrap(new MoveClassUI(DataObject.find((FileObject)selectedElements[0]), tar, paste, handles));
                        }
                        catch (DataObjectNotFoundException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    HashSet<FileObject> s = new HashSet<FileObject>();
                    s.addAll(Arrays.asList(selectedElements));
                    return RefactoringActionsProvider.this.wrap(new MoveClassesUI(s, tar, paste));
                }
                HashSet<FileObject> s = new HashSet<FileObject>();
                s.addAll(Arrays.asList(selectedElements));
                return RefactoringActionsProvider.this.wrap(new MoveClassesUI(s, tar, paste));
            }
        };
        RetoucheUtils.invokeAfterScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
    }

    protected RefactoringUI wrap(RefactoringUI orig) {
        return orig;
    }

    private static boolean isSelectionHeterogeneous(Collection<? extends Node> nodes) {
        boolean folderSelected = false;
        boolean nonFolderNodeSelected = false;
        for (Node node : nodes) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) continue;
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                if (folderSelected || nonFolderNodeSelected) {
                    return true;
                }
                folderSelected = true;
                continue;
            }
            nonFolderNodeSelected = true;
        }
        return false;
    }

    static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        if (ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
            return ec.getDocument() != null;
        }
        return false;
    }

    static boolean nodeHandle(Lookup lookup) {
        Node n = (Node)lookup.lookup(Node.class);
        return n != null && n.getLookup().lookup(TreePathHandle.class) != null;
    }

    private static boolean isRefactorableFolder(DataObject dataObject) {
        FileObject[] children;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!(Boolean.TRUE.equals(fileObject.getAttribute("isRemoteAndSlow")) || (children = fileObject.getChildren()) != null && children.length > 0)) {
            return false;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    private static Logger logger() {
        return Logger.getLogger(RefactoringActionsProvider.class.getName());
    }

    public static interface ShowUI {
        public void show(RefactoringUI var1, TopComponent var2);
    }

    public static abstract class NodeToFileObjectTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<? extends Node> nodes;
        public NonRecursiveFolder[] pkg;
        Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private Node currentNode;

        public NodeToFileObjectTask(Collection<? extends Node> nodes) {
            this.nodes = nodes;
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            ArrayList<TreePathHandle> handlesPerNode = new ArrayList<TreePathHandle>();
            CompilationUnitTree unit = info.getCompilationUnit();
            ArrayList<TreePathHandle> publicHandles = new ArrayList<TreePathHandle>();
            ArrayList<TreePathHandle> sameNameHandles = new ArrayList<TreePathHandle>();
            for (Tree tree : unit.getTypeDecls()) {
                TreePathHandle representedObject;
                Element e = info.getTrees().getElement(TreePath.getPath(unit, tree));
                if (e == null || !e.getKind().isClass() && !e.getKind().isInterface()) continue;
                if (e.getSimpleName().toString().equals(info.getFileObject().getName())) {
                    representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
                    sameNameHandles.add(representedObject);
                }
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, tree), (CompilationInfo)info);
                publicHandles.add(representedObject);
            }
            if (!publicHandles.isEmpty()) {
                handlesPerNode.addAll(publicHandles);
            } else {
                handlesPerNode.addAll(sameNameHandles);
            }
            if (!handlesPerNode.isEmpty()) {
                this.handles.addAll(handlesPerNode);
                this.nodeTranslated(this.currentNode, handlesPerNode, (CompilationInfo)info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileObject[] fobs = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fobs.length];
            int i = 0;
            for (Node node : this.nodes) {
                DataObject dob = (DataObject)node.getCookie(DataObject.class);
                if (dob == null) continue;
                fobs[i] = dob.getPrimaryFile();
                if (RetoucheUtils.isJavaFile(fobs[i])) {
                    JavaSource source = JavaSource.forFileObject((FileObject)fobs[i]);
                    assert (source != null);
                    try {
                        this.currentNode = node;
                        source.runUserActionTask((Task)this, true);
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this.currentNode = null;
                    }
                }
                this.pkg[i++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            RefactoringUI ui = this.createRefactoringUI(fobs, this.handles);
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected void nodeTranslated(Node node, Collection<TreePathHandle> handles, CompilationInfo javac) {
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<TreePathHandle> var2);
    }

    public static abstract class NodeToElementTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends Node> nodes) {
            assert (nodes.size() == 1);
            this.node = nodes.iterator().next();
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            CompilationUnitTree unit = info.getCompilationUnit();
            if (unit.getTypeDecls().isEmpty()) {
                this.ui = this.createRefactoringUI(null, (CompilationInfo)info);
            } else {
                TreePathHandle representedObject = TreePathHandle.create((TreePath)TreePath.getPath(unit, unit.getTypeDecls().get(0)), (CompilationInfo)info);
                this.ui = this.createRefactoringUI(representedObject, (CompilationInfo)info);
            }
        }

        @Override
        public final void run() {
            DataObject o = (DataObject)this.node.getCookie(DataObject.class);
            JavaSource source = JavaSource.forFileObject((FileObject)o.getPrimaryFile());
            assert (source != null);
            try {
                source.runUserActionTask((Task)this, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_NoTypeDecls"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, CompilationInfo var2);
    }

    public static abstract class TextComponentTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;
        private boolean selection;

        public TextComponentTask(EditorCookie ec) {
            this(ec, false);
        }

        public TextComponentTask(EditorCookie ec, boolean selection) {
            this.selection = selection;
            this.textC = ec.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void cancel() {
        }

        public void run(final CompilationController cc) throws Exception {
            TreePath path;
            List<? extends Tree> decls;
            TreePath selectedElement = null;
            cc.toPhase(JavaSource.Phase.RESOLVED);
            final int c = this.selection ? this.start : this.caret;
            final int[] adjustedCaret = new int[]{c};
            Document doc = cc.getDocument();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)cc.getTokenHierarchy(), (int)c);
                    ts.move(c);
                    if (ts.moveNext() && ts.token() != null && ts.token().id() == JavaTokenId.IDENTIFIER) {
                        adjustedCaret[0] = ts.offset() + ts.token().length() / 2 + 1;
                    }
                }
            });
            selectedElement = cc.getTreeUtilities().pathFor(adjustedCaret[0]);
            if (selectedElement.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(decls = cc.getCompilationUnit().getTypeDecls()).isEmpty() && (path = TreePath.getPath(cc.getCompilationUnit(), decls.get(0))) != null && cc.getTrees().getElement(path) != null) {
                selectedElement = path;
            }
            this.ui = this.createRefactoringUI(TreePathHandle.create((TreePath)selectedElement, (CompilationInfo)cc), this.start, this.end, (CompilationInfo)cc);
        }

        @Override
        public final void run() {
            try {
                JavaSource source = JavaSource.forDocument((Document)this.textC.getDocument());
                source.runUserActionTask((Task)this, true);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                return;
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            SHOW.show(this.ui, activetc);
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);
    }

    public static abstract class TreePathHandleTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();
        private TreePathHandle current;
        boolean renameFile;

        public TreePathHandleTask(Collection<? extends Node> nodes) {
            this(nodes, false);
        }

        public TreePathHandleTask(Collection<? extends Node> nodes, boolean useFirstHandle) {
            for (Node node : nodes) {
                TreePathHandle temp = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
                if (temp == null) continue;
                this.handles.add(temp);
                if (!useFirstHandle) continue;
                break;
            }
        }

        public TreePathHandleTask(TreePathHandle tph) {
            this.handles.add(tph);
        }

        public void cancel() {
        }

        public void run(CompilationController info) throws Exception {
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Element el = this.current.resolveElement((CompilationInfo)info);
            if (el != null && el instanceof TypeElement && !((TypeElement)el).getNestingKind().isNested() && info.getFileObject().getName().equals(el.getSimpleName().toString())) {
                this.renameFile = true;
            }
            this.treePathHandleResolved(this.current, (CompilationInfo)info);
        }

        @Override
        public void run() {
            for (TreePathHandle handle : this.handles) {
                FileObject f = handle.getFileObject();
                if (f == null) {
                    TopComponent top = (TopComponent)EditorRegistry.lastFocusedComponent().getParent().getParent().getParent().getParent();
                    f = (FileObject)top.getLookup().lookup(FileObject.class);
                }
                this.current = handle;
                JavaSource source = JavaSource.forFileObject((FileObject)f);
                assert (source != null);
                try {
                    source.runUserActionTask((Task)this, true);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            RefactoringUI ui = this.createRefactoringUI(this.handles);
            if (ui != null) {
                UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected void treePathHandleResolved(TreePathHandle handle, CompilationInfo javac) {
        }

        protected abstract RefactoringUI createRefactoringUI(Collection<TreePathHandle> var1);
    }
}

