/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient SafeDeleteRefactoring refactoring;
    private boolean regulardelete;
    private ChangeListener parent;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel checkBoxes;
    private JLabel label;
    private JCheckBox searchInComments;
    private JCheckBox safeDelete;

    public SafeDeletePanel(SafeDeleteRefactoring refactoring, boolean regulardelete, ChangeListener parent) {
        this.setName(NbBundle.getMessage(SafeDeletePanel.class, (String)(regulardelete ? "LBL_SafeDel_Delete" : "LBL_SafeDel")));
        this.refactoring = refactoring;
        this.regulardelete = regulardelete;
        this.parent = parent;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    public void initialize() {
        String labelText;
        this.searchInComments.setEnabled(true);
        if (this.initialized) {
            return;
        }
        Lookup lkp = this.refactoring.getRefactoringSource();
        NonRecursiveFolder folder = (NonRecursiveFolder)lkp.lookup(NonRecursiveFolder.class);
        Collection files = lkp.lookupAll(FileObject.class);
        final Collection handles = lkp.lookupAll(TreePathHandle.class);
        if (folder != null) {
            String pkgName = folder.getFolder().getNameExt().replace('/', '.');
            labelText = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelPkg", (Object)pkgName);
        } else if (files.size() > 1 && files.size() == handles.size()) {
            labelText = this.regulardelete ? NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_RegularDelete", (Object)handles.size()) : NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Classes", (Object)handles.size());
        } else if (handles.size() > 1) {
            labelText = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Classes", (Object)handles.size());
        } else if (handles.size() == 1) {
            JavaSource s = JavaSource.forFileObject((FileObject)((TreePathHandle)handles.iterator().next()).getFileObject());
            final String[] name = new String[1];
            try {
                s.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.RESOLVED);
                        Element resolvedElement = ((TreePathHandle)handles.iterator().next()).resolveElement((CompilationInfo)parameter);
                        if (resolvedElement == null) {
                            throw new NullPointerException("Please attach your {nb.userdir}/var/log/messages.log to http://www.netbeans.org/issues/show_bug.cgi?id=115462\nhandle: " + handles.iterator().next() + "\nclasspath: " + parameter.getClasspathInfo());
                        }
                        name[0] = resolvedElement.getKind() == ElementKind.CONSTRUCTOR ? resolvedElement.getEnclosingElement().getSimpleName().toString() : resolvedElement.getSimpleName().toString();
                    }
                }, true);
            }
            catch (IOException ioe) {
                throw (RuntimeException)new RuntimeException().initCause(ioe);
            }
            labelText = this.regulardelete ? NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_RegularDeleteElement", (Object)name[0]) : NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Element", (Object)name[0]);
        } else {
            boolean isSingleFolderSelected;
            FileObject fileObject = (FileObject)files.iterator().next();
            boolean bl = isSingleFolderSelected = files != null && files.size() == 1 && fileObject.isFolder();
            if (isSingleFolderSelected && !this.regulardelete) {
                String folderName = fileObject.getName();
                labelText = NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelFolder", (Object)folderName);
            } else {
                labelText = "";
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SafeDeletePanel.this.regulardelete) {
                    SafeDeletePanel.this.safeDelete = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)SafeDeletePanel.this.safeDelete, (String)NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelCheckBox"));
                    SafeDeletePanel.this.safeDelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SafeDeletePanel.class, (String)"SafeDeletePanel.safeDelete.AccessibleContext.accessibleDescription"));
                    SafeDeletePanel.this.safeDelete.setMargin(new Insets(2, 14, 2, 2));
                    SafeDeletePanel.this.searchInComments.setEnabled(false);
                    SafeDeletePanel.this.safeDelete.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent evt) {
                            SafeDeletePanel.this.searchInComments.setEnabled(SafeDeletePanel.this.safeDelete.isSelected());
                            SafeDeletePanel.this.parent.stateChanged(null);
                        }
                    });
                    SafeDeletePanel.this.checkBoxes.add((Component)SafeDeletePanel.this.safeDelete, "Center");
                }
                SafeDeletePanel.this.label.setText(labelText);
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    boolean isRegularDelete() {
        if (this.safeDelete != null) {
            return !this.safeDelete.isSelected();
        }
        return false;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.checkBoxes = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.checkBoxes.setLayout(new BorderLayout());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.checkBoxes.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)bundle.getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(2, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.checkBoxes.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.checkBoxes, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
        this.refactoring.setCheckInComments(b.booleanValue());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

