/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.util.EnumSet;
import javax.lang.model.element.ElementKind;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.refactoring.java.api.MemberInfo;

public final class UIUtilities {
    public static EnumSet allowedElementKinds = EnumSet.of(ElementKind.PACKAGE, new ElementKind[]{ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE, ElementKind.METHOD, ElementKind.CONSTRUCTOR, ElementKind.INSTANCE_INIT, ElementKind.STATIC_INIT, ElementKind.FIELD, ElementKind.ENUM_CONSTANT, ElementKind.TYPE_PARAMETER});

    private UIUtilities() {
    }

    public static String getColumnName(String name) {
        return name == null || name.length() == 0 ? " " : name;
    }

    public static void initColumnWidth(JTable table, int index, Object longValue, int padding) {
        TableColumn column = table.getColumnModel().getColumn(index);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        comp = table.getDefaultRenderer(table.getModel().getColumnClass(index)).getTableCellRendererComponent(table, longValue, false, false, 0, index);
        width = Math.max(width, comp.getPreferredSize().width) + 2 * padding;
        column.setPreferredWidth(width);
        if (longValue instanceof Boolean) {
            column.setMaxWidth(width);
        }
    }

    public static class BooleanTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer checkbox;
        private final TableCellRenderer label;

        public BooleanTableCellRenderer(JTable jt) {
            this(jt.getDefaultRenderer(String.class), jt.getDefaultRenderer(Boolean.class));
        }

        private BooleanTableCellRenderer(TableCellRenderer label, TableCellRenderer checkbox) {
            this.checkbox = checkbox;
            this.label = label;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer rend = value == null || !table.getModel().isCellEditable(row, column) ? this.label : this.checkbox;
            value = value != null && rend == this.label ? null : value;
            Component comp = rend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return comp;
        }
    }

    public static class JavaElementListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, this.extractText(value), index, isSelected, cellHasFocus);
            if (value instanceof MemberInfo) {
                Icon i = ((MemberInfo)value).getIcon();
                this.setIcon(i);
            }
            return this;
        }

        protected String extractText(Object value) {
            if (value instanceof MemberInfo) {
                return ((MemberInfo)value).getHtmlText();
            }
            return value.toString();
        }
    }

    public static class JavaElementTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, this.extractText(value), isSelected, hasFocus, row, column);
            if (value instanceof MemberInfo) {
                Icon i = ((MemberInfo)value).getIcon();
                this.setIcon(i);
            } else {
                this.setIcon(null);
            }
            return this;
        }

        protected String extractText(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof MemberInfo) {
                return ((MemberInfo)value).getHtmlText();
            }
            return value.toString();
        }
    }
}

