/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.JGitText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RepositoryState {
    BARE{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return false;
        }

        public String getDescription() {
            return "Bare";
        }
    }
    ,
    SAFE{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_normal;
        }
    }
    ,
    MERGING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return false;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_conflicts;
        }
    }
    ,
    MERGING_RESOLVED{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_merged;
        }
    }
    ,
    CHERRY_PICKING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return false;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_conflicts;
        }
    }
    ,
    CHERRY_PICKING_RESOLVED{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_merged;
        }
    }
    ,
    REBASING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_rebaseOrApplyMailbox;
        }
    }
    ,
    REBASING_REBASING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_rebase;
        }
    }
    ,
    APPLY{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_applyMailbox;
        }
    }
    ,
    REBASING_MERGE{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_rebaseWithMerge;
        }
    }
    ,
    REBASING_INTERACTIVE{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_rebaseInteractive;
        }
    }
    ,
    BISECTING{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return JGitText.get().repositoryState_bisecting;
        }
    };


    public abstract boolean canCheckout();

    public abstract boolean canCommit();

    public abstract boolean canResetHead();

    public abstract String getDescription();
}

