/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflogReader {
    private File logName;

    ReflogReader(Repository db, String refname) {
        this.logName = new File(db.getDirectory(), "logs/" + refname);
    }

    public Entry getLastEntry() throws IOException {
        List<Entry> entries = this.getReverseEntries(1);
        return entries.size() > 0 ? entries.get(0) : null;
    }

    public List<Entry> getReverseEntries() throws IOException {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    public List<Entry> getReverseEntries(int max) throws IOException {
        byte[] log;
        try {
            log = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        int rs = RawParseUtils.prevLF(log, log.length);
        ArrayList<Entry> ret = new ArrayList<Entry>();
        while (rs >= 0 && max-- > 0) {
            Entry entry = new Entry(log, (rs = RawParseUtils.prevLF(log, rs)) < 0 ? 0 : rs + 2);
            ret.add(entry);
        }
        return ret;
    }

    public static class Entry {
        private ObjectId oldId;
        private ObjectId newId;
        private PersonIdent who;
        private String comment;

        Entry(byte[] raw, int pos) {
            int p1;
            this.oldId = ObjectId.fromString(raw, pos);
            pos += 40;
            if (raw[pos++] != 32) {
                throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
            }
            this.newId = ObjectId.fromString(raw, pos);
            pos += 40;
            if (raw[pos++] != 32) {
                throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
            }
            this.who = RawParseUtils.parsePersonIdentOnly(raw, pos);
            int p0 = RawParseUtils.next(raw, pos, '\t');
            this.comment = p0 >= raw.length ? "" : ((p1 = RawParseUtils.nextLF(raw, p0)) > p0 ? RawParseUtils.decode(raw, p0, p1 - 1) : "");
        }

        public ObjectId getOldId() {
            return this.oldId;
        }

        public ObjectId getNewId() {
            return this.newId;
        }

        public PersonIdent getWho() {
            return this.who;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return "Entry[" + this.oldId.name() + ", " + this.newId.name() + ", " + this.getWho() + ", " + this.getComment() + "]";
        }
    }
}

