/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class RemoteFileUtil {
    public static boolean fileExists(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(RemoteFileUtil.normalizeAbsolutePath(absolutePath, executionEnvironment), executionEnvironment);
        return fo != null && fo.isValid();
    }

    public static boolean fileExists(String absolutePath, ExecutionEnvironment executionEnvironment, RemoteProject.Mode remoteMode) {
        executionEnvironment = remoteMode == RemoteProject.Mode.REMOTE_SOURCES ? executionEnvironment : ExecutionEnvironmentFactory.getLocal();
        return RemoteFileUtil.fileExists(RemoteFileUtil.normalizeAbsolutePath(absolutePath, executionEnvironment), executionEnvironment);
    }

    public static boolean isDirectory(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(absolutePath, executionEnvironment);
        return fo != null && fo.isFolder();
    }

    public static FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        FileObject result = FileSystemProvider.getFileObject((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
        if (result == null) {
            String absRootPath = CndPathUtilitities.toAbsolutePath((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
            try {
                FileSystem fs = baseFileObject.getFileSystem();
                result = CndFileUtils.isLocalFileSystem((FileSystem)fs) ? CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)absRootPath)) : InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)absRootPath);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                result = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)InvalidFileObjectSupport.getDummyFileSystem(), (CharSequence)absRootPath);
            }
        }
        return result;
    }

    private RemoteFileUtil() {
    }

    public static FileObject getFileObject(String absolutePath, ExecutionEnvironment execEnv, RemoteProject.Mode remoteMode) {
        switch (remoteMode) {
            case LOCAL_SOURCES: {
                return RemoteFileUtil.getFileObject(absolutePath, ExecutionEnvironmentFactory.getLocal());
            }
            case REMOTE_SOURCES: {
                return RemoteFileUtil.getFileObject(absolutePath, execEnv);
            }
        }
        throw new IllegalArgumentException("Unexpected remote mode: " + (Object)((Object)remoteMode));
    }

    public static FileObject getFileObject(String absolutePath, ExecutionEnvironment execEnv) {
        CndUtils.assertAbsolutePathInConsole((String)absolutePath, (String)"path for must be absolute");
        if (execEnv.isRemote()) {
            String normalizedPath;
            if (CndUtils.isDebugMode() && !(normalizedPath = RemoteFileUtil.normalizeAbsolutePath(absolutePath, execEnv)).equals(absolutePath)) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Warning: path is not normalized:  absolute path is _" + absolutePath + "_ normailzed path is _" + normalizedPath + "_"));
            }
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)execEnv).findResource(absolutePath);
        }
        return CndFileUtils.toFileObject((CharSequence)absolutePath);
    }

    public static FileSystem getProjectSourceFileSystem(Project project) {
        if (project != null) {
            RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (remoteProject != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
                return FileSystemProvider.getFileSystem((ExecutionEnvironment)remoteProject.getSourceFileSystemHost());
            }
            try {
                return project.getProjectDirectory().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return CndFileUtils.getLocalFileSystem();
    }

    public static FileObject getProjectSourceBaseFileObject(Project project) {
        if (project != null) {
            RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (remoteProject != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
                return remoteProject.getSourceBaseDirFileObject();
            }
            return project.getProjectDirectory();
        }
        return null;
    }

    public static ExecutionEnvironment getProjectSourceExecutionEnvironment(Project project) {
        RemoteProject remoteProject;
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null) {
            return remoteProject.getSourceFileSystemHost();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static FileObject getFileObject(String absolutePath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        absolutePath = FileSystemProvider.normalizeAbsolutePath((String)absolutePath, (ExecutionEnvironment)execEnv);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.getFileObject(absolutePath, execEnv);
        }
        FileObject projectDir = project.getProjectDirectory();
        CndUtils.assertNotNull((Object)projectDir, (CharSequence)"Null project dir for ", (Object)project);
        try {
            FileSystem fs = projectDir.getFileSystem();
            return fs.findResource(absolutePath);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String normalizeAbsolutePath(String absPath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.normalizeAbsolutePath(absPath, execEnv);
        }
        return CndFileUtils.normalizeAbsolutePath((String)absPath);
    }

    public static String normalizeAbsolutePath(String absPath, ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            return FileSystemProvider.normalizeAbsolutePath((String)absPath, (ExecutionEnvironment)execEnv);
        }
        return FileUtil.normalizePath((String)absPath);
    }

    public static String getAbsolutePath(FileObject fileObject) {
        return fileObject.getPath();
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        File file = FileUtil.toFile((FileObject)fo);
        return file == null ? fo.getPath() : file.getCanonicalPath();
    }

    public static JFileChooser createFileChooser(RemoteProject.Mode remoteMode, ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        return RemoteFileUtil.createFileChooser(remoteMode == RemoteProject.Mode.REMOTE_SOURCES ? execEnv : ExecutionEnvironmentFactory.getLocal(), titleText, buttonText, mode, filters, initialPath, useParent);
    }

    public static JFileChooser createFileChooser(FileSystem fs, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        return RemoteFileUtil.createFileChooser(env, titleText, buttonText, mode, filters, initialPath, useParent);
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        FileChooser fileChooser;
        if (execEnv.isLocal()) {
            fileChooser = new FileChooser(titleText, buttonText, mode, filters, initialPath, useParent);
        } else {
            FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(execEnv).setPreferences(NbPreferences.forModule(RemoteFileUtil.class));
            fileChooser = fileChooserBuilder.createFileChooser(initialPath);
            fileChooser.setApproveButtonText(buttonText);
            fileChooser.setDialogTitle(titleText);
            fileChooser.setFileSelectionMode(mode);
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    fileChooser.addChoosableFileFilter(filters[i]);
                }
                fileChooser.setFileFilter(filters[0]);
            }
        }
        return fileChooser;
    }

    public static JFileChooser createProjectChooser(ExecutionEnvironment execEnv, String titleText, String description, String buttonText, String initialPath) {
        JFileChooser fileChooser;
        if (execEnv.isLocal()) {
            fileChooser = ProjectChooser.projectChooser();
            fileChooser.getAccessibleContext().setAccessibleDescription(description);
            fileChooser.setDialogTitle(titleText);
            fileChooser.setApproveButtonText(buttonText);
            if (initialPath != null) {
                fileChooser.setCurrentDirectory(new File(initialPath));
            }
        } else {
            fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileUtil.createFileChooser(execEnv, titleText, buttonText, 1, null, initialPath, true);
            fileChooser.setFileView(new ProjectSelectionFileView(fileChooser));
        }
        return fileChooser;
    }

    public static String getProjectsFolder(ExecutionEnvironment env) {
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("ProjectPath" + envID, null);
    }

    public static void setProjectsFolder(String folder, ExecutionEnvironment env) {
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        pref.put("ProjectPath" + envID, folder);
    }

    public static String getCurrentChooserFile(ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                return FileChooser.getCurrentChooserFile().getPath();
            }
            return null;
        }
        Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("FileChooserPath" + envID, null);
    }

    public static void setCurrentChooserFile(String path, ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                FileChooser.setCurrentChooserFile((File)new File(path));
            }
        } else {
            Preferences pref = NbPreferences.forModule(RemoteFileUtil.class);
            String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
            pref.put("FileChooserPath" + envID, path);
        }
    }

    private static final class ProjectSelectionFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public ProjectSelectionFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                ProjectSelectionFileView projectSelectionFileView = this;
                synchronized (projectSelectionFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            ProjectSelectionFileView projectSelectionFileView = this;
            synchronized (projectSelectionFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

