/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.openide.util.Parameters;
import org.w3c.dom.Element;

public class Utilities {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    private Utilities() {
    }

    public static boolean isSupportedVersion(HudsonVersion version) {
        if (null == version) {
            return false;
        }
        return version.compareTo(HudsonVersion.SUPPORTED_VERSION) >= 0;
    }

    public static String uriEncode(String path) {
        Parameters.notNull((CharSequence)"segment", (Object)path);
        try {
            return new URI(null, path, null).toASCIIString();
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static String uriDecode(String string) {
        String d = URI.create(string).getPath();
        if (d.contains("/")) {
            throw new IllegalArgumentException(d);
        }
        return d;
    }

    public static synchronized String xpath(String expr, Element xml) {
        try {
            return xpath.evaluate(expr, xml);
        }
        catch (XPathExpressionException x) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, "cannot evaluate '" + expr + "'", x);
            return null;
        }
    }
}

