/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.hudson.api.HudsonChangeAdapter;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.impl.HudsonViewImpl;
import org.netbeans.modules.hudson.impl.RemoteFileSystem;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.notification.ProblemNotificationController;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class HudsonInstanceImpl
implements HudsonInstance,
OpenableInBrowser {
    private static final Logger LOG = Logger.getLogger(HudsonInstanceImpl.class.getName());
    private HudsonInstanceProperties properties;
    private final HudsonConnector connector;
    private HudsonVersion version;
    private boolean connected;
    private boolean forbidden;
    private boolean terminated;
    private final RequestProcessor RP;
    private final RequestProcessor.Task synchronization;
    private Collection<HudsonJob> jobs = new ArrayList<HudsonJob>();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private HudsonView primaryView;
    private final Collection<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private ProblemNotificationController problemNotificationController;
    private final Map<String, Reference<RemoteFileSystem>> workspaces = new HashMap<String, Reference<RemoteFileSystem>>();
    private final Map<String, Reference<RemoteFileSystem>> artifacts = new HashMap<String, Reference<RemoteFileSystem>>();

    private HudsonInstanceImpl(HudsonInstanceProperties properties, boolean interactive) {
        this.properties = properties;
        this.connector = new HudsonConnector(this);
        this.RP = new RequestProcessor(this.getUrl(), 1, true);
        final AtomicBoolean firstSynch = new AtomicBoolean(interactive);
        this.synchronization = this.RP.create(new Runnable(){

            @Override
            public void run() {
                String s = (String)HudsonInstanceImpl.this.getProperties().get("sync_time");
                int pause = Integer.parseInt(s) * 60 * 1000;
                if (pause > 0 || firstSynch.compareAndSet(true, false)) {
                    HudsonInstanceImpl.this.doSynchronize(false);
                }
                if (pause > 0) {
                    HudsonInstanceImpl.this.synchronization.schedule(pause);
                }
            }
        });
        this.synchronization.schedule(0);
        this.properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("sync_time")) {
                    HudsonInstanceImpl.this.synchronization.schedule(0);
                }
            }
        });
        final HudsonInstanceImpl instance = this;
        this.addHudsonChangeListener(new HudsonChangeAdapter(){

            @Override
            public void contentChanged() {
                ArrayList<HudsonJob> failedJobs = new ArrayList<HudsonJob>();
                for (HudsonJob job : HudsonInstanceImpl.this.getJobs()) {
                    if (!job.getColor().equals((Object)HudsonJob.Color.red) && !job.getColor().equals((Object)HudsonJob.Color.red_anime)) continue;
                    failedJobs.add(job);
                }
                if (HudsonInstanceImpl.this.problemNotificationController == null) {
                    HudsonInstanceImpl.this.problemNotificationController = new ProblemNotificationController(instance);
                }
                HudsonInstanceImpl.this.problemNotificationController.updateNotifications();
            }
        });
    }

    @Override
    public boolean isPersisted() {
        return this.properties.isPersisted();
    }

    public void makePersistent() {
        if (this.isPersisted()) {
            return;
        }
        String name = (String)this.properties.get("name");
        String url = (String)this.properties.get("url");
        String sync = (String)this.properties.get("sync_time");
        HudsonInstanceProperties newProps = new HudsonInstanceProperties(name, url, sync);
        for (Map.Entry ent : this.properties.entrySet()) {
            newProps.put((String)ent.getKey(), (String)ent.getValue());
        }
        List<PropertyChangeListener> list = this.properties.getCurrentListeners();
        for (PropertyChangeListener listener : list) {
            newProps.addPropertyChangeListener(listener);
            this.properties.removePropertyChangeListener(listener);
        }
        this.properties = newProps;
        this.storeDefinition();
        this.fireContentChanges();
    }

    void storeDefinition() {
        if (!this.isPersisted()) {
            return;
        }
        Preferences node = this.prefs();
        for (Map.Entry entry : this.properties.entrySet()) {
            node.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public Preferences prefs() {
        return HudsonManagerImpl.instancePrefs().node(HudsonManagerImpl.simplifyServerLocation(this.getName(), true));
    }

    public static HudsonInstanceImpl createHudsonInstance(String name, String url, String sync) {
        return HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties(name, url, sync), true);
    }

    public static HudsonInstanceImpl createHudsonInstance(HudsonInstanceProperties properties, boolean interactive) {
        HudsonInstanceImpl instance = new HudsonInstanceImpl(properties, interactive);
        assert (instance.getName() != null);
        assert (instance.getUrl() != null);
        assert (instance.getProperties().get("sync_time") != null);
        if (null == HudsonManagerImpl.getDefault().addInstance(instance)) {
            return null;
        }
        return instance;
    }

    public void terminate() {
        this.RP.stop();
        this.terminated = true;
        this.connected = false;
        this.forbidden = false;
        this.version = null;
        this.jobs.clear();
        this.views.clear();
        this.primaryView = null;
        this.fireStateChanges();
        this.fireContentChanges();
    }

    public HudsonConnector getConnector() {
        return this.connector;
    }

    @Override
    public HudsonVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public HudsonInstanceProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return (String)this.getProperties().get("name");
    }

    @Override
    public String getUrl() {
        String url = (String)this.getProperties().get("url");
        assert (url.endsWith("/")) : url;
        return url;
    }

    @Override
    public synchronized Collection<HudsonJob> getJobs() {
        return this.jobs;
    }

    boolean isSalient(HudsonJobImpl job) {
        HudsonInstanceProperties props = this.getProperties();
        if (HudsonInstanceProperties.split((String)props.get("suppressed_jobs")).contains(job.getName())) {
            return false;
        }
        List<String> preferred = HudsonInstanceProperties.split((String)props.get("pref_jobs"));
        if (!preferred.isEmpty()) {
            return preferred.contains(job.getName());
        }
        return true;
    }

    void setSalient(HudsonJobImpl job, boolean salient) {
        HudsonInstanceProperties props = this.getProperties();
        ArrayList<String> suppressed = new ArrayList<String>(HudsonInstanceProperties.split((String)props.get("suppressed_jobs")));
        if (salient) {
            suppressed.remove(job.getName());
        } else if (!suppressed.contains(job.getName())) {
            suppressed.add(job.getName());
        }
        props.put("suppressed_jobs", HudsonInstanceProperties.join(suppressed));
    }

    @Override
    public synchronized Collection<HudsonView> getViews() {
        return this.views;
    }

    @Override
    public synchronized HudsonView getPrimaryView() {
        if (this.primaryView == null) {
            this.primaryView = new HudsonViewImpl(this, "All", this.getUrl());
        }
        return this.primaryView;
    }

    synchronized void setViews(Collection<HudsonView> views, HudsonView primaryView) {
        this.views = views;
        this.primaryView = primaryView;
    }

    public void synchronize(final boolean authentication) {
        if (this.terminated) {
            return;
        }
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                HudsonInstanceImpl.this.doSynchronize(authentication);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSynchronize(boolean authentication) {
        final AtomicReference<Thread> synchThread = new AtomicReference<Thread>();
        final AtomicReference<ProgressHandle> handle = new AtomicReference<ProgressHandle>();
        handle.set(ProgressHandleFactory.createHandle((String)Bundle.MSG_Synchronizing(this.getName()), (Cancellable)new Cancellable(){

            public boolean cancel() {
                Thread t = (Thread)synchThread.get();
                if (t != null) {
                    LOG.log(Level.FINE, "Cancelling synchronization of {0}", HudsonInstanceImpl.this.getUrl());
                    if (!HudsonInstanceImpl.this.isPersisted()) {
                        HudsonInstanceImpl.this.properties.put("sync_time", "0");
                    }
                    t.interrupt();
                    ((ProgressHandle)handle.get()).finish();
                    return true;
                }
                return false;
            }
        }));
        ((ProgressHandle)handle.get()).start();
        synchThread.set(Thread.currentThread());
        try {
            Collection<HudsonView> oldViews = this.getViews();
            Collection<HudsonJob> retrieved = this.getConnector().getAllJobs(authentication);
            if (this.terminated) {
                return;
            }
            this.connected = this.getConnector().isConnected();
            this.version = this.getConnector().getHudsonVersion(authentication);
            this.forbidden = this.getConnector().forbidden;
            this.fireStateChanges();
            Map<String, Reference<RemoteFileSystem>> map = this.workspaces;
            synchronized (map) {
                Iterator<Map.Entry<String, Reference<RemoteFileSystem>>> it = this.workspaces.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Reference<RemoteFileSystem>> entry = it.next();
                    RemoteFileSystem fs = entry.getValue().get();
                    if (fs != null) {
                        fs.refreshAll();
                        continue;
                    }
                    it.remove();
                }
            }
            Collections.sort(Arrays.asList(retrieved.toArray(new HudsonJob[0])));
            if (((Object)this.getJobs()).equals(retrieved) && ((Object)oldViews).equals(this.getViews())) {
                return;
            }
            this.jobs = retrieved;
            this.fireContentChanges();
        }
        finally {
            ((ProgressHandle)handle.get()).finish();
        }
    }

    @Override
    public void addHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanges() {
        ArrayList<HudsonChangeListener> tempList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.stateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentChanges() {
        ArrayList<HudsonChangeListener> tempList;
        Collection<HudsonChangeListener> collection = this.listeners;
        synchronized (collection) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.contentChanged();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HudsonInstance)) {
            return false;
        }
        HudsonInstance other = (HudsonInstance)obj;
        return this.getUrl() == other.getUrl() || this.getUrl() != null && this.getUrl().equals(other.getUrl());
    }

    public int hashCode() {
        return this.getUrl() == null ? 445 : this.getUrl().hashCode();
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public int compareTo(HudsonInstance o) {
        return this.getName().compareTo(o.getName());
    }

    FileSystem getRemoteWorkspace(final HudsonJob job) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.workspaces, job.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(job);
            }
        });
    }

    FileSystem getArtifacts(final HudsonJobBuild build) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, build.getJob().getName() + "/" + build.getNumber(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(build);
            }
        });
    }

    FileSystem getArtifacts(final HudsonMavenModuleBuild module) {
        return HudsonInstanceImpl.getFileSystemFromCache(this.artifacts, module.getBuild().getJob().getName() + "/" + module.getBuild().getNumber() + "/" + module.getName(), new Callable<RemoteFileSystem>(){

            @Override
            public RemoteFileSystem call() throws Exception {
                return new RemoteFileSystem(module);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystemFromCache(Map<String, Reference<RemoteFileSystem>> cache, String key, Callable<RemoteFileSystem> create) {
        Map<String, Reference<RemoteFileSystem>> map = cache;
        synchronized (map) {
            RemoteFileSystem fs;
            RemoteFileSystem remoteFileSystem = fs = cache.containsKey(key) ? cache.get(key).get() : null;
            if (fs == null) {
                try {
                    fs = create.call();
                    cache.put(key, new WeakReference<RemoteFileSystem>(fs));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return FileUtil.createMemoryFileSystem();
                }
            }
            return fs;
        }
    }
}

