/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class AddTestInstanceAction
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AddTestInstanceAction.class.getName());

    public AddTestInstanceAction() {
        super(Bundle.AddTestInstanceAction_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File javaws;
        File javaHome = new File(System.getProperty("java.home"));
        File bindir = new File(javaHome.getParentFile(), "bin");
        if (!bindir.isDirectory()) {
            bindir = new File(javaHome, "bin");
        }
        if (!(javaws = new File(bindir, "javaws.exe")).isFile()) {
            javaws = new File(bindir, "javaws");
        }
        if (!javaws.isFile()) {
            this.warning(Bundle.AddTestInstanceAction_no_javaws(javaws));
            return;
        }
        try {
            int exit = new ProcessBuilder(javaws.getAbsolutePath(), "https://hudson.dev.java.net/hudson.jnlp").start().waitFor();
            if (exit != 0) {
                this.warning(Bundle.AddTestInstanceAction_could_not_run());
                return;
            }
        }
        catch (Exception x) {
            this.warning(Bundle.AddTestInstanceAction_could_not_run());
            LOG.log(Level.INFO, null, x);
            return;
        }
        final AtomicBoolean cancelled = new AtomicBoolean();
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)Bundle.AddTestInstanceAction_starting(), (Cancellable)new Cancellable(){

            public boolean cancel() {
                cancelled.set(true);
                return true;
            }
        });
        progress.start();
        try {
            String localhost = "http://localhost:8080/";
            while (!cancelled.get()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException x) {
                    LOG.log(Level.INFO, null, x);
                }
                try {
                    new ConnectionBuilder().url(localhost).connection();
                    HudsonInstanceImpl.createHudsonInstance(Bundle.AddTestInstanceAction_instance_name(), localhost, "1");
                    UI.selectNode(localhost);
                    break;
                }
                catch (IOException x) {
                    LOG.log(Level.FINER, null, x);
                }
            }
        }
        finally {
            progress.finish();
        }
    }

    private void warning(String message) throws MissingResourceException {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 2));
    }
}

