/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Implementation;
import org.netbeans.modules.web.jsf.icefaces.ui.Icefaces2CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class Icefaces2Customizer
implements JsfComponentCustomizer {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2Customizer.class.getName());
    private Icefaces2CustomizerPanelVisual panel;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new Icefaces2CustomizerPanelVisual(new PanelChangeListener());
            this.panel.initLibraries(true);
        }
        return this.panel;
    }

    public boolean isValid() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        String string = preferences.get("org.icefaces.impl.facelets.tag.icefaces.core.ConfigHandler", "");
        if (LibraryManager.getDefault().getLibrary(string) != null) {
            return true;
        }
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !Icefaces2Customizer.isValidIcefacesLibrary(list = library.getContent("classpath"))) continue;
            return true;
        }
        return false;
    }

    public String getErrorMessage() {
        return this.panel.getErrorMessage();
    }

    public String getWarningMessage() {
        return this.panel.getWarningMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
        if (this.panel.getIcefacesLibrary() != null) {
            preferences.put("preffered-library", this.panel.getIcefacesLibrary());
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static List<Library> getIcefacesLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !Icefaces2Customizer.isValidIcefacesLibrary(list = library.getContent("classpath"))) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public static boolean isValidIcefacesLibrary(List<URL> list) {
        try {
            return Util.containsClass(list, (String)"org.icefaces.impl.facelets.tag.icefaces.core.ConfigHandler");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
    }

    private class PanelChangeListener
    implements ChangeListener {
        private PanelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Icefaces2Customizer.this.changeSupport.fireChange();
        }
    }
}

