/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dashboard;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.panel.Panel;
import org.primefaces.event.DashboardReorderEvent;
import org.primefaces.model.DashboardColumn;
import org.primefaces.model.DashboardModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DashboardRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        Dashboard dashboard = (Dashboard)component;
        String clientId = dashboard.getClientId(facesContext);
        String senderIndexParam = clientId + "_senderColumnIndex";
        Integer senderColumnIndex = null;
        if (params.containsKey(clientId + "_reordered")) {
            String[] idTokens;
            String widgetClientId = (String)params.get(clientId + "_widgetId");
            Integer itemIndex = Integer.valueOf((String)params.get(clientId + "_itemIndex"));
            Integer receiverColumnIndex = Integer.valueOf((String)params.get(clientId + "_receiverColumnIndex"));
            if (params.containsKey(senderIndexParam)) {
                senderColumnIndex = Integer.valueOf((String)params.get(senderIndexParam));
            }
            String widgetId = (idTokens = widgetClientId.split(":")).length == 1 ? idTokens[0] : idTokens[idTokens.length - 1];
            DashboardReorderEvent event = new DashboardReorderEvent(component, widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
            dashboard.queueEvent(event);
            this.updateDashboardModel(dashboard.getModel(), widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
        }
    }

    protected void updateDashboardModel(DashboardModel model, String widgetId, Integer itemIndex, Integer receiverColumnIndex, Integer senderColumnIndex) {
        if (senderColumnIndex == null) {
            DashboardColumn column = model.getColumn(receiverColumnIndex);
            column.reorderWidget(itemIndex, widgetId);
        } else {
            DashboardColumn oldColumn = model.getColumn(senderColumnIndex);
            DashboardColumn newColumn = model.getColumn(receiverColumnIndex);
            model.transferWidget(oldColumn, newColumn, widgetId, itemIndex);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Dashboard dashboard = (Dashboard)component;
        this.encodeMarkup(facesContext, dashboard);
        this.encodeScript(facesContext, dashboard);
    }

    protected void encodeMarkup(FacesContext facesContext, Dashboard dashboard) throws IOException {
        DashboardModel model;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dashboard.getClientId(facesContext);
        writer.startElement("div", (UIComponent)dashboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = dashboard.getStyleClass() != null ? "ui-dashboard " + dashboard.getStyleClass() : "ui-dashboard";
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (dashboard.getStyle() != null) {
            writer.writeAttribute("style", (Object)dashboard.getStyle(), "style");
        }
        if ((model = dashboard.getModel()) != null) {
            for (DashboardColumn column : model.getColumns()) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-dashboard-column", null);
                for (String widgetId : column.getWidgets()) {
                    Panel widget = this.findWidget(widgetId, dashboard);
                    if (widget == null) continue;
                    this.renderChild(facesContext, (UIComponent)widget);
                }
                writer.endElement("div");
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, Dashboard dashboard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dashboard.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(dashboard.resolveWidgetVar() + " = new PrimeFaces.widget.Dashboard('" + clientId + "', {");
        writer.write("url:'" + this.getActionURL(facesContext) + "'");
        if (dashboard.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (dashboard.getOnReorderUpdate() != null) {
            writer.write(",onReorderUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)dashboard, dashboard.getOnReorderUpdate()) + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected Panel findWidget(String id, Dashboard dashboard) {
        for (UIComponent child : dashboard.getChildren()) {
            Panel panel = (Panel)child;
            if (!panel.getId().equals(id)) continue;
            return panel;
        }
        return null;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

