/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.expr.StringSearchExpression;
import org.codehaus.plexus.util.Base64;
import org.netbeans.modules.maven.indexer.NexusRepositoryIndexerImpl;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.openide.filesystems.FileUtil;

class ClassDependencyIndexCreator
extends AbstractIndexCreator {
    private static final Logger LOG = Logger.getLogger(ClassDependencyIndexCreator.class.getName());
    private static final String NB_DEPENDENCY_CLASSES = "nbdc";
    private static final IndexerField FLD_NB_DEPENDENCY_CLASS = new IndexerField(new Field(null, "urn:NbClassDependenciesIndexCreator", "nbdc", "Java dependencies"), IndexerFieldVersion.V3, "nbdc", "Java dependencies", Field.Store.YES, Field.Index.ANALYZED);
    private Map<String, Set<String>> classDeps;
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    private static final CRC32 crc = new CRC32();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");

    ClassDependencyIndexCreator() {
        super(ClassDependencyIndexCreator.class.getName(), Arrays.asList("min"));
    }

    @Override
    public void populateArtifactInfo(ArtifactContext context) throws IOException {
        this.classDeps = null;
        ArtifactInfo ai = context.getArtifactInfo();
        if (ai.classifier != null) {
            return;
        }
        if ("pom".equals(ai.packaging) || ai.fextension.endsWith(".lastUpdated")) {
            return;
        }
        File jar = context.getArtifact();
        if (jar == null || !jar.isFile()) {
            LOG.log(Level.FINER, "no artifact for {0}", ai);
            return;
        }
        if (!ai.packaging.equals("jar") && !ClassDependencyIndexCreator.isArchiveFile(jar)) {
            LOG.log(Level.FINE, "skipping artifact {0} with unrecognized packaging based on {1}", new Object[]{ai, jar});
            return;
        }
        LOG.log(Level.FINER, "reading {0}", jar);
        Map<String, byte[]> classfiles = ClassDependencyIndexCreator.read(jar);
        this.classDeps = new HashMap<String, Set<String>>();
        Set<String> classes = classfiles.keySet();
        for (Map.Entry<String, byte[]> entry : classfiles.entrySet()) {
            ClassDependencyIndexCreator.addDependenciesToMap(entry.getKey(), entry.getValue(), this.classDeps, classes, jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isArchiveFile(File jar) throws IOException {
        FileInputStream in = new FileInputStream(jar);
        try {
            byte[] buffer = new byte[4];
            boolean bl = ((InputStream)in).read(buffer, 0, 4) == 4 && (Arrays.equals(ZIP_HEADER_1, buffer) || Arrays.equals(ZIP_HEADER_2, buffer));
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
        return false;
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        String[] classNamesSplit;
        if (this.classDeps == null || this.classDeps.isEmpty()) {
            return;
        }
        if (ai.classNames == null) {
            LOG.log(Level.FINE, "no class names in index for {0}; therefore cannot store class usages", ai);
            return;
        }
        StringBuilder b = new StringBuilder();
        for (String referrerTopLevel : classNamesSplit = ai.classNames.split("\n")) {
            Set<String> referees = this.classDeps.remove(referrerTopLevel.substring(1));
            if (referees != null) {
                for (String referee : referees) {
                    b.append(ClassDependencyIndexCreator.crc32base64(referee));
                    b.append(' ');
                }
            }
            b.append(' ');
        }
        if (!this.classDeps.isEmpty()) {
            LOG.log(Level.FINE, "found dependencies for {0} from classes {1} not among {2}", new Object[]{ai, this.classDeps.keySet(), Arrays.asList(classNamesSplit)});
        }
        LOG.log(Level.FINER, "Class dependencies index field: {0}", b);
        doc.add((Fieldable)FLD_NB_DEPENDENCY_CLASS.toField(b.toString()));
    }

    static void search(String className, NexusIndexer indexer, Collection<IndexingContext> contexts, List<? super ClassUsageQuery.ClassUsageResult> results) throws IOException {
        String searchString = ClassDependencyIndexCreator.crc32base64(className.replace('.', '/'));
        Query refClassQuery = indexer.constructQuery(FLD_NB_DEPENDENCY_CLASS.getOntology(), new StringSearchExpression(searchString));
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)512, (boolean)true);
        IndexingContext context = contexts.iterator().next();
        context.getIndexSearcher().search(refClassQuery, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        LOG.log(Level.FINER, "for {0} ~ {1} found {2} hits", new Object[]{className, searchString, hits.length});
        for (ScoreDoc hit : hits) {
            ArtifactInfo ai;
            int docId = hit.doc;
            Document d = context.getIndexSearcher().doc(docId);
            String fldValue = d.get(NB_DEPENDENCY_CLASSES);
            LOG.log(Level.FINER, "{0} uses: {1}", new Object[]{className, fldValue});
            Set<String> refClasses = ClassDependencyIndexCreator.parseField(searchString, fldValue, d.get(ArtifactInfo.NAMES));
            if (refClasses.isEmpty() || (ai = IndexUtils.constructArtifactInfo(d, context)) == null) continue;
            ai.repository = context.getRepositoryId();
            List<NBVersionInfo> version = NexusRepositoryIndexerImpl.convertToNBVersionInfo(Collections.singleton(ai));
            if (version.isEmpty()) continue;
            results.add(new ClassUsageQuery.ClassUsageResult(version.get(0), refClasses));
        }
    }

    private static Set<String> parseField(String refereeCRC, String field, String referrersNL) {
        TreeSet<String> referrers = new TreeSet<String>();
        int p = 0;
        block0: for (String referrer : referrersNL.split("\n")) {
            while (true) {
                if (field.charAt(p) == ' ') {
                    ++p;
                    continue block0;
                }
                if (field.substring(p, p + 6).equals(refereeCRC)) {
                    referrers.add(referrer.substring(1).replace('/', '.'));
                }
                p += 7;
            }
        }
        return referrers;
    }

    private static void addDependenciesToMap(String referrer, byte[] data, Map<String, Set<String>> depsMap, Set<String> siblings, File jar) throws IOException {
        ClassLoader jre = ClassLoader.getSystemClassLoader().getParent();
        int shell = referrer.indexOf(36, referrer.lastIndexOf(47) + 1);
        String referrerTopLevel = shell == -1 ? referrer : referrer.substring(0, shell);
        for (String referee : ClassDependencyIndexCreator.dependencies(data, referrer, jar)) {
            if (siblings.contains(referee)) continue;
            try {
                jre.loadClass(referee.replace('/', '.'));
            }
            catch (ClassNotFoundException x) {
                Set<String> referees = depsMap.get(referrerTopLevel);
                if (referees == null) {
                    referees = new TreeSet<String>();
                    depsMap.put(referrerTopLevel, referees);
                }
                referees.add(referee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, byte[]> read(File jar) throws IOException {
        JarFile jf = new JarFile(jar);
        try {
            TreeMap<String, byte[]> classfiles = new TreeMap<String, byte[]>();
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String clazz = name.substring(0, name.length() - 6);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max((int)entry.getSize(), 0));
                InputStream is = jf.getInputStream(entry);
                try {
                    FileUtil.copy((InputStream)is, (OutputStream)baos);
                }
                finally {
                    is.close();
                }
                classfiles.put(clazz, baos.toByteArray());
            }
            TreeMap<String, byte[]> treeMap = classfiles;
            return treeMap;
        }
        finally {
            jf.close();
        }
    }

    private static Set<String> dependencies(byte[] data, String clazz, File jar) throws IOException {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        ClassDependencyIndexCreator.skip(input, 8);
        int size = input.readUnsignedShort() - 1;
        String[] utf8Strings = new String[size];
        boolean[] isClassName = new boolean[size];
        boolean[] isDescriptor = new boolean[size];
        block8: for (i = 0; i < size; ++i) {
            byte tag = input.readByte();
            switch (tag) {
                case 1: {
                    utf8Strings[i] = input.readUTF();
                    continue block8;
                }
                case 7: {
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size) {
                        throw new IOException("@" + i + ": CONSTANT_Class_info.name_index " + index + " too big for size of pool " + size);
                    }
                    isClassName[index] = true;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    ClassDependencyIndexCreator.skip(input, 4);
                    continue block8;
                }
                case 12: {
                    ClassDependencyIndexCreator.skip(input, 2);
                    int index = input.readUnsignedShort() - 1;
                    if (index >= size || index < 0) {
                        throw new IOException("@" + i + ": CONSTANT_NameAndType_info.descriptor_index " + index + " too big for size of pool " + size);
                    }
                    isDescriptor[index] = true;
                    continue block8;
                }
                case 8: {
                    ClassDependencyIndexCreator.skip(input, 2);
                    continue block8;
                }
                case 5: 
                case 6: {
                    ClassDependencyIndexCreator.skip(input, 8);
                    ++i;
                    continue block8;
                }
                default: {
                    LOG.log(Level.FINE, "jar:{4}!/{3}.class: Unrecognized constant pool tag {0} at index {1}; running UTF-8 strings: {2}", new Object[]{tag, i, Arrays.asList(utf8Strings), clazz, jar.toURI()});
                    continue block8;
                }
            }
        }
        for (i = 0; i < size; ++i) {
            String s = utf8Strings[i];
            if (s == null) continue;
            if (isClassName[i]) {
                while (s.charAt(0) == '[') {
                    s = s.substring(1);
                }
                if (s.length() == 1) continue;
                String c = s.charAt(s.length() - 1) == ';' && s.charAt(0) == 'L' ? s.substring(1, s.length() - 1) : s;
                result.add(c);
                continue;
            }
            if (!isDescriptor[i]) continue;
            int idx = 0;
            while ((idx = s.indexOf(76, idx)) != -1) {
                int semi = s.indexOf(59, idx);
                if (semi == -1) {
                    throw new IOException("Invalid type or descriptor: " + s);
                }
                result.add(s.substring(idx + 1, semi));
                idx = semi;
            }
        }
        return result;
    }

    private static void skip(DataInput input, int bytes) throws IOException {
        int skipped = input.skipBytes(bytes);
        if (skipped != bytes) {
            throw new IOException("Truncated class file");
        }
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_NB_DEPENDENCY_CLASS);
    }

    static String crc32base64(String s) {
        crc.reset();
        crc.update(s.getBytes(UTF8));
        long v = crc.getValue();
        byte[] b64 = Base64.encodeBase64((byte[])new byte[]{(byte)(v >> 24 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v & 0xFFL)});
        assert (b64.length == 8);
        assert (b64[6] == 61);
        assert (b64[7] == 61);
        return new String(b64, 0, 6, LATIN1).replace('+', '_');
    }
}

