/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.ClassBytesLoader;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerCalibrator;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUSampledInstr;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.HeapDump;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.InitiateProfilingCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class ProfilerServer
extends Thread
implements CommonConstants {
    private static ResourceBundle messages;
    private static String ENTER_TO_SHUTDOWN_MSG;
    private static String MAIN_CLASS_NOT_PUBLIC_MSG;
    private static String INCORRECT_MAIN_MODIFIERS_MSG;
    private static String UNEXPECTED_EXCEPTION_MSG;
    private static String ELAPSED_TIME_MSG;
    private static String CONNECTION_MSG;
    private static String WAITING_ON_PORT_MSG;
    private static String WAITING_ON_PORT_TIMEOUT_MSG;
    private static String CONNECTION_EXCEPTION_MSG;
    private static String CONNECTION_TIMEOUT_MSG;
    private static String AGENT_ERROR_MSG;
    private static String CONNECTION_INTERRUPTED_MSG;
    private static String COMMAND_EXCEPTION_MSG;
    private static String RESPONSE_EXCEPTION_MSG;
    private static String CONNECTION_CLOSED_MSG;
    private static String INCORRECT_AGENT_ID_MSG;
    private static String THREAD_EXCEPTION_MSG;
    private static String THREAD_WAIT_EXCEPTION_MSG;
    private static String LOCAL_SESSION_MSG;
    private static String REMOTE_SESSION_MSG;
    public static final int ATTACH_DYNAMIC = 0;
    public static final int ATTACH_DIRECT = 1;
    private static volatile boolean profilerInterfaceInitialized;
    private static volatile boolean connectionOpen;
    private static volatile boolean connectionFailed;
    private static volatile boolean detachCommandReceived;
    private static ProfilerServer profilerServer;
    private static ProfilingSessionStatus status;
    private static volatile boolean startTargetApp;
    private static volatile boolean targetAppMainThreadComplete;
    private static volatile Exception startupException;
    private static final Object targetAppRunningLock;
    private static Thread mainThread;
    private static SeparateCmdExecutionThread separateCmdExecutionThread;
    private static ShutdownWaitThread shutdownWaitThread;
    static final Object execInSeparateThreadLock;
    static int execInSeparateThreadOpCode;
    private static volatile boolean preemptExit;
    private static boolean shutdownOK;
    private static final Object shutdownLock;
    private static final Object resultsNotifiedLock;
    private static boolean resultsNotified;
    private static boolean resourcesInitialized;
    private static String _fullJFluidPath;
    private static int _portNo;
    private static int _activateCode;
    private static int _timeOut;
    private static Response lastResponse;
    private static final Object responseLock;
    private ObjectInputStream socketIn;
    private ObjectOutputStream socketOut;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private WireIO wireIO;
    private boolean dynamic;
    private int agentId = -1;
    private final Random r = new Random(System.currentTimeMillis());
    private int serverPort;
    private int serverTimeout = 0;
    static /* synthetic */ Class array$Ljava$lang$String;

    private ProfilerServer(int port, boolean dynamic, int timeout) {
        super("*** Profiler Agent Communication Thread");
        this.setPriority(10);
        this.serverPort = port;
        ThreadInfo.addProfilerServerThread(this);
        this.dynamic = dynamic;
        if (!dynamic) {
            this.serverTimeout = timeout;
        }
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Response getLastResponse() {
        Response res;
        Object object = responseLock;
        synchronized (object) {
            if (lastResponse == null) {
                boolean gotInterrupted = false;
                do {
                    try {
                        responseLock.wait();
                        gotInterrupted = false;
                    }
                    catch (InterruptedException ex) {
                        gotInterrupted = true;
                    }
                } while (gotInterrupted);
                if (lastResponse == null) {
                    System.out.println("Profiler Agent Error: lastResponse == null - internal error?");
                }
            }
            res = lastResponse;
            lastResponse = null;
        }
        return res;
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static ProfilingSessionStatus getProfilingSessionStatus() {
        return status;
    }

    public static boolean isTargetAppMainThreadComplete() {
        return targetAppMainThreadComplete;
    }

    public static void activate(String fullJFluidPath, int portNo, int activateCode) {
        ProfilerServer.activate(fullJFluidPath, portNo, activateCode, 0);
    }

    public static void activate(String fullJFluidPath, int portNo, int activateCode, int timeOut) {
        try {
            _fullJFluidPath = fullJFluidPath;
            _portNo = portNo;
            _timeOut = timeOut;
            _activateCode = activateCode;
            ProfilerServer.initLocalizedResources();
            if (activateCode == 0) {
                new AttachDynamicThread(activateCode).start();
            } else {
                ProfilerServer.doActivate(activateCode);
            }
        }
        catch (Throwable ex) {
            System.err.println("Profiler initialization failed due to:");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        mainThread = Thread.currentThread();
        try {
            _fullJFluidPath = new File(args[0]).getParentFile().getParentFile().getParentFile().getAbsolutePath();
        }
        catch (Exception ex) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot resolve library directory\n" + ex.getMessage());
        }
        ProfilerServer.initLocalizedResources();
        ProfilerServer.initInternals();
        int portNo = 0;
        try {
            portNo = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            ProfilerServer.internalError("illegal port number specified: " + args[1]);
        }
        int idx = 2;
        int timeout = 0;
        try {
            timeout = Integer.parseInt(args[2]);
            idx = 3;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int len = args.length - (idx + 1);
        String[] targetAppArgs = new String[len];
        System.arraycopy(args, idx + 1, targetAppArgs, 0, len);
        profilerServer = new ProfilerServer(portNo, true, timeout);
        profilerServer.start();
        while (!connectionOpen && !connectionFailed) {
            ProfilerServer.delay(50);
        }
        if (connectionFailed) {
            preemptExit = false;
            System.exit(-1);
        }
        ProfilerInterface.setProfilerServer(profilerServer);
        ProfilerServer.initSupportingFunctionality(false);
        while (!startTargetApp) {
            ProfilerServer.delay(100);
        }
        ProfilerServer.runTargetApp(args[idx], targetAppArgs);
        targetAppMainThreadComplete = true;
        if (startupException != null) {
            Object object = targetAppRunningLock;
            synchronized (object) {
                targetAppRunningLock.notify();
            }
        }
        ProfilerServer.delay(300);
        while (Threads.targetAppThreadsExist()) {
            ProfilerServer.delay(300);
        }
        ProfilerServer.status.targetAppRunning = false;
        ProfilerInterface.disableProfilerHooks();
        profilerServer.sendSimpleCmdToClient(18);
        ProfilerServer.waitForShutdownOK();
        ProfilerServer.forcedShutdown();
    }

    public void setRemoteProfiling(boolean remote) {
        ProfilerServer.status.remoteProfiling = remote;
        if (remote) {
            System.out.println(REMOTE_SESSION_MSG);
            ClassBytesLoader.preloadClasses();
        } else {
            System.out.println(LOCAL_SESSION_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyClientOnResultsAvailability() {
        if (!connectionOpen) {
            return;
        }
        if (profilerServer == null) {
            return;
        }
        Object object = resultsNotifiedLock;
        synchronized (object) {
            if (resultsNotified) {
                return;
            }
            resultsNotified = true;
            profilerServer.sendSimpleCmdToClient(38);
        }
    }

    public static void requestClientResetResults() {
        ProfilerInterface.resetProfilerCollectors();
        ProfilerCalibrator.resetInternalStatsCollectors();
    }

    public static void requestClientTakeSnapshot() {
        if (profilerServer == null) {
            return;
        }
        profilerServer.sendSimpleCmdToClient(39);
    }

    public boolean getAndCheckLastResponse() {
        Response resp = ProfilerServer.getLastResponse();
        return resp.isOK();
    }

    public void run() {
        if (this.connectToClient()) {
            while (!profilerInterfaceInitialized) {
                ProfilerServer.delay(50);
            }
            this.listenToClient();
        } else {
            preemptExit = false;
        }
    }

    public void sendClassLoaderUnloadingCommand() {
        this.sendSimpleCmdToClient(36);
        ProfilerServer.getLastResponse();
    }

    public synchronized void sendComplexCmdToClient(Command cmd) {
        block2: {
            try {
                this.wireIO.sendComplexCommand(cmd);
            }
            catch (IOException ex) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(ex);
            }
        }
    }

    public synchronized void sendComplexResponseToClient(Response resp) {
        block2: {
            try {
                this.wireIO.sendComplexResponse(resp);
            }
            catch (IOException ex) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(ex);
            }
        }
    }

    public boolean sendEventBufferDumpedCommand(int length, String bufferName) {
        EventBufferDumpedCommand cmd = new EventBufferDumpedCommand(length, bufferName);
        this.sendComplexCmdToClient(cmd);
        return this.getAndCheckLastResponse();
    }

    public boolean sendEventBufferDumpedCommand(int length, byte[] buffer, int startPos) {
        EventBufferDumpedCommand cmd = new EventBufferDumpedCommand(length, buffer, startPos);
        this.sendComplexCmdToClient(cmd);
        return this.getAndCheckLastResponse();
    }

    public synchronized void sendSimpleCmdToClient(int cmdType) {
        block2: {
            try {
                this.wireIO.sendSimpleCommand(cmdType);
            }
            catch (IOException ex) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(ex);
            }
        }
    }

    public synchronized void sendSimpleResponseToClient(boolean val, String errorMessage) {
        block2: {
            try {
                this.wireIO.sendSimpleResponse(val, errorMessage);
            }
            catch (IOException ex) {
                if (detachCommandReceived) break block2;
                this.handleIOExceptionOnSend(ex);
            }
        }
    }

    static ResourceBundle getProfilerServerResourceBundle() {
        if (messages != null) {
            return messages;
        }
        if (_fullJFluidPath != null) {
            try {
                messages = ProfilerServer.getProfilerServerResourceBundle(_fullJFluidPath);
            }
            catch (Exception e) {
                System.err.println("Profiler Server: Problem with customized initializing localized messages...\n" + e.getMessage());
            }
        }
        if (messages != null) {
            return messages;
        }
        try {
            messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.server.Bundle");
        }
        catch (Exception e) {
            System.err.println("Profiler Server: Problem with default initializing localized messages...\n" + e.getMessage());
        }
        return messages;
    }

    static void initLocalizedResources() {
        if (resourcesInitialized) {
            return;
        }
        messages = ProfilerServer.getProfilerServerResourceBundle();
        if (messages != null) {
            ENTER_TO_SHUTDOWN_MSG = messages.getString("ProfilerServer_EnterToShutdownMsg");
            MAIN_CLASS_NOT_PUBLIC_MSG = messages.getString("ProfilerServer_MainClassNotPublicMsg");
            INCORRECT_MAIN_MODIFIERS_MSG = messages.getString("ProfilerServer_IncorrectMainModifiersMsg");
            UNEXPECTED_EXCEPTION_MSG = messages.getString("ProfilerServer_UnexpectedExceptionMsg");
            ELAPSED_TIME_MSG = messages.getString("ProfilerServer_ElapsedTimeMsg");
            CONNECTION_MSG = messages.getString("ProfilerServer_ConnectionMsg");
            WAITING_ON_PORT_MSG = messages.getString("ProfilerServer_WaitingOnPortMsg");
            WAITING_ON_PORT_TIMEOUT_MSG = messages.getString("ProfilerServer_WaitingOnPortTimeoutMsg");
            CONNECTION_EXCEPTION_MSG = messages.getString("ProfilerServer_ConnectionExceptionMsg");
            CONNECTION_TIMEOUT_MSG = messages.getString("ProfilerServer_ConnectionTimeoutMsg");
            AGENT_ERROR_MSG = messages.getString("ProfilerServer_AgentErrorMsg");
            CONNECTION_INTERRUPTED_MSG = messages.getString("ProfilerServer_ConnectionInterruptedMsg");
            COMMAND_EXCEPTION_MSG = messages.getString("ProfilerServer_CommandExceptionMsg");
            RESPONSE_EXCEPTION_MSG = messages.getString("ProfilerServer_ResponseExceptionMsg");
            CONNECTION_CLOSED_MSG = messages.getString("ProfilerServer_ConnectionClosedMsg");
            INCORRECT_AGENT_ID_MSG = messages.getString("ProfilerServer_IncorrectAgentIdMsg");
            THREAD_EXCEPTION_MSG = messages.getString("ProfilerServer_ThreadExceptionMsg");
            THREAD_WAIT_EXCEPTION_MSG = messages.getString("ProfilerServer_ThreadWaitExceptionMsg");
            LOCAL_SESSION_MSG = messages.getString("ProfilerServer_LocalSessionMsg");
            REMOTE_SESSION_MSG = messages.getString("ProfilerServer_RemoteSessionMsg");
            resourcesInitialized = true;
        }
    }

    static void loadNativeLibrary(String fullJFluidPath, boolean fullPathToLibSpecified) {
        String libFullName = Platform.getAgentNativeLibFullName(fullJFluidPath, fullPathToLibSpecified, null, -1);
        System.load(libFullName);
    }

    static boolean startProfilingPointsActive() {
        if (status != null) {
            return ProfilerServer.status.startProfilingPointsActive;
        }
        return false;
    }

    private static File getInfoFile(int port) throws IOException {
        String dirName = Platform.getProfilerUserDir();
        return new File(dirName + File.separator + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setShutdownOK() {
        Object object = shutdownLock;
        synchronized (object) {
            shutdownOK = true;
            shutdownLock.notifyAll();
        }
    }

    private static void cleanupOnShutdown() {
        Monitors.shutdown();
        ProfilerInterface.disableProfilerHooks();
        ProfilerRuntimeCPU.enableProfiling(false);
        connectionOpen = false;
        profilerServer.sendSimpleCmdToClient(19);
        profilerServer.closeConnection();
        profilerServer.stopSeparateCmdExecutionThread();
    }

    private static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void doActivate(int activateCode) {
        ProfilerInterface.disableProfilerHooks();
        ProfilerServer.initInternals();
        profilerServer = new ProfilerServer(_portNo, activateCode == 0, _timeOut);
        profilerServer.start();
        while (!connectionOpen && !connectionFailed) {
            ProfilerServer.delay(100);
        }
        if (connectionFailed) {
            if (activateCode == 1) {
                System.exit(-1);
            } else {
                return;
            }
        }
        ProfilerInterface.setProfilerServer(profilerServer);
        ProfilerServer.initSupportingFunctionality(true);
        if (_activateCode == 1) {
            while (ProfilerInterface.getCurrentInstrType() == 0 && !ProfilerServer.status.targetAppRunning) {
                ProfilerServer.delay(200);
            }
            ProfilerServer.delay(100);
        }
        ProfilerServer.status.targetAppRunning = true;
    }

    private static void forcedShutdown() {
        ProfilerServer.cleanupOnShutdown();
        preemptExit = false;
        System.exit(-1);
    }

    private static void initInternals() {
        shutdownWaitThread = new ShutdownWaitThread();
        Runtime.getRuntime().addShutdownHook(shutdownWaitThread);
        profilerInterfaceInitialized = false;
        connectionOpen = false;
        connectionFailed = false;
        detachCommandReceived = false;
        profilerServer = null;
        status = null;
        startTargetApp = false;
        startupException = null;
        try {
            Class.forName("java.net.SocketException");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Class.forName("java.util.AbstractList$Itr");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ThreadInfo.clearProfilerServerThreads();
    }

    private static void initSupportingFunctionality(boolean inAttachedMode) {
        status = new ProfilingSessionStatus();
        ProfilerServer.status.runningInAttachedMode = inAttachedMode;
        ProfilerServer.status.targetJDKVersionString = Platform.getJDKVersionString();
        Monitors.initialize();
        profilerServer.initSeparateCmdExecutionThread();
        ThreadInfo.addProfilerServerThread(shutdownWaitThread);
        ProfilerInterface.initProfilerInterface(status, inAttachedMode ? profilerServer : Thread.currentThread());
        profilerInterfaceInitialized = true;
    }

    private static void pressEnterToShutDown() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        System.out.println(ENTER_TO_SHUTDOWN_MSG);
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static void runTargetApp(String mainClassName, String[] mainArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForShutdownOK() {
        Object object = shutdownLock;
        synchronized (object) {
            while (!shutdownOK && !Thread.interrupted()) {
                try {
                    shutdownLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Thread.yield();
            }
            if (shutdownOK) {
                return;
            }
        }
        System.err.println("ProfilerServer hasn't shut down cleanly. Terminated.");
    }

    private int getAgentId() {
        if (this.agentId == -1) {
            String id = System.getProperty("nbprofiler.agentid");
            if (id != null) {
                try {
                    this.agentId = Integer.parseInt(id);
                }
                catch (NumberFormatException e) {
                    System.err.println(MessageFormat.format(INCORRECT_AGENT_ID_MSG, id));
                }
            }
            if (this.agentId == -1) {
                this.agentId = this.r.nextInt(Integer.MAX_VALUE);
            }
        }
        return this.agentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLastResponse(Response r) {
        Object object = responseLock;
        synchronized (object) {
            lastResponse = r;
            try {
                responseLock.notify();
            }
            catch (IllegalMonitorStateException ex) {
                ProfilerServer.internalError("IllegalMonitorState in ProfilerServer.setLastResponse()");
            }
        }
    }

    private static String getLocalizedJFluidServerJar(String jfluidServerDir) {
        File baseDirF;
        String localizedJFluidServerJar = null;
        String baseDir = jfluidServerDir.replace('\\', '/');
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        if (!(baseDirF = new File(baseDir)).exists() || !baseDirF.isDirectory()) {
            return null;
        }
        String localeDir = baseDir + "locale/";
        File localeDirF = new File(localeDir);
        if (localeDirF.exists() && localeDirF.isDirectory() && (localizedJFluidServerJar = ProfilerServer.getLocalizedJFluidServerJarInDir(localeDir)) != null) {
            return localizedJFluidServerJar;
        }
        localizedJFluidServerJar = ProfilerServer.getLocalizedJFluidServerJarInDir(baseDir);
        return localizedJFluidServerJar;
    }

    private static String getLocalizedJFluidServerJarInDir(String jfluidServerLocaleDir) {
        LocaleIterator localeIterator = new LocaleIterator(Locale.getDefault());
        while (localeIterator.hasNext()) {
            String jarFile = jfluidServerLocaleDir + "jfluid-server" + localeIterator.next() + ".jar";
            File jarFileF = new File(jarFile);
            if (!jarFileF.exists() || !jarFileF.isFile()) continue;
            return jarFile;
        }
        return null;
    }

    private static ResourceBundle getProfilerServerResourceBundle(String jfluidPath) {
        ResourceBundle bundle = null;
        if (jfluidPath == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot find path to Profiler libraries");
        }
        String jfluidServerJar = ProfilerServer.getLocalizedJFluidServerJar(jfluidPath);
        if (jfluidServerJar == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer, cannot find localized jfluid-server.jar");
        }
        try {
            if (!jfluidServerJar.startsWith("/")) {
                jfluidServerJar = "/" + jfluidServerJar;
            }
            String bundleJarURLPath = "jar:file:" + jfluidServerJar + "!/";
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL(bundleJarURLPath)});
            bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.server.Bundle", Locale.getDefault(), loader);
        }
        catch (Exception e2) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer\n" + e2.getMessage());
        }
        if (bundle == null) {
            throw new RuntimeException("ProfilerServer: Unable to initialize ResourceBundle for ProfilerServer");
        }
        return bundle;
    }

    private synchronized void closeConnection() {
        connectionOpen = false;
        ProfilerServer.status.targetAppRunning = false;
        this.removeInfoFile();
        try {
            this.socketOut.close();
            this.socketIn.close();
            this.clientSocket.close();
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ProfilerServer.status.runningInAttachedMode) {
            System.out.println(CONNECTION_CLOSED_MSG);
        }
        preemptExit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectToClient() {
        try {
            if (this.serverTimeout == 0) {
                System.out.println(MessageFormat.format(WAITING_ON_PORT_MSG, "" + this.serverPort, "12"));
            } else {
                System.out.println(MessageFormat.format(WAITING_ON_PORT_TIMEOUT_MSG, "" + this.serverPort, "" + this.serverTimeout, "12"));
            }
            this.serverSocket = new ServerSocket(this.serverPort);
            this.serverSocket.setSoTimeout(this.serverTimeout * 1000);
            this.createInfoFile();
            this.clientSocket = this.serverSocket.accept();
            this.clientSocket.setTcpNoDelay(true);
            this.socketIn = new ObjectInputStream(this.clientSocket.getInputStream());
            this.socketOut = new ObjectOutputStream(this.clientSocket.getOutputStream());
            this.wireIO = new WireIO(this.socketOut, this.socketIn);
            connectionOpen = true;
            System.out.println(CONNECTION_MSG);
            return true;
        }
        catch (SocketTimeoutException ex) {
            System.err.println(CONNECTION_TIMEOUT_MSG);
            connectionFailed = true;
            return false;
        }
        catch (IOException ex) {
            System.err.println(MessageFormat.format(CONNECTION_EXCEPTION_MSG, ex));
            connectionFailed = true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInfoFile() {
        FilterOutputStream bos = null;
        try {
            File f = ProfilerServer.getInfoFile(this.serverPort);
            f.createNewFile();
            f.deleteOnExit();
            Properties props = new Properties();
            props.setProperty("dynamic", Boolean.toString(this.dynamic));
            props.setProperty("working.dir", System.getProperty("user.dir"));
            props.setProperty("agent.id", Integer.toString(this.getAgentId()));
            props.setProperty("java.version", System.getProperty("java.version"));
            FileOutputStream fos = new FileOutputStream(f);
            bos = new BufferedOutputStream(fos);
            props.store(bos, "");
            bos.close();
        }
        catch (IOException e) {
            System.err.println(MessageFormat.format(AGENT_ERROR_MSG, e.getMessage()));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateThread(int opCode) {
        Object object = execInSeparateThreadLock;
        synchronized (object) {
            execInSeparateThreadOpCode = opCode;
            try {
                execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException ex) {
                System.err.println(THREAD_EXCEPTION_MSG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClientCommand(Command cmd) {
        if (cmd.getType() == 2) {
            if (ProfilerServer.status.runningInAttachedMode) {
                ProfilerServer.status.targetAppRunning = true;
                this.sendSimpleResponseToClient(true, null);
                return;
            }
            class MyThread
            extends Thread {
                MyThread() {
                    ThreadInfo.addProfilerServerThread(this);
                    this.setName("*** Profiler Agent Special Execution Thread 4");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = targetAppRunningLock;
                    synchronized (object) {
                        startTargetApp = true;
                        try {
                            targetAppRunningLock.wait();
                        }
                        catch (InterruptedException ex) {
                            ProfilerServer.internalError("START_TARGET_APP");
                        }
                    }
                    if (startupException != null) {
                        ProfilerServer.this.sendSimpleResponseToClient(false, startupException.toString());
                    } else {
                        ProfilerServer.this.sendSimpleResponseToClient(true, null);
                    }
                    ThreadInfo.removeProfilerServerThread(this);
                }
            }
            new MyThread().start();
            return;
        }
        switch (cmd.getType()) {
            case 32: {
                this.sendComplexResponseToClient(Monitors.getMonitoredNumbers());
                break;
            }
            case 13: {
                Object object = resultsNotifiedLock;
                synchronized (object) {
                    resultsNotified = false;
                }
                try {
                    ProfilerInterface.initiateProfiling((InitiateProfilingCommand)cmd, ProfilerServer.status.targetAppRunning);
                    this.sendSimpleResponseToClient(true, null);
                }
                catch (Exception ex) {
                    this.sendSimpleResponseToClient(false, ex.getMessage());
                }
                break;
            }
            case 7: {
                class InstrumentMethodGroupThread
                extends Thread {
                    final InstrumentMethodGroupCommand methodGroupCmd;
                    String exceptionString;

                    InstrumentMethodGroupThread(InstrumentMethodGroupCommand cmd) {
                        ThreadInfo.addProfilerServerThread(this);
                        this.setName("*** Profiler Agent Special Execution Thread 8");
                        this.methodGroupCmd = cmd;
                    }

                    public void run() {
                        try {
                            ProfilerInterface.instrumentMethods(this.methodGroupCmd);
                        }
                        catch (Exception ex) {
                            this.exceptionString = ex.getLocalizedMessage();
                        }
                        ThreadInfo.removeProfilerServerThread(this);
                    }
                }
                InstrumentMethodGroupThread instrumentMethodGroupThread = new InstrumentMethodGroupThread((InstrumentMethodGroupCommand)cmd);
                instrumentMethodGroupThread.start();
                while (instrumentMethodGroupThread.isAlive()) {
                    ProfilerServer.delay(2000);
                    this.sendSimpleCmdToClient(43);
                }
                if (instrumentMethodGroupThread.exceptionString != null) {
                    this.sendSimpleResponseToClient(false, instrumentMethodGroupThread.exceptionString);
                    break;
                }
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 1: {
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 4: {
                SetChangeableInstrParamsCommand scipCmd = (SetChangeableInstrParamsCommand)cmd;
                ProfilerRuntimeCPU.setNProfiledThreadsLimit(scipCmd.getNProfiledThreadsLimit());
                ProfilerRuntimeCPUSampledInstr.setSamplingInterval(scipCmd.getSamplingInterval());
                ProfilerRuntimeSampler.setSamplngFrequency(scipCmd.getSamplingFrequency());
                ProfilerRuntimeMemory.setSamplingInterval((short)scipCmd.getObjAllocStackSamplingInterval());
                ProfilerRuntimeMemory.setSamplingDepth(scipCmd.getObjAllocStackSamplingDepth());
                ProfilerRuntimeObjLiveness.setRunGCOnGetResults(scipCmd.getRunGCOnGetResultsInMemoryProfiling());
                boolean threadSampling = scipCmd.isThreadsSamplingEnabled();
                boolean waitTracking = scipCmd.isWaitTrackingEnabled();
                boolean sleepTracking = scipCmd.isSleepTrackingEnabled();
                Monitors.setThreadsSamplingEnabled(threadSampling);
                ProfilerRuntimeCPU.setWaitAndSleepTracking(waitTracking, sleepTracking);
                Classes.setWaitTrackingEnabled((threadSampling || waitTracking ? 1 : 0) != 0);
                Classes.setSleepTrackingEnabled((threadSampling || sleepTracking ? 1 : 0) != 0);
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 5: {
                SetUnchangeableInstrParamsCommand sucipCmd = (SetUnchangeableInstrParamsCommand)cmd;
                ProfilerRuntimeCPU.setTimerTypes(sucipCmd.getAbsoluteTimerOn(), sucipCmd.getThreadCPUTimerOn());
                ProfilerServer.status.instrScheme = sucipCmd.getInstrScheme();
                ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(sucipCmd.getCodeRegionCPUResBufSize());
                ProfilerRuntimeCPU.enableFirstTimeMethodInvoke(ProfilerServer.status.instrScheme != 3);
                this.setRemoteProfiling(sucipCmd.getRemoteProfiling());
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 6: {
                this.sendSimpleResponseToClient(ProfilerInterface.cpuResultsExist(), null);
                break;
            }
            case 27: 
            case 40: {
                this.executeInSeparateThread(cmd.getType());
                break;
            }
            case 8: {
                this.sendComplexResponseToClient(ProfilerInterface.getCodeRegionCPUResults());
                break;
            }
            case 30: {
                this.sendComplexResponseToClient(ProfilerInterface.getObjectAllocationResults());
                break;
            }
            case 31: {
                GetMethodNamesForJMethodIdsCommand gmnCmd = (GetMethodNamesForJMethodIdsCommand)cmd;
                this.sendComplexResponseToClient(ProfilerInterface.getMethodNamesForJMethodIds(gmnCmd.getMethodIds()));
                break;
            }
            case 29: {
                Object object = resultsNotifiedLock;
                synchronized (object) {
                    resultsNotified = false;
                }
                this.executeInSeparateThread(cmd.getType());
                break;
            }
            case 9: {
                ProfilerInterface.deactivateInjectedCode();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 16: {
                this.sendComplexResponseToClient(ProfilerInterface.getCurrentThreadLivenessStatus());
                break;
            }
            case 10: {
                ProfilerInterface.suspendTargetApp();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 11: {
                ProfilerInterface.resumeTargetApp();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 12: {
                if (ProfilerInterface.getCurrentInstrType() != 0) {
                    ProfilerInterface.deactivateInjectedCode();
                }
                this.sendSimpleResponseToClient(true, null);
                this.closeConnection();
                preemptExit = false;
                this.doExit();
                break;
            }
            case 15: {
                ProfilerServer.setShutdownOK();
                break;
            }
            case 20: {
                ProfilerInterface.setInstrumentReflection(true);
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 21: {
                ProfilerInterface.setInstrumentReflection(false);
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 33: {
                GC.runGC();
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 35: {
                GetDefiningClassLoaderCommand gdclCmd = (GetDefiningClassLoaderCommand)cmd;
                int loaderId = ClassLoaderManager.getDefiningLoaderForClass(gdclCmd.getClassName(), gdclCmd.getClassLoaderId());
                DefiningLoaderResponse resp = new DefiningLoaderResponse(loaderId);
                this.sendComplexResponseToClient(resp);
                break;
            }
            case 28: {
                ProfilerServer.status.jvmArguments = Threads.getJVMArguments();
                ProfilerServer.status.javaCommand = Threads.getJavaCommand();
                VMPropertiesResponse resp = new VMPropertiesResponse(Platform.getJavaVersionString(), System.getProperty("java.class.path"), System.getProperty("java.ext.dirs"), System.getProperty("sun.boot.class.path"), System.getProperty("user.dir"), ProfilerServer.status.jvmArguments, ProfilerServer.status.javaCommand, System.getProperty("os.name"), Runtime.getRuntime().maxMemory(), System.currentTimeMillis(), Timers.getCurrentTimeInCounts(), this.getAgentId());
                this.sendComplexResponseToClient(resp);
                break;
            }
            case 37: {
                int ret = CalibrationDataFileIO.readSavedCalibrationData(status);
                if (ret == 0) {
                    CalibrationDataResponse resp = new CalibrationDataResponse(ProfilerServer.status.methodEntryExitCallTime, ProfilerServer.status.methodEntryExitInnerTime, ProfilerServer.status.methodEntryExitOuterTime, ProfilerServer.status.timerCountsInSecond);
                    profilerServer.sendComplexResponseToClient(resp);
                    break;
                }
                this.sendSimpleResponseToClient(false, CalibrationDataFileIO.getErrorMessage());
                break;
            }
            case 34: {
                ProfilerCalibrator.init(status);
                ProfilerCalibrator.measureBCIOverhead(false);
                CalibrationDataResponse resp = new CalibrationDataResponse(ProfilerServer.status.methodEntryExitCallTime, ProfilerServer.status.methodEntryExitInnerTime, ProfilerServer.status.methodEntryExitOuterTime, ProfilerServer.status.timerCountsInSecond);
                profilerServer.sendComplexResponseToClient(resp);
                break;
            }
            case 24: {
                ProfilerCalibrator.init(status);
                this.sendComplexResponseToClient(ProfilerCalibrator.getInternalStats());
                break;
            }
            case 25: {
                ProfilerInterface.deactivateInjectedCode();
                ProfilerInterface.disableProfilerHooks();
                ProfilerInterface.clearProfilerDataStructures();
                this.stopSeparateCmdExecutionThread();
                Monitors.shutdown();
                ThreadInfo.clearProfilerServerThreads();
                detachCommandReceived = true;
                this.sendSimpleResponseToClient(true, null);
                break;
            }
            case 41: {
                TakeHeapDumpCommand dumpCmd = (TakeHeapDumpCommand)cmd;
                String error = HeapDump.takeHeapDump((Platform.getJDKVersionNumber() == 2 ? 1 : 0) != 0, (String)dumpCmd.getOutputFile());
                this.sendSimpleResponseToClient(error == null, error);
            }
        }
    }

    private void doExit() {
        try {
            ClassLoader clInstance;
            Class<?> lookupClz = Thread.currentThread().getContextClassLoader().loadClass("org.openide.util.Lookup");
            Method instMethod = lookupClz.getMethod("getDefault", new Class[0]);
            Method lookupMethod = lookupClz.getMethod("lookup", Class.class);
            Object instance = instMethod.invoke(lookupClz, new Object[0]);
            if (instance != null && (clInstance = (ClassLoader)lookupMethod.invoke(instance, (Object[])new Class[]{ClassLoader.class})) != null) {
                Class<?> lcmInstanceClz = clInstance.loadClass("org.openide.LifecycleManager");
                Method lcmInstMethod = lcmInstanceClz.getMethod("getDefault", new Class[0]);
                Method lcmExitMethod = lcmInstanceClz.getMethod("exit", new Class[0]);
                Object lcmInstance = lcmInstMethod.invoke(lcmInstanceClz, new Object[0]);
                lcmExitMethod.invoke(lcmInstance, new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(-1);
    }

    private void handleIOExceptionOnSend(IOException ex) {
        System.err.println(MessageFormat.format(RESPONSE_EXCEPTION_MSG, ex));
        ex.printStackTrace(System.err);
        this.closeConnection();
    }

    private void initSeparateCmdExecutionThread() {
        separateCmdExecutionThread = new SeparateCmdExecutionThread();
        separateCmdExecutionThread.start();
    }

    private static void internalError(String message) {
        ProfilerServer.internalError(message, true);
    }

    private static void internalError(String message, boolean exit) {
        System.err.println("Profiler Engine Error: " + message);
        if (exit) {
            preemptExit = false;
            System.exit(-1);
        }
    }

    private void listenToClient() {
        while (connectionOpen && !detachCommandReceived) {
            try {
                Object o = this.wireIO.receiveCommandOrResponse();
                if (o == null) {
                    System.err.println(CONNECTION_INTERRUPTED_MSG);
                    break;
                }
                if (o instanceof Command) {
                    this.handleClientCommand((Command)o);
                    continue;
                }
                ProfilerServer.setLastResponse((Response)o);
            }
            catch (IOException ex) {
                if (!connectionOpen || detachCommandReceived) break;
                System.err.println(MessageFormat.format(COMMAND_EXCEPTION_MSG, ex));
                break;
            }
        }
        this.closeConnection();
    }

    private void removeInfoFile() {
        try {
            ProfilerServer.getInfoFile(this.serverPort).delete();
        }
        catch (IOException e) {
            System.err.println(MessageFormat.format(AGENT_ERROR_MSG, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSeparateCmdExecutionThread() {
        separateCmdExecutionThread.terminate();
        Object object = execInSeparateThreadLock;
        synchronized (object) {
            try {
                execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ String access$600() {
        return THREAD_WAIT_EXCEPTION_MSG;
    }

    static {
        ENTER_TO_SHUTDOWN_MSG = "Press ENTER to shut down the target JVM...";
        MAIN_CLASS_NOT_PUBLIC_MSG = "Main class {0} is not public.\nProfiler can not start it";
        INCORRECT_MAIN_MODIFIERS_MSG = "Method {0}.main(String args[]) has incorrect modifiers";
        UNEXPECTED_EXCEPTION_MSG = "Target application threw an unexpected exception: {0}";
        ELAPSED_TIME_MSG = "Main application thread elapsed time: {0} ms.";
        CONNECTION_MSG = "Profiler Agent: Established connection with the tool";
        WAITING_ON_PORT_MSG = "Profiler Agent: Waiting for connection on port {0} (Protocol version: {1})";
        WAITING_ON_PORT_TIMEOUT_MSG = "Profiler Agent: Waiting for connection on port {0}, timeout {1} seconds (Protocol version: {2})";
        CONNECTION_EXCEPTION_MSG = "Profiler Agent Error: Exception when trying to establish connection with client:\n{0}";
        CONNECTION_TIMEOUT_MSG = "Profiler Agent Error: Timed out trying to establish connection with client";
        AGENT_ERROR_MSG = "Profiler Agent Error: {0}";
        CONNECTION_INTERRUPTED_MSG = "Profiler Agent Error: Connection with client interrupted";
        COMMAND_EXCEPTION_MSG = "Profiler Agent Error: Exception when handling command from client:\n{0}";
        RESPONSE_EXCEPTION_MSG = "Profiler Agent Error: Exception when trying to send response or command to client:\n{0}";
        CONNECTION_CLOSED_MSG = "Profiler Agent: Connection with agent closed";
        INCORRECT_AGENT_ID_MSG = "Profiler Agent Warning: Wrong agentId specified: {0}";
        THREAD_EXCEPTION_MSG = "Profiler Agent Error: Exception in executeInSeparateThread()";
        THREAD_WAIT_EXCEPTION_MSG = "Profiler Agent Error: Exception in wait in SeparateCmdExecutionThread";
        LOCAL_SESSION_MSG = "Profiler Agent: Local accelerated session";
        REMOTE_SESSION_MSG = "Profiler Agent: Standard session";
        targetAppRunningLock = new Object();
        execInSeparateThreadLock = new Object();
        preemptExit = true;
        shutdownOK = false;
        shutdownLock = new Object();
        resultsNotifiedLock = new Object();
        resultsNotified = false;
        resourcesInitialized = false;
        _timeOut = 0;
        responseLock = new Object();
    }

    private class SeparateCmdExecutionThread
    extends Thread {
        private volatile boolean stopped = false;

        public SeparateCmdExecutionThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 6");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            var1_1 = ProfilerServer.execInSeparateThreadLock;
            // MONITORENTER : var1_1
            block13: while (true) {
                try {
                    ProfilerServer.execInSeparateThreadLock.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println(ProfilerServer.access$600());
                }
                if (this.stopped) {
                    // MONITOREXIT : var1_1
                    return;
                }
                opCode = ProfilerServer.execInSeparateThreadOpCode;
                switch (opCode) {
                    case 27: 
                    case 40: {
                        absTimeStamp = ProfilerRuntimeCPU.getAbsTimeStampInCollectedFormat();
                        res = false;
                        if (ProfilerRuntime.eventBuffer == null || ProfilerRuntime.sendingBuffer) ** GOTO lbl29
                        var6_6 = ProfilerRuntime.eventBuffer;
                        // MONITORENTER : org.netbeans.lib.profiler.server.ProfilerRuntime.eventBuffer
                        res = ProfilerInterface.serialClientOperationsLock.beginTrans(true, true);
                        if (res) {
                            try {
                                ProfilerInterface.dumpExistingResults(opCode == 40);
                            }
                            finally {
                                ProfilerInterface.serialClientOperationsLock.endTrans();
                            }
                        }
                        // MONITOREXIT : var6_6
lbl29:
                        // 2 sources

                        resp = new DumpResultsResponse(res, absTimeStamp);
                        ProfilerServer.this.sendComplexResponseToClient(resp);
                        break;
                    }
                    case 29: {
                        ProfilerServer.requestClientResetResults();
                        ProfilerServer.this.sendSimpleResponseToClient(true, null);
                        continue block13;
                    }
                }
            }
        }

        public void terminate() {
            this.stopped = true;
        }
    }

    private static class ShutdownWaitThread
    extends Thread {
        public ShutdownWaitThread() {
            this.setName("*** Profiler Agent Special Execution Thread 7");
        }

        public void run() {
            if (preemptExit && connectionOpen) {
                profilerServer.sendSimpleCmdToClient(18);
                ProfilerServer.waitForShutdownOK();
                ProfilerServer.cleanupOnShutdown();
            }
        }
    }

    private static class LocaleIterator
    implements Iterator {
        private Locale initLocale;
        private Locale locale;
        private String branding;
        private String current;
        private boolean defaultInProgress = false;
        private boolean empty = false;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = null;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String ret = this.branding == null ? this.current : this.branding + this.current;
            int lastUnderbar = this.current.lastIndexOf(95);
            if (lastUnderbar == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (lastUnderbar == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, lastUnderbar);
            }
            return ret;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int idx = this.branding.lastIndexOf(95);
                this.branding = idx == 0 ? null : this.branding.substring(0, idx);
                this.empty = false;
            } else {
                this.current = null;
            }
        }
    }

    private static class AttachDynamicThread
    extends Thread {
        private int activateCode;

        AttachDynamicThread(int activateCode) {
            this.setName("*** Profiler Agent Special Execution Thread 5");
            this.activateCode = activateCode;
        }

        public void run() {
            try {
                ProfilerServer.doActivate(this.activateCode);
            }
            catch (Throwable ex) {
                System.err.println("Profiler dynamic attach initialization failed due to:");
                ex.printStackTrace();
            }
        }
    }
}

