/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class RootClassLoadedCommand
extends Command {
    private int[] allLoadedClassLoaderIds;
    private String[] allLoadedClassNames;
    private byte[][] cachedClassFileBytes;
    private int[] parentLoaderIds;
    private int classCount;

    public RootClassLoadedCommand(String[] allLoadedClassNames, int[] loaderIds, byte[][] cachedClassFileBytes, int classCount, int[] parentLoaderIds) {
        super(17);
        this.allLoadedClassNames = allLoadedClassNames;
        this.allLoadedClassLoaderIds = loaderIds;
        this.cachedClassFileBytes = cachedClassFileBytes;
        this.classCount = classCount;
        this.parentLoaderIds = parentLoaderIds;
    }

    RootClassLoadedCommand() {
        super(17);
    }

    public int[] getAllLoadedClassLoaderIds() {
        return this.allLoadedClassLoaderIds;
    }

    public String[] getAllLoadedClassNames() {
        return this.allLoadedClassNames;
    }

    public byte[][] getCachedClassFileBytes() {
        byte[][] res = this.cachedClassFileBytes;
        this.cachedClassFileBytes = null;
        return res;
    }

    public int[] getParentLoaderIds() {
        int[] newParentLoaderIds = new int[this.parentLoaderIds.length];
        System.arraycopy(this.parentLoaderIds, 0, newParentLoaderIds, 0, this.parentLoaderIds.length);
        return newParentLoaderIds;
    }

    public String toString() {
        return super.toString();
    }

    void readObject(ObjectInputStream in) throws IOException {
        int i;
        int len = in.readInt();
        this.allLoadedClassNames = new String[len];
        for (i = 0; i < len; ++i) {
            this.allLoadedClassNames[i] = in.readUTF();
        }
        this.allLoadedClassLoaderIds = new int[len];
        for (i = 0; i < len; ++i) {
            this.allLoadedClassLoaderIds[i] = in.readInt();
        }
        len = in.readInt();
        if (len == 0) {
            this.cachedClassFileBytes = null;
        } else {
            this.cachedClassFileBytes = new byte[len][];
            for (i = 0; i < len; ++i) {
                int bytesLen = in.readInt();
                if (bytesLen == 0) continue;
                this.cachedClassFileBytes[i] = new byte[bytesLen];
                in.readFully(this.cachedClassFileBytes[i]);
            }
        }
        len = in.readInt();
        this.parentLoaderIds = new int[len];
        for (i = 0; i < len; ++i) {
            this.parentLoaderIds[i] = in.readInt();
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeInt(this.classCount);
        for (i = 0; i < this.classCount; ++i) {
            out.writeUTF(this.allLoadedClassNames[i]);
        }
        for (i = 0; i < this.classCount; ++i) {
            int loaderId = this.allLoadedClassLoaderIds[i];
            if (loaderId == -1) {
                loaderId = 0;
            }
            out.writeInt(loaderId);
        }
        if (this.cachedClassFileBytes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.classCount);
            for (i = 0; i < this.classCount; ++i) {
                if (this.cachedClassFileBytes[i] == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(this.cachedClassFileBytes[i].length);
                out.write(this.cachedClassFileBytes[i]);
            }
        }
        out.writeInt(this.parentLoaderIds.length);
        for (i = 0; i < this.parentLoaderIds.length; ++i) {
            out.writeInt(this.parentLoaderIds[i]);
        }
        this.allLoadedClassNames = null;
        this.allLoadedClassLoaderIds = null;
        this.cachedClassFileBytes = null;
        this.parentLoaderIds = null;
    }
}

