/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.codecoverage.CoverageBar;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

final class CoverageReportTopComponent
extends TopComponent {
    private CoverageTableModel model;
    private Project project;
    private static final String PREFERRED_ID = "CoverageReportTopComponent";
    private JButton allTestsButton;
    private JButton clearResultsButton;
    private JButton doneButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable table;
    private CoverageBar totalCoverage;

    CoverageReportTopComponent(Project project, List<FileCoverageSummary> results) {
        Method method;
        this.model = new CoverageTableModel(results);
        this.project = project;
        this.initComponents();
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(6, 4));
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(1000);
        columnModel.getColumn(1).setMaxWidth(300);
        columnModel.getColumn(2).setMaxWidth(150);
        columnModel.getColumn(3).setMaxWidth(150);
        String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.setName(NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CTL_CoverageReportTopComponent", (Object)projectName));
        this.setToolTipText(NbBundle.getMessage(CoverageReportTopComponent.class, (String)"HINT_CoverageReportTopComponent"));
        try {
            method = JTable.class.getMethod("setFillsViewportHeight", new Class[0]);
            if (method != null) {
                method.invoke(null, new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        this.table.setDefaultRenderer(Float.class, new CoverageRenderer());
        this.table.setDefaultRenderer(String.class, new FileRenderer());
        try {
            method = JTable.class.getMethod("setAutoCreateRowSorter", Boolean.TYPE);
            if (method != null) {
                method.invoke((Object)this.table, Boolean.TRUE);
            }
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        this.totalCoverage.setCoveragePercentage(this.model.getTotalCoverage());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new EmptyPaintingTable();
        this.clearResultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.totalCoverage = new CoverageBar();
        this.allTestsButton = new JButton();
        this.doneButton = new JButton();
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CoverageReportTopComponent.this.clicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.clearResultsButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.clearResultsButton.text"));
        this.clearResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageReportTopComponent.this.clearResultsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.jLabel1.text"));
        GroupLayout totalCoverageLayout = new GroupLayout(this.totalCoverage);
        this.totalCoverage.setLayout(totalCoverageLayout);
        totalCoverageLayout.setHorizontalGroup(totalCoverageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 146, Short.MAX_VALUE));
        totalCoverageLayout.setVerticalGroup(totalCoverageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.allTestsButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.allTestsButton.text"));
        this.allTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageReportTopComponent.this.runAllTests(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.doneButton, (String)NbBundle.getMessage(CoverageReportTopComponent.class, (String)"CoverageReportTopComponent.doneButton.text"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageReportTopComponent.this.done(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 551, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.clearResultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allTestsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 216, Short.MAX_VALUE).addComponent(this.doneButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalCoverage, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.totalCoverage, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearResultsButton).addComponent(this.allTestsButton).addComponent(this.doneButton)).addContainerGap()));
    }

    private void clearResultsButtonActionPerformed(ActionEvent evt) {
        CoverageManagerImpl.getInstance().clear(this.project);
    }

    private void clicked(MouseEvent evt) {
        int row;
        if (evt.getClickCount() == 2 && (row = this.table.getSelectedRow()) != -1) {
            try {
                Method method = JTable.class.getMethod("convertRowIndexToModel", Integer.TYPE);
                if (method != null) {
                    row = (Integer)method.invoke((Object)this.table, row);
                }
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            FileCoverageSummary result = (FileCoverageSummary)this.model.getValueAt(row, -1);
            CoverageManagerImpl.getInstance().showFile(this.project, result);
        }
    }

    private void runAllTests(ActionEvent evt) {
        Lookup lookup = this.project.getLookup();
        ActionProvider actionProvider = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class);
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(this.project);
        String action = "test";
        if (coverageProvider != null && coverageProvider.getTestAllAction() != null) {
            action = coverageProvider.getTestAllAction();
        }
        if (actionProvider != null && actionProvider.isActionEnabled("test", lookup)) {
            actionProvider.invokeAction(action, lookup);
        }
    }

    private void done(ActionEvent evt) {
        CoverageManagerImpl.getInstance().setEnabled(this.project, false);
        this.close();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        CoverageManagerImpl.getInstance().closedReport(this.project);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    void updateData(List<FileCoverageSummary> results) {
        assert (EventQueue.isDispatchThread());
        this.model = new CoverageTableModel(results);
        this.table.setModel(this.model);
        this.totalCoverage.setCoveragePercentage(this.model.getTotalCoverage());
    }

    private static class EmptyPaintingTable
    extends JTable {
        private EmptyPaintingTable() {
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getParent() instanceof JViewport && this.getPreferredSize().height < this.getParent().getHeight();
        }
    }

    private class CoverageRenderer
    extends CoverageBar
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            FileCoverageSummary summary = (FileCoverageSummary)table.getValueAt(row, -1);
            boolean isTotalRow = summary == ((CoverageTableModel)table.getModel()).total;
            this.setEmphasize(isTotalRow);
            this.setSelected(isSelected);
            float coverage = ((Float)value).floatValue();
            this.setCoveragePercentage(coverage);
            return this;
        }
    }

    private static class FileRenderer
    extends JLabel
    implements TableCellRenderer {
        private FileRenderer() {
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
            } else {
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            FileCoverageSummary summary = (FileCoverageSummary)table.getValueAt(row, -1);
            FileObject file = summary.getFile();
            this.setText(summary.getDisplayName());
            if (file != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)file);
                    Node node = dobj.getNodeDelegate();
                    Image icon = node.getIcon(2);
                    this.setIcon(new ImageIcon(icon));
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private static class CoverageTableModel
    implements TableModel {
        List<FileCoverageSummary> results;
        FileCoverageSummary total;
        float totalCoverage = 0.0f;

        public CoverageTableModel(List<FileCoverageSummary> results) {
            if (results == null || results.size() == 0) {
                results = new ArrayList<FileCoverageSummary>();
            } else {
                Collections.sort(results);
            }
            int lineCount = 0;
            int executedLineCount = 0;
            int inferredCount = 0;
            int partialCount = 0;
            for (FileCoverageSummary result : results) {
                lineCount += result.getLineCount();
                executedLineCount += result.getExecutedLineCount();
                inferredCount += result.getInferredCount();
                partialCount += result.getPartialCount();
            }
            if (results.size() == 0) {
                results.add(new FileCoverageSummary(null, NbBundle.getMessage(CoverageReportTopComponent.class, (String)"NoData"), 0, 0, 0, 0));
            } else {
                this.total = new FileCoverageSummary(null, "<html><b>" + NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Total") + "</b></html>", lineCount, executedLineCount, inferredCount, partialCount);
                this.totalCoverage = this.total.getCoveragePercentage();
                results.add(this.total);
            }
            this.results = results;
        }

        float getTotalCoverage() {
            return this.totalCoverage;
        }

        @Override
        public int getRowCount() {
            return this.results.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Filename");
                }
                case 2: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"TotalStatements");
                }
                case 3: {
                    return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"NotExecutedStatements");
                }
            }
            return NbBundle.getMessage(CoverageReportTopComponent.class, (String)"Coverage");
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 1: {
                    return Float.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileCoverageSummary result = this.results.get(row);
            switch (col) {
                case -1: {
                    return result;
                }
                case 0: {
                    return result.getDisplayName();
                }
                case 1: {
                    return Float.valueOf(result.getCoveragePercentage());
                }
                case 2: {
                    return result.getLineCount();
                }
                case 3: {
                    return result.getLineCount() - result.getExecutedLineCount();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener listener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener listener) {
        }
    }
}

