/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageBar;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CoverageSideBar
extends JPanel {
    private static final String COVERAGE_SIDEBAR_PROP = "coverageSideBar";
    private static final String COVERAGE_SIDEBAR_FOCUS = "coverageSideBarFocus";
    private static final String FOCUS_KEY_BINDING = "control shift F11";
    private Document document;
    private boolean enabled;
    private JButton allTestsButton;
    private JButton clearButton;
    private CoverageBar coverageBar;
    private JButton jButton1;
    private JLabel label;
    private JButton reportButton;
    private JButton testButton;
    private JLabel warningsLabel;

    public CoverageSideBar(JTextComponent target) {
        CoverageManagerImpl manager;
        this.document = target.getDocument();
        String mimeType = (String)this.document.getProperty("mimeType");
        boolean on = false;
        if (mimeType != null && (on = (manager = CoverageManagerImpl.getInstance()).isEnabled(mimeType))) {
            CoverageProvider provider = this.getProvider();
            on = provider != null ? provider.isEnabled() && manager.getShowEditorBar() : false;
        }
        if (on) {
            this.showCoveragePanel(true);
        } else {
            this.updatePreferredSize();
        }
        AbstractAction focus = new AbstractAction(COVERAGE_SIDEBAR_FOCUS){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageSideBar.this.requestFocusInWindow();
            }
        };
        target.getInputMap().put(KeyStroke.getKeyStroke(FOCUS_KEY_BINDING), COVERAGE_SIDEBAR_FOCUS);
        target.getActionMap().put(COVERAGE_SIDEBAR_FOCUS, focus);
        this.document.putProperty(COVERAGE_SIDEBAR_PROP, this);
    }

    public static CoverageSideBar getSideBar(Document document) {
        return (CoverageSideBar)document.getProperty(COVERAGE_SIDEBAR_PROP);
    }

    public void setCoverage(FileCoverageDetails details) {
        if (details != null) {
            FileCoverageSummary summary = details.getSummary();
            float coverage = summary.getCoveragePercentage();
            if ((double)coverage >= 0.0) {
                this.coverageBar.setCoveragePercentage(coverage);
            }
            long dataModified = details.lastUpdated();
            FileObject fo = details.getFile();
            boolean tooOld = false;
            if (fo != null && dataModified > 0L && dataModified < fo.lastModified().getTime()) {
                tooOld = true;
            } else if (fo != null && fo.isValid()) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    tooOld = dobj.isModified();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (tooOld) {
                this.warningsLabel.setText(NbBundle.getMessage(CoverageSideBar.class, (String)"DataTooOld"));
            } else {
                this.warningsLabel.setText("");
            }
        } else {
            this.coverageBar.setCoveragePercentage(0.0f);
            this.warningsLabel.setText("");
        }
    }

    public boolean isShowingCoverage() {
        return this.enabled;
    }

    public void showCoveragePanel(boolean on) {
        if (on == this.enabled) {
            return;
        }
        this.enabled = on;
        if (on) {
            this.initComponents();
            this.setCoverage(null);
        } else {
            this.removeAll();
        }
        this.updatePreferredSize();
        this.revalidate();
        this.repaint();
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.setPreferredSize(null);
            Dimension preferred = this.getPreferredSize();
            this.setPreferredSize(preferred);
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.coverageBar = new CoverageBar();
        this.warningsLabel = new JLabel();
        this.testButton = new JButton();
        this.allTestsButton = new JButton();
        this.clearButton = new JButton();
        this.reportButton = new JButton();
        this.jButton1 = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.label.text"));
        this.label.setToolTipText(NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.label.toolTipText"));
        this.label.setFocusable(false);
        this.coverageBar.setMinimumSize(new Dimension(40, 10));
        this.warningsLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        Mnemonics.setLocalizedText((AbstractButton)this.testButton, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.testButton.text"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageSideBar.this.testOne(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.allTestsButton, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.allTestsButton.text"));
        this.allTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageSideBar.this.allTests(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearButton, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.clearButton.text"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageSideBar.this.clearResults(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reportButton, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.reportButton.text"));
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageSideBar.this.report(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(CoverageSideBar.class, (String)"CoverageSideBar.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageSideBar.this.done(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coverageBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 86, Short.MAX_VALUE).addComponent(this.warningsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allTestsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label).addComponent(this.coverageBar, -2, -1, -2).addComponent(this.jButton1).addComponent(this.reportButton).addComponent(this.clearButton).addComponent(this.allTestsButton).addComponent(this.testButton).addComponent(this.warningsLabel)));
    }

    private void clearResults(ActionEvent evt) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().clear(project);
        }
    }

    private void allTests(ActionEvent evt) {
        String action = "test";
        CoverageProvider provider = this.getProvider();
        if (provider != null && provider.getTestAllAction() != null) {
            action = provider.getTestAllAction();
        }
        this.runAction(action);
    }

    private void testOne(ActionEvent evt) {
        this.runAction("test.single");
    }

    private void report(ActionEvent evt) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().showReport(project);
        }
    }

    private void done(ActionEvent evt) {
        Project project = this.getProject();
        if (project != null) {
            CoverageManagerImpl.getInstance().setEnabled(project, false);
        }
        this.showCoveragePanel(false);
    }

    private void runAction(String action) {
        Project project = this.getProject();
        if (project != null) {
            ActionProvider provider;
            Lookup lookup = project.getLookup();
            FileObject fo = GsfUtilities.findFileObject((Document)this.document);
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    lookup = dobj.getLookup();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((provider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) != null && provider.isActionEnabled(action, lookup)) {
                provider.invokeAction(action, lookup);
            }
        }
    }

    private Project getProject() {
        FileObject fo = GsfUtilities.findFileObject((Document)this.document);
        if (fo != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            return project;
        }
        return null;
    }

    private CoverageProvider getProvider() {
        Project project = this.getProject();
        if (project != null) {
            return CoverageManagerImpl.getProvider(project);
        }
        return null;
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new CoverageSideBar(target);
        }
    }
}

