/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.netbeans.modules.web.jsf.api.editor.JSFResourceBundlesProvider;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FaceletsELPlugin
implements ELPlugin {
    private static final String PLUGIN_NAME = "JSF Facelets EL Plugin";
    private Collection<ImplicitObject> IMPL_OBJECTS;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return Collections.singletonList("text/xhtml");
    }

    public synchronized Collection<ImplicitObject> getImplicitObjects(FileObject fileObject) {
        if (!this.getMimeTypes().contains(fileObject.getMIMEType())) {
            return Collections.emptyList();
        }
        if (this.IMPL_OBJECTS == null) {
            this.IMPL_OBJECTS = new ArrayList<ImplicitObject>(9);
            this.IMPL_OBJECTS.addAll(FaceletsELPlugin.getScopeObjects());
            this.IMPL_OBJECTS.add(new FacesContextObject());
            this.IMPL_OBJECTS.add(new ApplicationObject());
            this.IMPL_OBJECTS.add(new ComponentObject());
            this.IMPL_OBJECTS.add(new FlashObject());
            this.IMPL_OBJECTS.add(new ResourceObject());
            this.IMPL_OBJECTS.add(new SessionObject());
            this.IMPL_OBJECTS.add(new ViewObject());
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cookie", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("cc", null, ImplicitObjectType.RAW));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("request", null, ImplicitObjectType.OBJECT_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("header", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("headerValues", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("initParam", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("param", null, ImplicitObjectType.MAP_TYPE));
            this.IMPL_OBJECTS.add(new JsfImplicitObject("paramValues", null, ImplicitObjectType.MAP_TYPE));
        }
        return this.IMPL_OBJECTS;
    }

    public List<ResourceBundle> getResourceBundles(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return Collections.emptyList();
        }
        return JSFResourceBundlesProvider.getResourceBundles((WebModule)webModule);
    }

    private static Collection<ImplicitObject> getScopeObjects() {
        ArrayList<ImplicitObject> arrayList = new ArrayList<ImplicitObject>(4);
        arrayList.add(new JsfImplicitObject("sessionScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("applicationScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("requestScope", null, ImplicitObjectType.SCOPE_TYPE));
        arrayList.add(new JsfImplicitObject("viewScope", null, ImplicitObjectType.SCOPE_TYPE));
        return arrayList;
    }

    public List<Function> getFunctions(FileObject fileObject) {
        Object object;
        ArrayList<Function> arrayList = new ArrayList<Function>();
        final HashMap hashMap = new HashMap();
        try {
            object = Source.create((FileObject)fileObject);
            ParserManager.parse(Collections.singletonList(object), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (result instanceof HtmlParserResult) {
                        hashMap.putAll(((HtmlParserResult)result).getNamespaces());
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        object = DefaultFaceletLibraries.getInstance().getLibrariesDescriptors();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)hashMap.get(entry.getKey());
            if (string == null) continue;
            arrayList.addAll(FaceletsELPlugin.getFunctionsFromDescriptor((FaceletsLibraryDescriptor)entry.getValue(), string));
        }
        return arrayList;
    }

    private static List<Function> getFunctionsFromDescriptor(FaceletsLibraryDescriptor faceletsLibraryDescriptor, String string) {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (Map.Entry<String, org.netbeans.modules.web.jsfapi.api.Function> entry : faceletsLibraryDescriptor.getFunctions().entrySet()) {
            org.netbeans.modules.web.jsfapi.api.Function function = entry.getValue();
            arrayList.add(new Function(string + ":" + function.getName(), FaceletsELPlugin.getReturnTypeForSignature(function.getSignature()), FaceletsELPlugin.getParametersForSignature(function.getSignature()), function.getDescription()));
        }
        return arrayList;
    }

    private static String getReturnTypeForSignature(String string) {
        String string2 = string.substring(0, string.indexOf(" "));
        return FaceletsELPlugin.getSimpleNameForType(string2.trim());
    }

    private static List<String> getParametersForSignature(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        for (String string3 : string2.split(",")) {
            arrayList.add(FaceletsELPlugin.getSimpleNameForType(string3.trim()));
        }
        return arrayList;
    }

    private static String getSimpleNameForType(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    private static class JsfImplicitObject
    implements ImplicitObject {
        private String name;
        private String clazz;
        private ImplicitObjectType type;

        public JsfImplicitObject(String string, String string2, ImplicitObjectType implicitObjectType) {
            this.name = string;
            this.clazz = string2;
            this.type = implicitObjectType;
        }

        public String getName() {
            return this.name;
        }

        public ImplicitObjectType getType() {
            return this.type;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    static class ViewObject
    extends JsfImplicitObject {
        public ViewObject() {
            super("view", "javax.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class SessionObject
    extends JsfImplicitObject {
        public SessionObject() {
            super("session", null, ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ResourceObject
    extends JsfImplicitObject {
        public ResourceObject() {
            super("resource", "javax.faces.application.ResourceHandler", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FlashObject
    extends JsfImplicitObject {
        public FlashObject() {
            super("flash", "javax.faces.context.Flash", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ComponentObject
    extends JsfImplicitObject {
        public ComponentObject() {
            super("component", "javax.faces.component.UIComponent", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class ApplicationObject
    extends JsfImplicitObject {
        public ApplicationObject() {
            super("application", null, ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FacesContextObject
    extends JsfImplicitObject {
        public FacesContextObject() {
            super("facesContext", "javax.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }
}

