/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModelFactory;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.Behavior;
import org.netbeans.modules.web.jsf.api.metamodel.Component;
import org.netbeans.modules.web.jsf.api.metamodel.FacesConverter;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelElement;
import org.netbeans.modules.web.jsf.api.metamodel.ModelUnit;
import org.netbeans.modules.web.jsf.api.metamodel.SystemEventListener;
import org.netbeans.modules.web.jsf.api.metamodel.Validator;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationBehaviorRenderer;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationRenderer;
import org.netbeans.modules.web.jsf.impl.metamodel.BehaviorFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ClientBehaviorRendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ComponentFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ConverterFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ElementFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.JsfModelManagers;
import org.netbeans.modules.web.jsf.impl.metamodel.ManagedBeanFinder;
import org.netbeans.modules.web.jsf.impl.metamodel.ObjectProviders;
import org.netbeans.modules.web.jsf.impl.metamodel.RendererImpl;
import org.netbeans.modules.web.jsf.impl.metamodel.ValidatorFinder;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class JsfModelImpl
extends JsfModelManagers
implements JsfModel {
    private final PropertyChangeSupport changeSupport;
    private ModelUnit unit;
    private List<JSFConfigModel> models;
    private JSFConfigModel facesConfigModel;
    private Map<FileObject, WeakReference<JSFConfigModel>> modelCache = new HashMap<FileObject, WeakReference<JSFConfigModel>>();
    private static final Map<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>> FINDERS = new HashMap<Class<? extends JsfModelElement>, ElementFinder<? extends JsfModelElement>>();
    private RequestProcessor requestProcessor = new RequestProcessor();

    JsfModelImpl(ModelUnit unit, AnnotationModelHelper helper) {
        super(helper);
        this.unit = unit;
        this.changeSupport = new PropertyChangeSupport(this);
        this.models = new LinkedList<JSFConfigModel>();
        this.registerChangeListeners();
        this.initModels();
    }

    @Override
    public <T extends JsfModelElement> List<T> getElements(Class<T> clazz) {
        Boolean isComplete;
        FacesConfig config;
        ElementFinder<T> finder = this.getFinder(clazz);
        Class<Object> type = finder == null ? clazz : finder.getConfigType();
        LinkedList<JsfModelElement> result = new LinkedList<JsfModelElement>();
        for (FacesConfig config2 : this.getFacesConfigs()) {
            List children = config2.getChildren(type);
            for (JSFConfigComponent component : children) {
                if (clazz.isAssignableFrom(FacesManagedBean.class) && ((ManagedBean)component).getManagedBeanClass() == null) continue;
                result.add((JsfModelElement)((Object)component));
            }
        }
        JSFConfigModel model = this.getMainModel();
        boolean metadataComplete = false;
        if (model != null && (config = model.getRootComponent()) != null && (isComplete = config.isMetaDataComplete()) != null) {
            metadataComplete = isComplete;
        }
        if (finder != null && !metadataComplete) {
            result.addAll(finder.getAnnotations(this));
        }
        return result;
    }

    @Override
    public List<FacesConfig> getFacesConfigs() {
        ArrayList<FacesConfig> configModels = new ArrayList<FacesConfig>();
        for (JSFConfigModel model : this.getModelsVariable()) {
            FacesConfig fc;
            try {
                model.sync();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if ((fc = model.getRootComponent()) == null) continue;
            configModels.add(fc);
        }
        return configModels;
    }

    private void synch(JSFConfigModel model) {
        if (model != null) {
            try {
                model.sync();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public FacesConfig getMainConfig() {
        JSFConfigModel model = this.getMainModel();
        this.synch(model);
        return model != null ? model.getRootComponent() : null;
    }

    @Override
    public List<JSFConfigModel> getModels() {
        List<JSFConfigModel> mods = this.getModelsVariable();
        for (JSFConfigModel model : mods) {
            try {
                model.sync();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(mods);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    protected List<AnnotationBehaviorRenderer> getClientBehaviorRenderers(String renderKitId) {
        Boolean complete;
        FacesConfig config = this.getMainConfig();
        if (config != null && (complete = config.isMetaDataComplete()) != null && complete.booleanValue()) {
            return Collections.emptyList();
        }
        Collection collection = this.getClientBehaviorManager().getObjects();
        ArrayList<AnnotationBehaviorRenderer> result = new ArrayList<AnnotationBehaviorRenderer>(collection.size());
        for (ClientBehaviorRendererImpl renderer : collection) {
            String id = renderer.getRenderKitId();
            if (!renderKitId.equals(id)) continue;
            result.add(renderer);
        }
        return result;
    }

    @Override
    protected List<AnnotationRenderer> getRenderers(String renderKitId) {
        Boolean complete;
        FacesConfig config = this.getMainConfig();
        if (config != null && (complete = config.isMetaDataComplete()) != null && complete.booleanValue()) {
            return Collections.emptyList();
        }
        Collection collection = this.getRendererManager().getObjects();
        ArrayList<AnnotationRenderer> result = new ArrayList<AnnotationRenderer>(collection.size());
        for (RendererImpl renderer : collection) {
            String id = renderer.getRenderKitId();
            if (!renderKitId.equals(id)) continue;
            result.add(renderer);
        }
        return result;
    }

    @Override
    protected List<SystemEventListener> getSystemEventListeners() {
        Collection collection = this.getSystemEventManager().getObjects();
        List<SystemEventListener> listeners = ObjectProviders.findApplicationSystemEventListeners(this.getHelper());
        ArrayList<SystemEventListener> result = new ArrayList<SystemEventListener>(collection.size() + listeners.size());
        result.addAll(collection);
        result.addAll(listeners);
        return result;
    }

    private PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    private synchronized void setModelsVariable(List<JSFConfigModel> models, JSFConfigModel model) {
        this.models = models;
        this.facesConfigModel = model;
    }

    private synchronized List<JSFConfigModel> getModelsVariable() {
        return this.models;
    }

    private synchronized JSFConfigModel getMainModel() {
        return this.facesConfigModel;
    }

    private JSFConfigModel createModel(FileObject fo) {
        JSFConfigModel model = this.getCachedModel(fo);
        if (model == null) {
            try {
                ModelSource source = Utilities.createModelSource((FileObject)fo, (boolean)true);
                Lookup lookup = source.getLookup();
                lookup = new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)this)});
                source = new ModelSource(lookup, true);
                model = JSFConfigModelFactory.getInstance().getModel(source);
                this.putCachedModel(fo, model);
            }
            catch (CatalogModelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return model;
    }

    private synchronized JSFConfigModel getCachedModel(FileObject fo) {
        WeakReference<JSFConfigModel> ref = this.modelCache.get(fo);
        if (ref != null) {
            return (JSFConfigModel)ref.get();
        }
        return null;
    }

    private synchronized void putCachedModel(FileObject fo, JSFConfigModel model) {
        this.modelCache.put(fo, new WeakReference<JSFConfigModel>(model));
    }

    private void initModels() {
        LinkedList<JSFConfigModel> mods = new LinkedList<JSFConfigModel>();
        JSFConfigModel facesConfigMod = null;
        FileObject facesConfig = this.getUnit().getApplicationFacesConfig();
        if (facesConfig != null) {
            facesConfigMod = this.createModel(facesConfig);
            mods.add(facesConfigMod);
        }
        for (FileObject fo : this.getUnit().getApplicationConfigurationResources()) {
            mods.add(this.createModel(fo));
        }
        this.setModelsVariable(mods, facesConfigMod);
        this.getChangeSupport().firePropertyChange("model-changed", null, null);
    }

    private ModelUnit getUnit() {
        return this.unit;
    }

    private <T extends JsfModelElement> ElementFinder<T> getFinder(Class<T> clazz) {
        return FINDERS.get(clazz);
    }

    private void registerChangeListeners() {
        this.unit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JsfModelImpl.this.requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        JsfModelImpl.this.initModels();
                    }
                });
            }
        });
    }

    static {
        FINDERS.put(Behavior.class, new BehaviorFinder());
        FINDERS.put(Component.class, new ComponentFinder());
        FINDERS.put(FacesConverter.class, new ConverterFinder());
        FINDERS.put(FacesManagedBean.class, new ManagedBeanFinder());
        FINDERS.put(Validator.class, new ValidatorFinder());
    }
}

