/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanIterator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ManagedBeanPanelVisual
extends JPanel
implements HelpCtx.Provider,
ListDataListener,
DocumentListener {
    private final DefaultComboBoxModel scopeModel = new DefaultComboBoxModel();
    private boolean isCDIEnabled = false;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxConfigFile;
    private JComboBox jComboBoxScope;
    private JLabel jLabelConfigFile;
    private JLabel jLabelDesc;
    private JLabel jLabelName;
    private JLabel jLabelScope;
    private JScrollPane jScrollPaneDesc;
    private JTextArea jTextAreaDesc;
    private JTextField jTextFieldName;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ManagedBeanPanelVisual(Project proj) {
        this.initComponents();
        WebModule wm = WebModule.getWebModule((FileObject)proj.getProjectDirectory());
        if (wm != null) {
            String[] configFiles = JSFConfigUtilities.getConfigFiles(wm);
            if (configFiles.length > 0) {
                FileObject documentBase = wm.getDocumentBase();
                ArrayList<String> files = new ArrayList<String>();
                for (int i = 0; i < configFiles.length; ++i) {
                    if (documentBase.getFileObject(configFiles[i]) == null) continue;
                    files.add(configFiles[i]);
                }
                configFiles = files.toArray(new String[files.size()]);
            }
            this.jComboBoxConfigFile.setModel(new DefaultComboBoxModel<String>(configFiles));
            if (configFiles.length == 0) {
                this.jCheckBox1.setEnabled(false);
                this.jComboBoxConfigFile.setEnabled(false);
            } else {
                Profile profile = wm.getJ2eeProfile();
                if (profile != Profile.JAVA_EE_6_FULL && profile != Profile.JAVA_EE_6_WEB) {
                    this.jCheckBox1.setSelected(true);
                    this.jCheckBox1.setEnabled(false);
                }
            }
        }
        this.isCDIEnabled = JSFUtils.isCDIEnabled(wm);
        Enum[] scopes = this.isCDIEnabled ? ManagedBeanIterator.NamedScope.values() : ManagedBean.Scope.values();
        for (Enum scope : scopes) {
            this.scopeModel.addElement(scope);
        }
        this.jTextFieldName.setText("newJSFManagedBean");
        this.jTextFieldName.getDocument().addDocumentListener(this);
    }

    private void updateScopeModel(boolean addToConfig) {
        if (this.isCDIEnabled && addToConfig) {
            this.scopeModel.removeAllElements();
            for (ManagedBean.Scope scope : ManagedBean.Scope.values()) {
                this.scopeModel.addElement(scope);
            }
        } else if (this.isCDIEnabled && !addToConfig) {
            this.scopeModel.removeAllElements();
            for (ManagedBeanIterator.NamedScope scope : ManagedBeanIterator.NamedScope.values()) {
                this.scopeModel.addElement(scope);
            }
        } else {
            return;
        }
        this.jComboBoxScope.setModel(this.scopeModel);
        this.repaint();
    }

    private void initComponents() {
        this.jLabelConfigFile = new JLabel();
        this.jComboBoxConfigFile = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelScope = new JLabel();
        this.jComboBoxScope = new JComboBox();
        this.jLabelDesc = new JLabel();
        this.jScrollPaneDesc = new JScrollPane();
        this.jTextAreaDesc = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.jLabelConfigFile.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_ConfigFile").charAt(0));
        this.jLabelConfigFile.setLabelFor(this.jComboBoxConfigFile);
        this.jLabelConfigFile.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_ConfigFile"));
        this.jComboBoxConfigFile.setEnabled(this.jCheckBox1.isSelected());
        this.jComboBoxConfigFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagedBeanPanelVisual.this.jComboBoxConfigFileActionPerformed(evt);
            }
        });
        this.jLabelName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Name").charAt(0));
        this.jLabelName.setLabelFor(this.jTextFieldName);
        this.jLabelName.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Name"));
        this.jLabelScope.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_Scope").charAt(0));
        this.jLabelScope.setLabelFor(this.jComboBoxScope);
        this.jLabelScope.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Scope"));
        this.jComboBoxScope.setModel(this.scopeModel);
        this.jLabelDesc.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_BeanDescription").charAt(0));
        this.jLabelDesc.setLabelFor(this.jTextAreaDesc);
        this.jLabelDesc.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_BeanDescription"));
        this.jTextAreaDesc.setColumns(20);
        this.jTextAreaDesc.setRows(5);
        this.jScrollPaneDesc.setViewportView(this.jTextAreaDesc);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jTextAreaDesc.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BeanDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Add_data_to_conf_file"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ManagedBeanPanelVisual.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelName).addComponent(this.jLabelScope).addComponent(this.jLabelDesc).addComponent(this.jLabelConfigFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldName, -1, 302, Short.MAX_VALUE).addComponent(this.jComboBoxScope, 0, 302, Short.MAX_VALUE).addComponent(this.jScrollPaneDesc, -1, 302, Short.MAX_VALUE).addComponent(this.jComboBoxConfigFile, 0, 302, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelConfigFile).addComponent(this.jComboBoxConfigFile, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxScope, -2, -1, -2).addComponent(this.jLabelScope)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDesc).addComponent(this.jScrollPaneDesc, -1, 102, Short.MAX_VALUE))));
        this.jComboBoxConfigFile.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ConfigurationFile"));
        this.jComboBoxScope.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ManagedBeanScope"));
    }

    private void jComboBoxConfigFileActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        boolean addToConfig = this.jCheckBox1.isSelected();
        this.jComboBoxConfigFile.setEnabled(addToConfig);
        this.updateScopeModel(addToConfig);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String configFile = (String)this.jComboBoxConfigFile.getSelectedItem();
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        SourceGroup[] sources = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sources.length == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_No_Sources_found"));
            return false;
        }
        if (configFile == null) {
            if (!(Utilities.isJavaEE6((TemplateWizard)((TemplateWizard)wizardDescriptor)) || this.isAddBeanToConfig() || JSFUtils.isJavaEE5((TemplateWizard)wizardDescriptor) && JSFUtils.isJSF20(wm))) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_NoConfigFile"));
                return false;
            }
            return true;
        }
        FileObject dir = wm.getDocumentBase();
        FileObject fo = dir.getFileObject(configFile);
        FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fo, true).getRootComponent();
        if (facesConfig == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_InvalidConfigFile"));
            return false;
        }
        String name = this.jTextFieldName.getText();
        if (name.trim().equals("")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_InvalidBeanName"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    void read(WizardDescriptor settings) {
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("ConfigFile", this.jComboBoxConfigFile.getSelectedItem());
        settings.putProperty("Name", (Object)this.jTextFieldName.getText());
        settings.putProperty("Scope", this.jComboBoxScope.getSelectedItem());
        settings.putProperty("Description", (Object)this.jTextAreaDesc.getText());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ManagedBeanPanelVisual.class);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public void setManagedBeanName(String name) {
        this.jTextFieldName.setText(name);
    }

    public String getManagedBeanName() {
        return this.jTextFieldName.getText();
    }

    public boolean isAddBeanToConfig() {
        return this.jCheckBox1.isSelected();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }
}

