/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.php.project.PhpLanguageOptionsAccessor;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PhpLanguageOptions {
    public static final boolean SHORT_TAGS_ENABLED = true;
    public static final boolean ASP_TAGS_ENABLED = false;
    public static final String PROP_SHORT_TAGS = PhpLanguageOptions.class.getName() + ".shortTags";
    public static final String PROP_ASP_TAGS = PhpLanguageOptions.class.getName() + ".aspTags";
    public static final String PROP_PHP_VERSION = PhpLanguageOptions.class.getName() + ".phpVersion";
    static final PhpLanguageOptions INSTANCE = new PhpLanguageOptions();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private PhpLanguageOptions() {
    }

    public static PhpLanguageOptions getDefault() {
        return INSTANCE;
    }

    public Properties getProperties(FileObject file) {
        PhpProject phpProject;
        boolean shortTagsEnabled = true;
        boolean aspTagsEnabled = false;
        PhpVersion phpVersion = PhpVersion.getDefault();
        if (file != null && (phpProject = PhpProjectUtils.getPhpProject(file)) != null) {
            shortTagsEnabled = ProjectPropertiesSupport.areShortTagsEnabled(phpProject);
            aspTagsEnabled = ProjectPropertiesSupport.areAspTagsEnabled(phpProject);
            phpVersion = ProjectPropertiesSupport.getPhpVersion(phpProject);
        }
        return new Properties(shortTagsEnabled, aspTagsEnabled, phpVersion);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    static {
        PhpLanguageOptionsAccessor.setDefault(new PhpLanguageOptionsAccessor(){

            @Override
            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                INSTANCE.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }

    public static final class Properties {
        private final boolean shortTagsEnabled;
        private final boolean aspTagsEnabled;
        private final PhpVersion phpVersion;

        Properties(boolean shorTagsEnabled, boolean aspTagsEnabled, PhpVersion phpVersion) {
            this.shortTagsEnabled = shorTagsEnabled;
            this.aspTagsEnabled = aspTagsEnabled;
            this.phpVersion = phpVersion;
        }

        public boolean areShortTagsEnabled() {
            return this.shortTagsEnabled;
        }

        public boolean areAspTagsEnabled() {
            return this.aspTagsEnabled;
        }

        public PhpVersion getPhpVersion() {
            return this.phpVersion;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append(this.getClass().getName());
            sb.append(" [shorTagsEnabled: ");
            sb.append(this.shortTagsEnabled);
            sb.append(", aspTagsEnabled: ");
            sb.append(this.aspTagsEnabled);
            sb.append(", PHP version: ");
            sb.append((Object)this.phpVersion);
            sb.append("]");
            return sb.toString();
        }
    }

    public static final class PhpVersion
    extends Enum<PhpVersion> {
        public static final /* enum */ PhpVersion PHP_5 = new PhpVersion(NbBundle.getMessage(PhpLanguageOptions.class, (String)"PHP_5"));
        public static final /* enum */ PhpVersion PHP_53 = new PhpVersion(NbBundle.getMessage(PhpLanguageOptions.class, (String)"PHP_53"));
        private final String displayName;
        private static final /* synthetic */ PhpVersion[] $VALUES;

        public static PhpVersion[] values() {
            return (PhpVersion[])$VALUES.clone();
        }

        public static PhpVersion valueOf(String name) {
            return Enum.valueOf(PhpVersion.class, name);
        }

        private PhpVersion(String displayName) {
            assert (displayName != null);
            this.displayName = displayName;
        }

        public static PhpVersion getDefault() {
            PhpVersion[] phpVersions = PhpVersion.values();
            return phpVersions[phpVersions.length - 1];
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        static {
            $VALUES = new PhpVersion[]{PHP_5, PHP_53};
        }
    }
}

