/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class RemoteUtils {
    private static final Logger LOGGER = Logger.getLogger(RemoteUtils.class.getName());

    private RemoteUtils() {
    }

    public static void processRemoteException(RemoteException remoteException) {
        String title = Bundle.LBL_RemoteError();
        StringBuilder message = new StringBuilder(remoteException.getMessage());
        String remoteServerAnswer = remoteException.getRemoteServerAnswer();
        Throwable cause = remoteException.getCause();
        if (remoteServerAnswer != null && remoteServerAnswer.length() > 0) {
            message.append(Bundle.MSG_RemoteErrorReason(remoteServerAnswer));
        } else if (cause != null) {
            message.append(Bundle.MSG_RemoteErrorReason(cause.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)message.toString(), title, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
    }

    public static String sanitizeDirectoryPath(String directoryPath) {
        while (!directoryPath.equals("/") && directoryPath.endsWith("/")) {
            LOGGER.log(Level.FINE, "Removing ending slash from directory {0}", directoryPath);
            directoryPath = directoryPath.substring(0, directoryPath.length() - "/".length());
        }
        return directoryPath;
    }
}

