/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.NbBundle;

final class MacPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php";
    private static final PhpEnvironment MAMP = new MampPhpEnvironment();

    MacPhpEnvironment() {
    }

    @Override
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
        return MAMP.getDocumentRoots(projectName);
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        LinkedList<String> phps = new LinkedList<String>();
        phps.addAll(MacPhpEnvironment.getAllPhpInterpreters(PHP));
        phps.addAll(MAMP.getAllPhpInterpreters());
        return phps;
    }

    private static final class MampPhpEnvironment
    extends PhpEnvironment {
        private MampPhpEnvironment() {
        }

        @Override
        protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
            File mamp = new File("/Applications/MAMP/htdocs");
            if (mamp.isDirectory()) {
                String documentRoot = MampPhpEnvironment.getFolderName(mamp, projectName);
                String url = MampPhpEnvironment.getDefaultUrl(projectName, 8888);
                String hint = NbBundle.getMessage(MampPhpEnvironment.class, (String)"TXT_MampHtDocs");
                return Collections.singletonList(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, true));
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> getAllPhpInterpreters() {
            File php = new File("/Applications/MAMP/bin/php5/bin/php");
            if (php.isFile()) {
                return Collections.singletonList(php.getAbsolutePath());
            }
            return Collections.emptyList();
        }
    }
}

