/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.filesystems.FileObject;

public final class PhpUnitTestRunInfo {
    private final FileObject workingDirectory;
    private final FileObject startFile;
    private final String testName;
    private final List<Testcase> customTests = new CopyOnWriteArrayList<Testcase>();
    private volatile boolean rerun = false;
    private volatile String testGroups;

    public PhpUnitTestRunInfo(FileObject workingDirectory, FileObject startFile, String testName) {
        assert (workingDirectory != null);
        assert (startFile != null);
        this.workingDirectory = workingDirectory;
        this.startFile = startFile;
        this.testName = testName;
    }

    public FileObject getStartFile() {
        return this.startFile;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean allTests() {
        return this.testName == null;
    }

    public FileObject getWorkingDirectory() {
        return this.workingDirectory;
    }

    public List<Testcase> getCustomTests() {
        return new ArrayList<Testcase>(this.customTests);
    }

    public void resetCustomTests() {
        this.customTests.clear();
    }

    public void setCustomTests(Collection<Testcase> tests) {
        this.resetCustomTests();
        this.customTests.addAll(tests);
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public String getTestGroups() {
        return this.testGroups;
    }

    public void setTestGroups(String testGroups) {
        this.testGroups = testGroups;
    }
}

