/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BrowseTestSources
extends JPanel {
    private static final long serialVersionUID = 1463321897654268L;
    private final PhpProject phpProject;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel infoLabel;
    private JButton testSourcesBrowseButton;
    private JLabel testSourcesLabel;
    private JTextField testSourcesTextField;

    public BrowseTestSources(PhpProject phpProject, String title) {
        assert (phpProject != null);
        assert (title != null);
        this.phpProject = phpProject;
        this.initComponents();
        this.infoLabel.setText(title);
        this.testSourcesTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                BrowseTestSources.this.validateTestSources();
            }
        });
    }

    public boolean open() {
        this.dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(BrowseTestSources.class, (String)"LBL_DirectoryForProject", (Object)ProjectUtils.getInformation((Project)this.phpProject).getDisplayName()), true, 2, DialogDescriptor.OK_OPTION, null);
        this.notificationLineSupport = this.dialogDescriptor.createNotificationLineSupport();
        this.dialogDescriptor.setValid(false);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dialogDescriptor) == DialogDescriptor.OK_OPTION;
    }

    public String getTestSources() {
        return this.testSourcesTextField.getText();
    }

    void validateTestSources() {
        assert (this.notificationLineSupport != null);
        String testSources = this.testSourcesTextField.getText();
        String error = Utils.validateTestSources(this.phpProject, testSources);
        if (error != null) {
            this.notificationLineSupport.setErrorMessage(error);
            this.dialogDescriptor.setValid(false);
            return;
        }
        String warning = Utils.warnTestSources(this.phpProject, testSources);
        if (warning != null) {
            this.notificationLineSupport.setWarningMessage(warning);
            this.dialogDescriptor.setValid(true);
            return;
        }
        this.notificationLineSupport.setInformationMessage(NbBundle.getMessage(BrowseTestSources.class, (String)"LBL_PhpUnitIncludePathInfo"));
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.testSourcesLabel = new JLabel();
        this.testSourcesTextField = new JTextField();
        this.testSourcesBrowseButton = new JButton();
        this.setFocusTraversalPolicy(null);
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        this.testSourcesLabel.setLabelFor(this.testSourcesTextField);
        Mnemonics.setLocalizedText((JLabel)this.testSourcesLabel, (String)NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testSourcesBrowseButton, (String)NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesBrowseButton.text"));
        this.testSourcesBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowseTestSources.this.testSourcesBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel).addGroup(layout.createSequentialGroup().addComponent(this.testSourcesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testSourcesTextField, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testSourcesBrowseButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testSourcesLabel).addComponent(this.testSourcesTextField, -2, -1, -2).addComponent(this.testSourcesBrowseButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.testSourcesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesLabel.AccessibleContext.accessibleName"));
        this.testSourcesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesLabel.AccessibleContext.accessibleDescription"));
        this.testSourcesTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesTextField.AccessibleContext.accessibleName"));
        this.testSourcesTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesTextField.AccessibleContext.accessibleDescription"));
        this.testSourcesBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesBrowseButton.AccessibleContext.accessibleName"));
        this.testSourcesBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.testSourcesBrowseButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseTestSources.class, (String)"BrowseTestSources.AccessibleContext.accessibleDescription"));
    }

    private void testSourcesBrowseButtonActionPerformed(ActionEvent evt) {
        Utils.browseTestSources(this.testSourcesTextField, this.phpProject);
    }
}

