/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.logicalview.Nodes;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportantFilesNodeFactory
implements NodeFactory {
    static final Logger LOGGER = Logger.getLogger(ImportantFilesNodeFactory.class.getName());

    public NodeList<?> createNodes(Project p) {
        PhpProject project = (PhpProject)p.getLookup().lookup(PhpProject.class);
        return new ImportantFilesChildrenList(project);
    }

    private static final class ImportantFileNode
    extends FilterNode {
        private final Pair<PhpFrameworkProvider, FileObject> pair;
        private final FileObject sourceDir;

        public ImportantFileNode(Pair<PhpFrameworkProvider, FileObject> pair, FileObject sourceDir) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)((FileObject)pair.second)).getNodeDelegate());
            this.pair = pair;
            this.sourceDir = sourceDir;
        }

        public String getShortDescription() {
            String filepath = FileUtil.getRelativePath((FileObject)this.sourceDir, (FileObject)((FileObject)this.pair.second));
            if (filepath == null) {
                filepath = FileUtil.getFileDisplayName((FileObject)((FileObject)this.pair.second));
            }
            return NbBundle.getMessage(ImportantFileNode.class, (String)"LBL_ImportantFileTooltip", (Object)filepath, (Object)((PhpFrameworkProvider)this.pair.first).getName());
        }
    }

    private static class ImportantFilesChildFactory
    extends ChildFactory.Detachable<Pair<PhpFrameworkProvider, FileObject>> {
        private static final RequestProcessor RP = new RequestProcessor(ImportantFilesChildFactory.class.getName(), Runtime.getRuntime().availableProcessors());
        static final int FILE_CHANGE_DELAY = 300;
        private final PhpProject project;
        private final FileChangeListener fileChangeListener = new ImportantFilesListener();
        final RequestProcessor.Task fsChange = RP.create(new Runnable(){

            @Override
            public void run() {
                ImportantFilesChildFactory.this.refresh();
            }
        });

        public ImportantFilesChildFactory(PhpProject project) {
            this.project = project;
        }

        protected boolean createKeys(List<Pair<PhpFrameworkProvider, FileObject>> toPopulate) {
            toPopulate.addAll(this.getImportantFiles());
            return true;
        }

        protected Node createNodeForKey(Pair<PhpFrameworkProvider, FileObject> key) {
            try {
                return new ImportantFileNode(key, ProjectPropertiesSupport.getSourcesDirectory(this.project));
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                return null;
            }
        }

        public void refresh() {
            this.refresh(false);
        }

        public void addNotify() {
            super.addNotify();
            this.attachListener();
        }

        List<Pair<PhpFrameworkProvider, FileObject>> getImportantFiles() {
            LinkedList<Pair<PhpFrameworkProvider, FileObject>> files = new LinkedList<Pair<PhpFrameworkProvider, FileObject>>();
            PhpModule phpModule = this.project.getPhpModule();
            PhpVisibilityQuery phpVisibilityQuery = PhpVisibilityQuery.forProject(this.project);
            for (PhpFrameworkProvider frameworkProvider : this.project.getFrameworks()) {
                for (File file : frameworkProvider.getConfigurationFiles(phpModule)) {
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    if (fileObject.isFolder()) {
                        IllegalStateException ex = new IllegalStateException("No folders allowed among configuration files [" + fileObject.getNameExt() + " for " + frameworkProvider.getIdentifier() + "]");
                        LOGGER.log(Level.INFO, ex.getMessage(), ex);
                        continue;
                    }
                    if (phpVisibilityQuery.isVisible(fileObject)) {
                        files.add((Pair<PhpFrameworkProvider, FileObject>)Pair.of((Object)frameworkProvider, (Object)fileObject));
                        continue;
                    }
                    LOGGER.log(Level.INFO, "File {0} ignored (not visible)", fileObject.getPath());
                }
            }
            return files;
        }

        private void attachListener() {
            try {
                FileSystem fileSystem = ProjectPropertiesSupport.getSourcesDirectory(this.project).getFileSystem();
                fileSystem.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fileSystem));
            }
            catch (FileStateInvalidException exc) {
                LOGGER.log(Level.WARNING, exc.getMessage(), exc);
            }
        }

        void refreshNodes() {
            this.fsChange.schedule(300);
        }

        private class ImportantFilesListener
        extends FileChangeAdapter {
            private ImportantFilesListener() {
            }

            public void fileRenamed(FileRenameEvent fe) {
                this.fileChange();
            }

            public void fileDataCreated(FileEvent fe) {
                this.fileChange();
            }

            public void fileDeleted(FileEvent fe) {
                this.fileChange();
            }

            private void fileChange() {
                ImportantFilesChildFactory.this.refreshNodes();
            }
        }
    }

    private static class ImportantFilesRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        final ImportantFilesChildFactory childFactory;

        public ImportantFilesRootNode(PhpProject project, ImportantFilesChildFactory childFactory) {
            super(Children.create((ChildFactory)childFactory, (boolean)true));
            this.childFactory = childFactory;
            ProjectPropertiesSupport.addWeakPropertyChangeListener(project, this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ImportantFilesNodeFactory.class, (String)"LBL_ImportantFiles");
        }

        public Image getIcon(int type) {
            return this.getIcon(true);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(false);
        }

        private Image getIcon(boolean opened) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/config-badge.gif", (boolean)false);
            return ImageUtilities.mergeImages((Image)UiUtils.getTreeFolderIcon((boolean)opened), (Image)badge, (int)8, (int)8);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("frameworks".equals(evt.getPropertyName())) {
                this.childFactory.refresh();
            }
        }
    }

    private static class ImportantFilesChildrenList
    implements NodeList<Node>,
    PropertyChangeListener {
        private final PhpProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public ImportantFilesChildrenList(PhpProject project) {
            this.project = project;
        }

        public void addNotify() {
            ProjectPropertiesSupport.addPropertyChangeListener(this.project, this);
        }

        public void removeNotify() {
            ProjectPropertiesSupport.removePropertyChangeListener(this.project, this);
        }

        public List<Node> keys() {
            if (this.project.hasConfigFiles()) {
                return Collections.singletonList(new Nodes.DummyNode((Node)new ImportantFilesRootNode(this.project, new ImportantFilesChildFactory(this.project))));
            }
            return Collections.emptyList();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(Node key) {
            return key;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("frameworks".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportantFilesChildrenList.this.fireChange();
                    }
                });
            }
        }

        void fireChange() {
            this.changeSupport.fireChange();
        }
    }
}

