/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandSupport;
import org.netbeans.modules.php.symfony.ui.options.SymfonyOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class SymfonyScript
extends PhpProgram {
    public static final String SCRIPT_NAME = "symfony";
    public static final String SCRIPT_NAME_LONG = "symfony" + FileUtils.getScriptExtension((boolean)true);
    public static final String OPTIONS_SUB_PATH = "Symfony";
    public static final String CMD_INIT_PROJECT = "generate:project";
    public static final String CMD_CLEAR_CACHE = "cache:clear";
    public static final String CMD_INIT_APP = "generate:app";

    SymfonyScript(String command) {
        super(command);
    }

    public static SymfonyScript getDefault() throws PhpProgram.InvalidPhpProgramException {
        String symfony = SymfonyOptions.getInstance().getSymfony();
        String error = SymfonyScript.validate(symfony);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new SymfonyScript(symfony);
    }

    public static SymfonyScript forPhpModule(PhpModule phpModule, boolean warn) throws PhpProgram.InvalidPhpProgramException {
        String symfony = new File(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()), SCRIPT_NAME).getAbsolutePath();
        String error = SymfonyScript.validate(symfony);
        if (error != null) {
            if (warn) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SymfonyScript.class, (String)"MSG_InvalidProjectSymfonyScript", (Object)error), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return SymfonyScript.getDefault();
        }
        return new SymfonyScript(symfony);
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/" + SymfonyScript.getOptionsSubPath();
    }

    public static String getOptionsSubPath() {
        return OPTIONS_SUB_PATH;
    }

    public String validate() {
        String error = FileUtils.validateFile((String)this.getProgram(), (boolean)false);
        if (error == null) {
            return null;
        }
        return NbBundle.getMessage(SymfonyScript.class, (String)"LBL_SymfonyScriptPrefix", (Object)error);
    }

    public static String validate(String command) {
        return new SymfonyScript(command).validate();
    }

    public boolean initProject(PhpModule phpModule, String[] params) {
        String projectName = phpModule.getDisplayName();
        String[] cmdParams = SymfonyScript.mergeArrays({projectName}, params);
        SymfonyCommandSupport commandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder processBuilder = commandSupport.createSilentCommand(CMD_INIT_PROJECT, cmdParams);
        if (processBuilder == null) {
            return false;
        }
        ExecutionDescriptor executionDescriptor = commandSupport.getDescriptor();
        SymfonyScript.runService(processBuilder, executionDescriptor, commandSupport.getOutputTitle(CMD_INIT_PROJECT, cmdParams), false);
        return SymfonyPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    public void initApp(PhpModule phpModule, String app, String[] params) {
        assert (StringUtils.hasText((String)app));
        assert (params != null);
        String[] cmdParams = SymfonyScript.mergeArrays(params, {app});
        SymfonyCommandSupport commandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder processBuilder = commandSupport.createCommand(CMD_INIT_APP, cmdParams);
        assert (processBuilder != null);
        ExecutionDescriptor executionDescriptor = commandSupport.getDescriptor();
        SymfonyScript.runService(processBuilder, executionDescriptor, commandSupport.getOutputTitle(CMD_INIT_APP, cmdParams), true);
    }

    public static String getHelp(PhpModule phpModule, FrameworkCommand command) {
        assert (phpModule != null);
        assert (command != null);
        SymfonyCommandSupport commandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder processBuilder = commandSupport.createSilentCommand("help", command.getCommands());
        assert (processBuilder != null);
        final HelpLineProcessor lineProcessor = new HelpLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)InputProcessors.bridge((LineProcessor)lineProcessor));
            }
        });
        SymfonyScript.runService(processBuilder, executionDescriptor, "getting help for: " + command.getPreview(), true);
        return lineProcessor.getHelp();
    }

    static <T> T[] mergeArrays(T[] ... arrays) {
        LinkedList<T> list = new LinkedList<T>();
        for (T[] array : arrays) {
            list.addAll(Arrays.asList(array));
        }
        Object[] merged = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), list.size());
        return list.toArray(merged);
    }

    private static void runService(ExternalProcessBuilder processBuilder, ExecutionDescriptor executionDescriptor, String title, boolean warnUser) {
        try {
            SymfonyScript.executeAndWait((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)title);
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            if (warnUser) {
                UiUtils.processExecutionException((ExecutionException)ex, (String)SymfonyScript.getOptionsSubPath());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    static class HelpLineProcessor
    implements LineProcessor {
        private final StringBuilder buffer = new StringBuilder(500);

        HelpLineProcessor() {
        }

        public void processLine(String line) {
            this.buffer.append(line);
            this.buffer.append("\n");
        }

        public void reset() {
        }

        public void close() {
        }

        public String getHelp() {
            return this.buffer.toString().trim() + "\n";
        }
    }
}

