/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class J2eePlatform
implements Lookup.Provider {
    public static final String LIBRARY_TYPE = "serverlibrary";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_CLASSPATH = "classpath";
    public static final String PROP_PLATFORM_ROOTS = "platformRoots";
    public static final String TOOL_APP_CLIENT_RUNTIME = "appClientRuntime";
    public static final String TOOL_JSR109 = "jsr109";
    public static final String TOOL_WSCOMPILE = "wscompile";
    public static final String TOOL_EMBEDDABLE_EJB = "embeddableejb";
    public static final String TOOL_WSIMPORT = "wsimport";
    public static final String TOOL_WSGEN = "wsgen";
    public static final String TOOL_WSIT = "wsit";
    public static final String TOOL_JWSDP = "jwsdp";
    public static final String TOOL_KEYSTORE = "keystore";
    public static final String TOOL_KEYSTORE_CLIENT = "keystoreClient";
    public static final String TOOL_TRUSTSTORE = "truststore";
    public static final String TOOL_TRUSTSTORE_CLIENT = "truststoreClient";
    public static final String TOOL_PROP_MAIN_CLASS = "main.class";
    public static final String TOOL_PROP_MAIN_CLASS_ARGS = "main.class.args";
    public static final String TOOL_PROP_JVM_OPTS = "jvm.opts";
    public static final String TOOL_PROP_CLIENT_JAR_LOCATION = "client.jar.location";
    public static final String CLIENT_PROP_DIST_ARCHIVE = "client.dist.archive";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/Servers.png";
    private static final Logger LOGGER = Logger.getLogger(J2eePlatform.class.getName());
    private final J2eePlatformImpl impl;
    private File[] classpathCache;
    private String currentClasspath;
    private final ServerInstance serverInstance;
    private PropertyChangeListener librariesChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("content")) {
                J2eePlatform.access$002(J2eePlatform.this, null);
                String newClassPath = J2eePlatform.this.getClasspathAsString();
                if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(newClassPath)) {
                    J2eePlatform.this.currentClasspath = newClassPath;
                    J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                }
            }
        }
    };

    private J2eePlatform(ServerInstance aServerInstance, J2eePlatformImpl aImpl) {
        assert (aServerInstance != null);
        this.impl = aImpl;
        this.serverInstance = aServerInstance;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("libraries".equals(evt.getPropertyName())) {
                    LibraryImplementation[] libs = J2eePlatform.this.getLibraries();
                    for (int i = 0; i < libs.length; ++i) {
                        libs[i].removePropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                        libs[i].addPropertyChangeListener(J2eePlatform.this.librariesChangeListener);
                    }
                    J2eePlatform.access$002(J2eePlatform.this, null);
                    String newClassPath = J2eePlatform.this.getClasspathAsString();
                    if (J2eePlatform.this.currentClasspath == null || !J2eePlatform.this.currentClasspath.equals(newClassPath)) {
                        J2eePlatform.this.currentClasspath = newClassPath;
                        J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                    }
                } else if ("serverLibraries".equals(evt.getPropertyName())) {
                    J2eePlatform.this.impl.firePropertyChange(J2eePlatform.PROP_CLASSPATH, null, null);
                }
            }
        });
        LibraryImplementation[] libs = this.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            libs[i].addPropertyChangeListener(this.librariesChangeListener);
        }
        this.currentClasspath = this.getClasspathAsString();
    }

    static J2eePlatform create(ServerInstance serInst) {
        J2eePlatformImpl platformImpl;
        J2eePlatform result = serInst.getJ2eePlatform();
        if (result == null && (platformImpl = serInst.getJ2eePlatformImpl()) != null) {
            result = new J2eePlatform(serInst, platformImpl);
            serInst.setJ2eePlatform(result);
        }
        return result;
    }

    @NonNull
    public File[] getClasspathEntries() {
        if (this.classpathCache == null) {
            List<File> classpath = this.getClasspath(this.impl.getLibraries());
            this.classpathCache = classpath.toArray(new File[classpath.size()]);
        }
        return this.classpathCache;
    }

    @NonNull
    public File[] getClasspathEntries(Set<ServerLibraryDependency> libraries) {
        List<File> classpath = this.getClasspath(this.impl.getLibraries(libraries));
        return classpath.toArray(new File[classpath.size()]);
    }

    private List<File> getClasspath(LibraryImplementation[] libraries) {
        ArrayList<File> classpath = new ArrayList<File>();
        for (int i = 0; i < libraries.length; ++i) {
            List classpathList = libraries[i].getContent(PROP_CLASSPATH);
            for (URL url : classpathList) {
                File f;
                FileObject fo;
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                if ((fo = URLMapper.findFileObject((URL)url)) == null || (f = FileUtil.toFile((FileObject)fo)) == null) continue;
                classpath.add(f);
            }
        }
        return classpath;
    }

    public File[] getToolClasspathEntries(String toolName) {
        return this.impl.getToolClasspathEntries(toolName);
    }

    public String getToolProperty(String toolName, String propertyName) {
        return this.impl.getToolProperty(toolName, propertyName);
    }

    public boolean isToolSupported(String toolName) {
        return this.impl.isToolSupported(toolName);
    }

    LibraryImplementation[] getLibraries() {
        return this.impl.getLibraries();
    }

    public String getDisplayName() {
        return this.serverInstance.getDisplayName();
    }

    public Image getIcon() {
        Image result = this.impl.getIcon();
        if (result == null) {
            result = ImageUtilities.loadImage((String)DEFAULT_ICON);
        }
        return result;
    }

    public File[] getPlatformRoots() {
        return this.impl.getPlatformRoots();
    }

    @CheckForNull
    public File getServerHome() {
        if (this.impl instanceof J2eePlatformImpl2) {
            return ((J2eePlatformImpl2)this.impl).getServerHome();
        }
        return null;
    }

    @CheckForNull
    public File getDomainHome() {
        if (this.impl instanceof J2eePlatformImpl2) {
            return ((J2eePlatformImpl2)this.impl).getDomainHome();
        }
        return null;
    }

    @CheckForNull
    public File getMiddlewareHome() {
        if (this.impl instanceof J2eePlatformImpl2) {
            return ((J2eePlatformImpl2)this.impl).getMiddlewareHome();
        }
        return null;
    }

    public Set getSupportedSpecVersions() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedSpecVersions", new Exception());
        }
        return this.convertProfilesToKnownSpecVersions(this.getSupportedProfiles());
    }

    public Set<String> getSupportedSpecVersions(Object moduleType) {
        J2eeModule.Type type;
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedSpecVersions", new Exception());
        }
        if ((type = J2eeModule.Type.fromJsrType(moduleType)) != null) {
            return this.convertProfilesToKnownSpecVersions(this.getSupportedProfiles(type));
        }
        return Collections.emptySet();
    }

    @NonNull
    public Set<Profile> getSupportedProfiles() {
        return this.impl.getSupportedProfiles();
    }

    @NonNull
    public Set<Profile> getSupportedProfiles(@NonNull J2eeModule.Type moduleType) {
        return this.impl.getSupportedProfiles(moduleType);
    }

    public Set getSupportedModuleTypes() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            LOGGER.log(Level.INFO, "Call to deprecated method " + J2eePlatform.class.getName() + "getSupportedModuleTypes", new Exception());
        }
        HashSet<ModuleType> ret = new HashSet<ModuleType>();
        for (J2eeModule.Type type : this.getSupportedTypes()) {
            ModuleType obj = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
            if (obj == null) continue;
            ret.add(obj);
        }
        return ret;
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        return this.impl.getSupportedTypes();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.impl.getSupportedJavaPlatformVersions();
    }

    public boolean supportsProfiling() {
        return true;
    }

    public JavaPlatform getJavaPlatform() {
        return this.impl.getJavaPlatform();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.impl.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.impl.removePropertyChangeListener(l);
    }

    public String toString() {
        return this.impl.getDisplayName() + " [" + this.getClasspathAsString() + "]";
    }

    public Library createLibrary(File location, String libraryName) throws IOException {
        Parameters.notNull((CharSequence)"location", (Object)location);
        File parent = location.getAbsoluteFile().getParentFile();
        if (parent == null) {
            throw new IOException("Wrong library location " + location);
        }
        FileObject baseFolder = FileUtil.toFileObject((File)parent);
        if (baseFolder == null) {
            baseFolder = FileUtil.createFolder((File)parent);
        }
        LibraryManager manager = LibraryManager.forLocation((URL)location.toURI().toURL());
        HashMap<String, ArrayList<URI>> content = new HashMap<String, ArrayList<URI>>();
        String folderName = this.getFolderName(baseFolder, libraryName);
        FileObject jarFolder = FileUtil.createFolder((FileObject)baseFolder, (String)folderName);
        HashMap<String, Integer> usedNames = new HashMap<String, Integer>();
        HashMap<FileObject, String> copied = new HashMap<FileObject, String>();
        ArrayList<URI> contentItem = new ArrayList<URI>();
        content.put(PROP_CLASSPATH, contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getVolumeContent(this, PROP_CLASSPATH), contentItem);
        contentItem = new ArrayList();
        content.put("embedabbleejb", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_EMBEDDABLE_EJB), contentItem);
        contentItem = new ArrayList();
        content.put(TOOL_WSCOMPILE, contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_WSCOMPILE), contentItem);
        contentItem = new ArrayList();
        content.put("wsgenerate", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_WSGEN), contentItem);
        contentItem = new ArrayList();
        content.put(TOOL_WSIMPORT, contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_WSIMPORT), contentItem);
        contentItem = new ArrayList();
        content.put("wsinterop", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_WSIT), contentItem);
        contentItem = new ArrayList();
        content.put("wsjwsdp", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getToolClasspathEntries(TOOL_JWSDP), contentItem);
        contentItem = new ArrayList();
        content.put("javadoc", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getVolumeContent(this, "javadoc"), contentItem);
        contentItem = new ArrayList();
        content.put("src", contentItem);
        this.copyFiles(copied, usedNames, jarFolder, folderName, this.getVolumeContent(this, "src"), contentItem);
        return manager.createURILibrary(LIBRARY_TYPE, libraryName, content);
    }

    public Lookup getLookup() {
        return this.impl.getLookup();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        J2eePlatform other = (J2eePlatform)obj;
        return this.serverInstance.getUrl() == other.serverInstance.getUrl() || this.serverInstance.getUrl() != null && this.serverInstance.getUrl().equals(other.serverInstance.getUrl());
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.serverInstance.getUrl() != null ? this.serverInstance.getUrl().hashCode() : 0);
        return hash;
    }

    @NonNull
    private Set<String> convertProfilesToKnownSpecVersions(Iterable<Profile> profiles) {
        HashSet<String> ret = new HashSet<String>();
        for (Profile profile : profiles) {
            String str = profile.toPropertiesString();
            if (!"1.3".equals(str) && !"1.4".equals(str) && !"1.5".equals(str)) continue;
            ret.add(str);
        }
        return ret;
    }

    private FileObject[] getVolumeContent(J2eePlatform platform, String volumeType) {
        LibraryImplementation[] libraries = platform.getLibraries();
        ArrayList<FileObject> ret = new ArrayList<FileObject>();
        for (int i = 0; i < libraries.length; ++i) {
            for (URL url : libraries[i].getContent(volumeType)) {
                FileObject fo;
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                if ((fo = URLMapper.findFileObject((URL)url)) == null) continue;
                ret.add(fo);
            }
        }
        return ret.toArray(new FileObject[ret.size()]);
    }

    private void copyFiles(Map<FileObject, String> copied, Map<String, Integer> usedNames, FileObject jarFolder, String folderName, File[] files, List<URI> content) throws IOException {
        if (files == null) {
            return;
        }
        ArrayList<FileObject> fileObjects = new ArrayList<FileObject>();
        for (File jarFile : files) {
            File normalized = FileUtil.normalizeFile((File)jarFile);
            FileObject jarObject = FileUtil.toFileObject((File)normalized);
            if (jarObject != null) {
                fileObjects.add(jarObject);
                continue;
            }
            LOGGER.log(Level.INFO, "Could not find " + jarFile);
        }
        this.copyFiles(copied, usedNames, jarFolder, folderName, fileObjects.toArray(new FileObject[fileObjects.size()]), content);
    }

    private void copyFiles(Map<FileObject, String> copied, Map<String, Integer> usedNames, FileObject jarFolder, String folderName, FileObject[] files, List<URI> content) throws IOException {
        if (files == null) {
            return;
        }
        for (FileObject jarObject : files) {
            if (!copied.containsKey(jarObject)) {
                String name = jarObject.getName() + this.getEntrySuffix(jarObject.getNameExt(), usedNames);
                if (jarObject.isFolder()) {
                    FileObject folder = FileUtil.createFolder((FileObject)jarFolder, (String)name);
                    this.copyFolder(jarObject, folder);
                } else {
                    FileUtil.copyFile((FileObject)jarObject, (FileObject)jarFolder, (String)name, (String)jarObject.getExt());
                }
                copied.put(jarObject, jarObject.getNameExt().replace(jarObject.getName(), name));
            }
            FileObject fresh = jarFolder.getFileObject(copied.get(jarObject));
            URI u = LibrariesSupport.convertFilePathToURI((String)(folderName + File.separator + copied.get(jarObject)));
            if (FileUtil.isArchiveFile((FileObject)fresh)) {
                u = LibrariesSupport.getArchiveRoot((URI)u);
            }
            if (content.contains(u)) continue;
            content.add(u);
        }
    }

    private void copyFolder(FileObject source, FileObject dest) throws IOException {
        assert (source.isFolder()) : "Source is not a folder";
        assert (dest.isFolder()) : "Source is not a folder";
        for (FileObject child : source.getChildren()) {
            if (child.isFolder()) {
                FileObject created = FileUtil.createFolder((FileObject)dest, (String)child.getNameExt());
                this.copyFolder(child, created);
                continue;
            }
            FileUtil.copyFile((FileObject)child, (FileObject)dest, (String)child.getName(), (String)child.getExt());
        }
    }

    private String getEntrySuffix(String realName, Map<String, Integer> usages) {
        Integer value = usages.get(realName);
        value = value == null ? Integer.valueOf(0) : Integer.valueOf(value + 1);
        usages.put(realName, value);
        if (value == 0) {
            return "";
        }
        return "-" + value.toString();
    }

    private String getFolderName(FileObject baseFolder, String libraryName) {
        String baseName;
        int suffix = 2;
        String name = baseName = libraryName;
        while (baseFolder.getFileObject(name) != null) {
            name = baseName + "-" + suffix;
            ++suffix;
        }
        return name;
    }

    private String getClasspathAsString() {
        File[] classpathEntr = this.getClasspathEntries();
        StringBuilder classpath = new StringBuilder();
        String PATH_SEPARATOR = System.getProperty("path.separator");
        for (int i = 0; i < classpathEntr.length; ++i) {
            classpath.append(classpathEntr[i].getAbsolutePath());
            if (i + 1 >= classpathEntr.length) continue;
            classpath.append(PATH_SEPARATOR);
        }
        return classpath.toString();
    }

    static /* synthetic */ File[] access$002(J2eePlatform x0, File[] x1) {
        x0.classpathCache = x1;
        return x1;
    }
}

