/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;

public final class ServerInstance {
    private final String serverInstanceId;

    ServerInstance(String serverInstanceId) {
        assert (serverInstanceId != null) : "Server instance id is null";
        this.serverInstanceId = serverInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() throws InstanceRemovedException {
        ServerRegistry registry;
        ServerRegistry serverRegistry = registry = ServerRegistry.getInstance();
        synchronized (serverRegistry) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(registry);
            return inst.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerDisplayName() throws InstanceRemovedException {
        ServerRegistry registry;
        ServerRegistry serverRegistry = registry = ServerRegistry.getInstance();
        synchronized (serverRegistry) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(registry);
            return inst.getServer().getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerID() throws InstanceRemovedException {
        ServerRegistry registry;
        ServerRegistry serverRegistry = registry = ServerRegistry.getInstance();
        synchronized (serverRegistry) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(registry);
            return inst.getServer().getShortName();
        }
    }

    public boolean isRunning() throws InstanceRemovedException {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(ServerRegistry.getInstance());
        return inst.isReallyRunning() || inst.isSuspended();
    }

    public J2eePlatform getJ2eePlatform() throws InstanceRemovedException {
        return J2eePlatform.create(this.getInstanceFromRegistry(ServerRegistry.getInstance()));
    }

    public boolean isDeployOnSaveSupported(J2eeModule module) throws InstanceRemovedException {
        return this.isDeployOnSaveSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeployOnSaveSupported() throws InstanceRemovedException {
        ServerRegistry registry;
        ServerRegistry serverRegistry = registry = ServerRegistry.getInstance();
        synchronized (serverRegistry) {
            IncrementalDeployment incremental;
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(registry);
            try {
                incremental = inst.getServer().getOptionalFactory().getIncrementalDeployment(inst.getDisconnectedDeploymentManager());
            }
            catch (DeploymentManagerCreationException ex) {
                throw new RuntimeException(ex);
            }
            return incremental != null && incremental.isDeployOnSaveSupported();
        }
    }

    public Descriptor getDescriptor() throws InstanceRemovedException {
        if (this.getInstanceFromRegistry(ServerRegistry.getInstance()).getServerInstanceDescriptor() != null) {
            return new Descriptor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryManager getLibraryManager() throws InstanceRemovedException {
        ServerRegistry registry;
        ServerRegistry serverRegistry = registry = ServerRegistry.getInstance();
        synchronized (serverRegistry) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = this.getInstanceFromRegistry(registry);
            if (inst.isServerLibraryManagementSupported()) {
                return new LibraryManager();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.netbeans.modules.j2ee.deployment.impl.ServerInstance getInstanceFromRegistry(ServerRegistry registry) throws InstanceRemovedException {
        ServerRegistry serverRegistry = registry;
        synchronized (serverRegistry) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance inst = registry.getServerInstance(this.serverInstanceId);
            if (inst == null) {
                throw new InstanceRemovedException(this.serverInstanceId);
            }
            return inst;
        }
    }

    public final class LibraryManager {
        @NonNull
        public Set<ServerLibrary> getDeployableLibraries() throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getDeployableLibraries();
        }

        @NonNull
        public Set<ServerLibrary> getDeployedLibraries() throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getDeployedLibraries();
        }

        @NonNull
        public Set<ServerLibraryDependency> getMissingDependencies(@NonNull Set<ServerLibraryDependency> libraries) throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getMissingDependencies(libraries);
        }

        @NonNull
        public Set<ServerLibraryDependency> getDeployableDependencies(@NonNull Set<ServerLibraryDependency> libraries) throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getDeployableDependencies(libraries);
        }

        public void deployLibraries(@NonNull Set<ServerLibraryDependency> libraries) throws InstanceRemovedException, ConfigurationException {
            ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).deployLibraries(libraries);
        }
    }

    public final class Descriptor {
        public int getHttpPort() throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getServerInstanceDescriptor().getHttpPort();
        }

        public String getHostname() throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getServerInstanceDescriptor().getHostname();
        }

        public boolean isLocal() throws InstanceRemovedException {
            return ServerInstance.this.getInstanceFromRegistry(ServerRegistry.getInstance()).getServerInstanceDescriptor().isLocal();
        }
    }
}

