/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.preview.SequenceTimeSpinner;
import org.netbeans.modules.vmd.game.view.ImagePreviewComponent;

public class SequencePreviewPanelSidebar
extends JPanel
implements SequenceListener,
ComponentListener,
PropertyChangeListener,
ActionListener {
    public static final boolean DEBUG = false;
    private boolean isPlaying;
    private boolean isPlayingForward = true;
    private int sequenceIndex;
    private Sequence sequence;
    private Timer timer;
    private ImagePreviewComponent imagePreview = new ImagePreviewComponent(false, true, false);
    private JButton buttonDirection;
    private JButton buttonPause;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JLabel labelName;
    private JPanel panelSequenceAnimatedPreview;
    public JPanel spinnerPanel;

    public SequencePreviewPanelSidebar(Sequence sequence) {
        this.initComponents();
        this.addComponentListener(this);
        this.setSequence(sequence);
    }

    private Dimension getFrameSize() {
        if (this.sequence == null) {
            return new Dimension(10, 10);
        }
        return this.sequence.getFrameSize();
    }

    public void setImportant(boolean isImportant) {
        if (isImportant) {
            this.labelName.setFont(this.labelName.getFont().deriveFont(1));
        } else {
            this.labelName.setFont(this.labelName.getFont().deriveFont(0));
        }
    }

    public void setSequence(Sequence sequence) {
        if (this.sequence != null) {
            this.sequence.removeSequenceListener(this);
            this.sequence.removePropertyChangeListener(this);
            this.timer.cancel();
            int max = sequence.getFrameCount() - 1;
        }
        this.sequence = sequence;
        this.labelName.setText(this.sequence.getName());
        this.spinnerPanel.add((Component)new SequenceTimeSpinner(this.sequence), "Center");
        this.timer = new Timer();
        StaticTile frame = this.sequence.getFrame(0);
        this.imagePreview.setPreviewable(frame);
        this.sequence.addSequenceListener(this);
        this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
        this.sequence.addPropertyChangeListener(this);
    }

    public void requestPreviewFrame(int frameIndex) {
        if (!this.isPlaying && this.sequence.getFrame(frameIndex) != null) {
            this.imagePreview.setPreviewable(this.sequence.getFrame(frameIndex));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.buttonPause = new JButton();
        this.buttonDirection = new JButton();
        this.panelSequenceAnimatedPreview = new JPanel();
        this.jPanel2 = new JPanel();
        this.labelName = new JLabel();
        this.spinnerPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.buttonPause.setText(">");
        this.buttonPause.addActionListener(this);
        this.buttonDirection.setText("<>");
        this.buttonDirection.addActionListener(this);
        this.panelSequenceAnimatedPreview.setBackground(new Color(255, 255, 255));
        this.panelSequenceAnimatedPreview.setMinimumSize(this.getFrameSize());
        this.panelSequenceAnimatedPreview.add(this.imagePreview);
        this.panelSequenceAnimatedPreview.setLayout(new BorderLayout(10, 10));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonDirection, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPause, -1, 69, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.panelSequenceAnimatedPreview, -1, 78, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelSequenceAnimatedPreview, -1, 56, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.buttonPause).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDirection))).addContainerGap()));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.labelName.setText("<None>");
        this.spinnerPanel.setBackground(new Color(255, 255, 255));
        this.spinnerPanel.setLayout(new BorderLayout());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.labelName, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerPanel, -2, 74, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelName).addComponent(this.spinnerPanel, -1, 15, Short.MAX_VALUE)).addGap(12, 12, 12)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void sequenceChanged() {
        this.setSequence(this.sequence);
    }

    private void switchPlayDirection() {
        this.isPlayingForward = !this.isPlayingForward;
        this.setPlaying(true);
    }

    private void setPlaying(boolean play) {
        if (play) {
            if (this.isPlayingForward) {
                this.buttonPause.setText(">||");
            } else {
                this.buttonPause.setText("||<");
            }
        } else if (this.isPlayingForward) {
            this.buttonPause.setText(">");
        } else {
            this.buttonPause.setText("<");
        }
        this.isPlaying = play;
    }

    private void incrementSequenceIndex() {
        int index = this.sequenceIndex + 1;
        this.sequenceIndex = index >= this.sequence.getFrameCount() ? 0 : index;
    }

    private void decrementSequenceIndex() {
        int index = this.sequenceIndex - 1;
        this.sequenceIndex = index < 0 ? this.sequence.getFrameCount() - 1 : index;
    }

    private void currentFrameChanged() {
    }

    private void setCurrentFrameIndex(int frameIndex) {
        StaticTile frame = null;
        do {
            try {
                frame = this.sequence.getFrame(frameIndex);
            }
            catch (Exception e) {
                --frameIndex;
            }
        } while (frame == null);
        this.sequenceIndex = frameIndex;
        this.imagePreview.setPreviewable(frame);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.sequence) {
            if (evt.getPropertyName().equals("sequence.prop.frames.ms")) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new AnimationTimerTask(), 0L, (long)this.sequence.getFrameMs());
            }
            if (evt.getPropertyName().equals("sequence.prop.name")) {
                this.labelName.setText(this.sequence.getName());
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDirection) {
            this.switchPlayDirection();
        } else {
            this.setPlaying(!this.isPlaying);
        }
    }

    @Override
    public void frameAdded(Sequence sequence, int index) {
        this.sequenceChanged();
    }

    @Override
    public void frameRemoved(Sequence sequence, int index) {
        this.sequenceChanged();
    }

    @Override
    public void framesChanged(Sequence sequence) {
        this.sequenceChanged();
    }

    @Override
    public void frameModified(Sequence sequence, int index) {
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        @Override
        public void run() {
            if (!SequencePreviewPanelSidebar.this.isPlaying || !SequencePreviewPanelSidebar.this.isShowing()) {
                return;
            }
            SequencePreviewPanelSidebar.this.setCurrentFrameIndex(SequencePreviewPanelSidebar.this.sequenceIndex);
            SequencePreviewPanelSidebar.this.currentFrameChanged();
            if (SequencePreviewPanelSidebar.this.isPlayingForward) {
                SequencePreviewPanelSidebar.this.incrementSequenceIndex();
            } else {
                SequencePreviewPanelSidebar.this.decrementSequenceIndex();
            }
        }
    }
}

