/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.util.NbBundle;

public class GameDesignPreviewComponent
extends JPanel
implements MouseListener,
PropertyChangeListener {
    private static final Color COLOR_HILITE = ColorConstants.COLOR_OUTLINE_HILITE;
    private static final Color COLOR_PLAIN = ColorConstants.COLOR_OUTLINE_PLAIN;
    private static final Color COLOR_BACKGROUND = ColorConstants.COLOR_EDITOR_PANEL;
    private GlobalRepository gameDesign;
    private Editable editable;
    private JLabel labelName;
    private JPanel panelPreview;

    public GameDesignPreviewComponent(GlobalRepository gameDesign, JComponent preview, String name, Editable editable) {
        this.gameDesign = gameDesign;
        this.editable = editable;
        this.addMouseListener(this);
        this.initComponents();
        this.labelName.setText(name);
        this.panelPreview.add(preview);
        editable.addPropertyChangeListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.editable.getName();
    }

    private void initComponents() {
        this.panelPreview = new JPanel();
        this.labelName = new JLabel();
        this.setBackground(COLOR_BACKGROUND);
        this.panelPreview.setBackground(new Color(255, 255, 255));
        this.panelPreview.setBorder(new LineBorder(new Color(163, 184, 215), 1, true));
        this.panelPreview.setLayout(new BorderLayout());
        this.labelName.setBackground(COLOR_BACKGROUND);
        this.labelName.setForeground(new Color(100, 123, 156));
        this.labelName.setHorizontalAlignment(0);
        this.labelName.setText(NbBundle.getMessage(GameDesignPreviewComponent.class, (String)"GameDesignPreviewComponent.labelName.text"));
        this.labelName.setBorder(new LineBorder(new Color(163, 184, 215), 1, true));
        this.labelName.setInheritsPopupMenu(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelPreview, GroupLayout.Alignment.LEADING, -2, 101, -2).addComponent(this.labelName, GroupLayout.Alignment.LEADING, -2, 101, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelPreview, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelName, -2, 19, -2).addContainerGap()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.gameDesign.getMainView().requestEditing(this.editable);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        }
    }

    private void handlePopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        List<Action> actions = this.editable.getActions();
        for (Action action : actions) {
            menu.add(action);
        }
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.panelPreview.setBorder(new LineBorder(COLOR_HILITE, 1, true));
        this.labelName.setBorder(new LineBorder(COLOR_HILITE, 1, true));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.panelPreview.setBorder(new LineBorder(COLOR_PLAIN, 1, true));
        this.labelName.setBorder(new LineBorder(COLOR_PLAIN, 1, true));
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(125, 150);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.panelPreview.repaint();
        if (evt.getPropertyName().equals("editable.prop.name")) {
            this.labelName.setText((String)evt.getNewValue());
        }
    }
}

