/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterMappingsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterPanelFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FiltersMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    public static final int FILTERS_ELEMENT_INDEX = 3;
    private static final Logger LOG = Logger.getLogger(FiltersMultiViewElement.class.getName());
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private FilterPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String FILTER_MV_ID = "dd_multiviewFilters";
    private static final String HELP_ID_PREFIX = "dd_multiview_filters_";

    public FiltersMultiViewElement(Lookup context) {
        super((XmlMultiViewDataObject)context.lookup(DDDataObject.class));
        this.dObj = (DDDataObject)context.lookup(DDDataObject.class);
        this.index = 3;
        this.comp = new ToolBarDesignEditor();
        this.factory = new FilterPanelFactory(this.comp, this.dObj);
        this.addAction = new AddAction(this.dObj, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_addFilter"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FiltersMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new FiltersView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            FiltersView filtersView = (FiltersView)this.view;
            Node initialNode = filtersView.getFiltersNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            filtersView.selectNode(initialNode);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!this.dObj.isChangedFromUI() && (name = evt.getPropertyName()).indexOf("Filter") > 0) {
            if (FILTER_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TXT_removeFilterConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
                Filter filter = (Filter)sectionPanel.getKey();
                FiltersMultiViewElement.this.dObj.modelUpdatedFromUI();
                FiltersMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    Stack deletedRows = DDUtils.removeFilterMappings(FiltersMultiViewElement.this.webApp, filter.getFilterName());
                    FiltersMultiViewElement.this.webApp.removeFilter(filter);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                    SectionInnerPanel mappingsInnerPanel = ((FiltersView)sectionPanel.getSectionView()).getFilterMappingSectionPanel().getInnerPanel();
                    if (mappingsInnerPanel != null) {
                        while (!deletedRows.empty()) {
                            ((FilterMappingsPanel)mappingsInnerPanel).removeRow((Integer)deletedRows.pop());
                        }
                    }
                }
                finally {
                    FiltersMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_addFilter_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            String[] labels = new String[]{NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_filterName"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_filterClass"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_description")};
            String[] a11y_desc = new String[]{NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterName"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterClass"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterDescription")};
            boolean[] buttons = new boolean[]{false, true, false};
            SimpleDialogPanel.DialogDescriptor descriptor = new SimpleDialogPanel.DialogDescriptor(labels, true);
            descriptor.setButtons(buttons);
            descriptor.setA11yDesc(a11y_desc);
            descriptor.setTextField(new boolean[]{true, true, false});
            final SimpleDialogPanel dialogPanel = new SimpleDialogPanel(descriptor);
            dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_add_filter"));
            dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_add_err_page"));
            dialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = DDUtils.getJavaSourceGroups(FiltersMultiViewElement.this.dObj);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = DDUtils.getResourcePath(groups, fo);
                            dialogPanel.getTextComponents()[1].setText(className);
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "ignored exception", ex);
                    }
                }
            });
            EditDialog dialog = new EditDialog((JPanel)dialogPanel, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_Filter"), true){

                protected String validate() {
                    String[] values = dialogPanel.getValues();
                    String filterName = values[0].trim();
                    String filterClass = values[1].trim();
                    return SectionValidator.validateNewFilter(FiltersMultiViewElement.this.dObj.getWebApp(), filterName, filterClass);
                }
            };
            dialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                FiltersMultiViewElement.this.dObj.modelUpdatedFromUI();
                FiltersMultiViewElement.this.dObj.setChangedFromUI(true);
                String[] values = dialogPanel.getValues();
                try {
                    Filter filter = (Filter)FiltersMultiViewElement.this.webApp.createBean("Filter");
                    filter.setFilterName(values[0]);
                    filter.setFilterClass(values[1]);
                    String desc = values[2];
                    if (desc.length() > 0) {
                        filter.setDescription(desc);
                    }
                    FiltersMultiViewElement.this.webApp.addFilter(filter);
                    FiltersView view = (FiltersView)FiltersMultiViewElement.this.comp.getContentView();
                    FilterNode node = new FilterNode(view, FiltersMultiViewElement.this.webApp, filter);
                    view.getFiltersNode().getChildren().add(new Node[]{node});
                    SectionPanel pan = new SectionPanel((SectionView)view, (Node)node, view.getFilterTitle(filter), (Object)filter);
                    pan.setHeaderActions(new Action[]{FiltersMultiViewElement.this.removeAction});
                    view.getFiltersContainer().addSection((NodeSectionPanel)pan, true);
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.FINE, "ignored exception", ex);
                }
                finally {
                    FiltersMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class FilterNode
    extends AbstractNode {
        FilterNode(SectionView view, WebApp webApp, Filter filter) {
            super(Children.LEAF);
            this.setDisplayName(filter.getFilterName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_filters_filterNode");
        }
    }

    private class FilterMappingsNode
    extends AbstractNode {
        FilterMappingsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_FilterMappings"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/mappingsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_filters_filterMappingsNode");
        }
    }

    class FiltersView
    extends SectionView {
        private SectionContainer filtersCont;
        private Node filtersNode;
        private Node filterMappingsNode;
        private SectionPanel filterMappingSectionPanel;

        FiltersView(WebApp webApp) {
            super((InnerPanelFactory)FiltersMultiViewElement.this.factory);
            Filter[] filters = webApp.getFilter();
            Node[] nodes = new Node[filters.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = new FilterNode(this, webApp, filters[i]);
            }
            ch.add(nodes);
            this.filtersNode = new SectionContainerNode((Children)ch);
            this.filtersNode.setDisplayName(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filters"));
            this.filtersNode.setName("dd_multiview_filters_filtersNode");
            this.filtersCont = new SectionContainer((SectionView)this, this.filtersNode, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filters"));
            this.filtersCont.setHeaderActions(new Action[]{FiltersMultiViewElement.this.addAction});
            Children.Array filtersChildren = new Children.Array();
            SectionPanel[] pan = new SectionPanel[filters.length];
            for (int i = 0; i < nodes.length; ++i) {
                pan[i] = new SectionPanel((SectionView)this, nodes[i], this.getFilterTitle(filters[i]), (Object)filters[i]);
                pan[i].setHeaderActions(new Action[]{FiltersMultiViewElement.this.removeAction});
                this.filtersCont.addSection((NodeSectionPanel)pan[i]);
            }
            this.addSection((NodeSectionPanel)this.filtersCont);
            this.filterMappingsNode = new FilterMappingsNode();
            this.filterMappingSectionPanel = new SectionPanel((SectionView)this, this.filterMappingsNode, (Object)"filter_mappings");
            this.addSection((NodeSectionPanel)this.filterMappingSectionPanel);
            filtersChildren.add(new Node[]{this.filtersNode, this.filterMappingsNode});
            AbstractNode root = new AbstractNode((Children)filtersChildren);
            this.setRoot((Node)root);
        }

        Node getFiltersNode() {
            return this.filtersNode;
        }

        SectionContainer getFiltersContainer() {
            return this.filtersCont;
        }

        SectionPanel getFilterMappingSectionPanel() {
            return this.filterMappingSectionPanel;
        }

        String getFilterTitle(Filter filter) {
            String filterName = filter.getFilterName();
            if (filterName == null) {
                filterName = "";
            }
            String mappings = DDUtils.urlPatternList(DDUtils.getUrlPatterns(FiltersMultiViewElement.this.webApp, filter));
            return NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filterPanel", (Object)filterName, (Object)mappings);
        }

        public Error validateView() {
            return SectionValidator.validateFilters(FiltersMultiViewElement.this.webApp);
        }
    }
}

