/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.core.HandlerCreator;
import org.netbeans.modules.websvc.core.HandlerCreatorProvider;
import org.netbeans.modules.websvc.spi.support.ClientCreatorProvider;
import org.netbeans.modules.websvc.spi.support.ServiceCreatorProvider;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class CreatorProvider {
    private static final Lookup.Result<ClientCreatorProvider> clientProviders = Lookup.getDefault().lookup(new Lookup.Template(ClientCreatorProvider.class));
    private static final Lookup.Result<ServiceCreatorProvider> serviceProviders = Lookup.getDefault().lookup(new Lookup.Template(ServiceCreatorProvider.class));
    private static final Lookup.Result<HandlerCreatorProvider> handlerProviders = Lookup.getDefault().lookup(new Lookup.Template(HandlerCreatorProvider.class));

    public static ClientCreator getClientCreator(Project project, WizardDescriptor wiz) {
        Collection instances = clientProviders.allInstances();
        for (ClientCreatorProvider impl : instances) {
            ClientCreator creator = impl.getClientCreator(project, wiz);
            if (creator == null) continue;
            return creator;
        }
        return null;
    }

    public static ServiceCreator getServiceCreator(Project project, WizardDescriptor wiz) {
        Collection instances = serviceProviders.allInstances();
        for (ServiceCreatorProvider impl : instances) {
            ServiceCreator creator = impl.getServiceCreator(project, wiz);
            if (creator == null) continue;
            return creator;
        }
        return null;
    }

    public static HandlerCreator getHandlerCreator(Project project, WizardDescriptor wiz) {
        Collection instances = handlerProviders.allInstances();
        for (HandlerCreatorProvider impl : instances) {
            HandlerCreator creator = impl.getHandlerCreator(project, wiz);
            if (creator == null) continue;
            return creator;
        }
        return null;
    }
}

