/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.PolicyManager;
import org.openide.filesystems.FileObject;

class CompilerTask
implements CancellableTask<CompilationController> {
    private final boolean[] insertServiceDef = new boolean[]{true};
    private final boolean[] generateWsRefInjection = new boolean[]{false};
    private final String[] printerName = new String[]{"System.out"};
    private final String serviceJavaName;
    private final String[] serviceFName;
    private final String[] argumentDeclPart;
    private final String[] paramNames;
    private final String[] argumentInitPart;
    private final PolicyManager manager;

    public CompilerTask(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, PolicyManager policyManager) {
        this.serviceJavaName = string;
        this.argumentInitPart = stringArray4;
        this.argumentDeclPart = stringArray2;
        this.paramNames = stringArray3;
        this.serviceFName = stringArray;
        this.manager = policyManager;
    }

    public void run(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
        TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
        if (typeElement != null) {
            Object object;
            ClassTree classTree = compilationController.getTrees().getTree(typeElement);
            this.generateWsRefInjection[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)compilationController, (TypeElement)typeElement);
            if (this.generateWsRefInjection[0]) {
                object = FileOwnerQuery.getOwner((FileObject)compilationController.getFileObject());
                this.generateWsRefInjection[0] = JaxWsUtils.isEjbSupported((Project)object);
            }
            boolean bl = this.insertServiceDef[0] = !this.generateWsRefInjection[0];
            if (CompilerTask.isServletClass(compilationController, typeElement)) {
                this.printerName[0] = "out";
                this.argumentInitPart[0] = CompilerTask.fixNamesInInitializationPart(this.argumentInitPart[0]);
                this.argumentDeclPart[0] = CompilerTask.fixNamesInDeclarationPart(this.argumentDeclPart[0]);
                CompilerTask.fixNamesMethodParams(this.paramNames);
            }
            if (this.generateWsRefInjection[0]) {
                object = new HashSet();
                boolean bl2 = false;
                int n = 0;
                for (Tree tree : classTree.getMembers()) {
                    String string;
                    ++n;
                    if (Tree.Kind.VARIABLE != tree.getKind()) continue;
                    VariableTree variableTree = (VariableTree)tree;
                    Tree tree2 = variableTree.getType();
                    TreePath treePath = compilationController.getTrees().getPath(compilationUnitTree, tree2);
                    TypeElement typeElement2 = (TypeElement)compilationController.getTrees().getElement(treePath);
                    if (typeElement2 != null && this.serviceJavaName.equals(string = typeElement2.getQualifiedName().toString())) {
                        this.serviceFName[0] = variableTree.getName().toString();
                        this.generateWsRefInjection[0] = false;
                        bl2 = true;
                        break;
                    }
                    object.add(variableTree.getName().toString());
                }
                if (!bl2) {
                    this.serviceFName[0] = CompilerTask.findProperServiceFieldName((Set)object);
                }
            }
        }
    }

    public void cancel() {
    }

    public String getMethodBody(String string, String string2, String string3, String string4) {
        String string5 = "";
        Object[] objectArray = this.getMethodBodyPortInitArguments(string, string2, string3, string4);
        if ("void".equals(string3)) {
            String string6 = (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   port.{5}({6});\n";
            string5 = MessageFormat.format(string6, objectArray);
        } else {
            String string7 = (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   return port.{5}({6});\n";
            string5 = MessageFormat.format(string7, objectArray);
        }
        return string5;
    }

    public String getJavaInvocationBody(WsdlOperation wsdlOperation, String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        Object[] objectArray = this.getInvocationBodyPortInitArguments(string, string2, string3, string4);
        switch (wsdlOperation.getOperationType()) {
            case 0: {
                if ("void".equals(string3)) {
                    String string7 = "\ntry '{' // Call Web Service Operation\n" + (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   port.{5}({6});\n" + "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
                    string6 = MessageFormat.format(string7, objectArray);
                    break;
                }
                String string8 = "\ntry '{' // Call Web Service Operation\n" + (this.insertServiceDef[0] ? "   {0} {7} = new {0}();\n" : "") + "   {1} port = {7}.{2}({9});\n" + "   {3}   // TODO process result here\n   {4} result = port.{5}({6});\n" + "   {8}.println(\"Result = \"+result);\n" + "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
                string6 = MessageFormat.format(string8, objectArray);
                break;
            }
            case 1: {
                string6 = MessageFormat.format("\ntry '{' // Call Web Service Operation(async. polling)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}   // TODO process asynchronous response here\n   {4} resp = port.{5}({6});\n   while(!resp.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+resp.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n", objectArray);
                break;
            }
            case 2: {
                objectArray[7] = string5;
                string6 = MessageFormat.format("\ntry '{' // Call Web Service Operation(async. callback)\n   {0} service = new {0}();\n   {1} port = service.{2}({9});\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> response) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ response.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} result = port.{5}({6});\n   while(!result.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n", objectArray);
            }
        }
        return string6;
    }

    public boolean containsWsRefInjection() {
        return !this.generateWsRefInjection[0];
    }

    public boolean isWsRefInjection() {
        return !this.insertServiceDef[0];
    }

    protected Object[] getMethodBodyPortInitArguments(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{this.serviceJavaName, string, string2, "", "", string4, this.argumentDeclPart[0], this.serviceFName[0], "", ""};
        if (this.manager.isSupported()) {
            this.manager.modifyPortCallInitArguments(objectArray);
        }
        return objectArray;
    }

    protected Object[] getInvocationBodyPortInitArguments(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{this.serviceJavaName, string, string2, this.argumentInitPart[0], string3, string4, this.argumentDeclPart[0], this.serviceFName[0], this.printerName[0], ""};
        if (this.manager.isSupported()) {
            this.manager.modifyPortInvocationInitArguments(objectArray);
        }
        return objectArray;
    }

    private static boolean isServletClass(CompilationController compilationController, TypeElement typeElement) {
        return SourceUtils.isSubtype((CompilationController)compilationController, (TypeElement)typeElement, (String)"javax.servlet.http.HttpServlet");
    }

    private static String fixNamesInInitializationPart(String string) {
        return string.replaceFirst(" request ", " request_1 ").replaceFirst(" response ", " response_1 ").replaceFirst(" out ", " out_1 ");
    }

    private static void fixNamesMethodParams(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("request".equals(stringArray[i])) {
                stringArray[i] = "request_1";
                continue;
            }
            if ("response".equals(stringArray[i])) {
                stringArray[i] = "response_1";
                continue;
            }
            if (!"out".equals(stringArray[i])) continue;
            stringArray[i] = "out_1";
        }
    }

    private static String fixNamesInDeclarationPart(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            string3 = "request".equals(string2) ? "request_1" : ("response".equals(string2) ? "response_1" : ("out".equals(string2) ? "out_1" : string2));
            stringBuffer.append(n > 0 ? ", " + string3 : string3);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String findProperServiceFieldName(Set set) {
        String string = "service";
        int n = 0;
        while (set.contains(string)) {
            string = "service_" + String.valueOf(++n);
        }
        return string;
    }
}

