/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.editor.completion.WSCompletionItem;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class WSCompletionProvider
implements CompletionProvider {
    private static Logger LOG = Logger.getLogger(WSCompletionProvider.class.getCanonicalName().toString());
    private static final String[] BINDING_TYPES = new String[]{"SOAPBinding.SOAP11HTTP_BINDING", "SOAPBinding.SOAP11HTTP_MTOM_BINDING", "SOAPBinding.SOAP12HTTP_BINDING", "SOAPBinding.SOAP12HTTP_MTOM_BINDING", "HTTPBinding.HTTP_BINDING"};

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (n == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new WsCompletionQuery(jTextComponent.getSelectionStart()), jTextComponent);
        }
        return null;
    }

    static final class WsCompletionQuery
    extends AsyncCompletionQuery
    implements CancellableTask<CompilationController> {
        private int caretOffset;
        private int anchorOffset;
        private List<CompletionItem> results;
        private JTextComponent component;
        private JAXWSSupport jaxWsSupport;

        private WsCompletionQuery(int n) {
            this.caretOffset = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                NbEditorUtilities.getFileObject((Document)document);
                JavaSource javaSource = JavaSource.forDocument((Document)document);
                if (javaSource != null) {
                    Future future = javaSource.runWhenScanFinished((Task)this, true);
                    if (future != null && !future.isDone()) {
                        this.setCompletionHack(false);
                        completionResultSet.setWaitText(NbBundle.getMessage(WSCompletionProvider.class, (String)"scanning-in-progress"));
                        future.get();
                    }
                    if (this.isTaskCancelled()) {
                        return;
                    }
                    if (this.results != null) {
                        completionResultSet.addAllItems(this.results);
                    }
                    if (this.anchorOffset > -1) {
                        completionResultSet.setAnchorOffset(this.anchorOffset);
                    }
                }
            }
            catch (CancellationException cancellationException) {
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                LOG.log(Level.WARNING, null, executionException);
            }
            finally {
                completionResultSet.finish();
            }
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            this.resolveCompletion(compilationController);
        }

        private void resolveCompletion(CompilationController compilationController) throws IOException {
            if (this.isTaskCancelled()) {
                return;
            }
            this.setCompletionHack(true);
            compilationController.toPhase(JavaSource.Phase.PARSED);
            this.results = new ArrayList<CompletionItem>();
            Env env = this.getCompletionEnvironment(compilationController, true);
            this.anchorOffset = env.getOffset();
            TreePath treePath = env.getPath();
            switch (treePath.getLeaf().getKind()) {
                case ANNOTATION: {
                    break;
                }
                case STRING_LITERAL: {
                    this.createStringResults(compilationController, env);
                    break;
                }
                case ASSIGNMENT: {
                    this.createAssignmentResults(compilationController, env);
                }
            }
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
            if (fileObject != null) {
                this.jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
            }
        }

        private Env getCompletionEnvironment(CompilationController compilationController, boolean bl) throws IOException {
            Object object;
            int n = this.caretOffset;
            String string = "";
            if (bl && n > 0) {
                object = compilationController.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                boolean bl2 = false;
                bl2 = object.move(n) == 0 ? object.movePrevious() : object.moveNext();
                if (bl2 && object.offset() < n) {
                    string = object.token().toString().substring(0, n - object.offset());
                    n = object.offset();
                    if (object.token().id() == JavaTokenId.STRING_LITERAL && string.startsWith("\"")) {
                        string = string.substring(1);
                        ++n;
                    } else if (object.token().id() == JavaTokenId.EQ && string.startsWith("=")) {
                        string = string.substring(1);
                        ++n;
                    }
                }
            }
            compilationController.toPhase(JavaSource.Phase.PARSED);
            object = compilationController.getTreeUtilities().pathFor(this.caretOffset);
            return new Env(n, string, (TreePath)object);
        }

        private void setCompletionHack(boolean bl) {
            if (this.component != null) {
                this.component.putClientProperty("completion-active", bl);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void createStringResults(CompilationController compilationController, Env env) throws IOException {
            TreePath treePath = env.getPath();
            TreePath treePath2 = treePath.getParentPath();
            Tree tree = treePath2.getLeaf();
            Tree tree2 = treePath2.getParentPath().getLeaf();
            switch (tree2.getKind()) {
                case ANNOTATION: {
                    switch (tree.getKind()) {
                        case ASSIGNMENT: {
                            FileObject fileObject;
                            TypeMirror typeMirror;
                            Name name;
                            ExpressionTree expressionTree = ((AssignmentTree)tree).getVariable();
                            if (expressionTree.getKind() != Tree.Kind.IDENTIFIER || !(name = ((IdentifierTree)expressionTree).getName()).contentEquals("wsdlLocation") || this.jaxWsSupport == null) return;
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebService");
                            if (typeElement == null || (typeMirror = compilationController.getTrees().getTypeMirror(treePath2.getParentPath())) == null || typeElement == null || !compilationController.getTypes().isSameType(typeMirror, typeElement.asType()) || (fileObject = this.jaxWsSupport.getWsdlFolder(false)) == null) return;
                            Enumeration enumeration = fileObject.getChildren(true);
                            while (enumeration.hasMoreElements()) {
                                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                                if (!fileObject2.isData() || !"wsdl".equalsIgnoreCase(fileObject2.getExt())) continue;
                                String string = FileUtil.getRelativePath((FileObject)fileObject.getParent().getParent(), (FileObject)fileObject2);
                                if (string.startsWith("conf/")) {
                                    string = "META-INF/" + string.substring(5);
                                }
                                if (!string.startsWith(env.getPrefix())) continue;
                                this.results.add(WSCompletionItem.createWsdlFileItem(fileObject, fileObject2, env.getOffset()));
                            }
                            return;
                        }
                    }
                    return;
                }
            }
        }

        private void createAssignmentResults(CompilationController compilationController, Env env) throws IOException {
            TreePath treePath = env.getPath();
            TreePath treePath2 = treePath.getParentPath();
            Tree tree = treePath2.getLeaf();
            switch (tree.getKind()) {
                case ANNOTATION: {
                    TypeMirror typeMirror;
                    Name name;
                    ExpressionTree expressionTree = ((AssignmentTree)treePath.getLeaf()).getVariable();
                    if (expressionTree.getKind() != Tree.Kind.IDENTIFIER || !(name = ((IdentifierTree)expressionTree).getName()).contentEquals("value")) break;
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement("javax.xml.ws.BindingType");
                    if (typeElement == null || (typeMirror = compilationController.getTrees().getTypeMirror(treePath2)) == null || typeElement == null || !compilationController.getTypes().isSameType(typeMirror, typeElement.asType())) break;
                    for (String string : BINDING_TYPES) {
                        if (!string.startsWith(env.getPrefix())) continue;
                        this.results.add(WSCompletionItem.createEnumItem(string, "String", env.getOffset()));
                    }
                    break;
                }
            }
        }

        private class Env {
            private int offset;
            private String prefix;
            private TreePath path;

            private Env(int n, String string, TreePath treePath) {
                this.offset = n;
                this.prefix = string;
                this.path = treePath;
            }

            public int getOffset() {
                return this.offset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public TreePath getPath() {
                return this.path;
            }
        }
    }
}

