/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.macros.storage.ui.MacrosPanel;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MacroDialogSupport {
    private static final Logger LOG = Logger.getLogger(MacroDialogSupport.class.getName());

    private MacroDialogSupport() {
    }

    public static MacroDescription findMacro(MimePath mimeType, KeyStroke ... shortcut) {
        Map macros;
        EditorSettingsStorage ess = EditorSettingsStorage.get((String)"Macros");
        MacroDescription macro = null;
        try {
            macros = ess.load(mimeType, null, false);
            macro = MacroDialogSupport.findByShortcut(macros, shortcut);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
        }
        if (macro == null) {
            try {
                macros = ess.load(MimePath.EMPTY, null, false);
                macro = MacroDialogSupport.findByShortcut(macros, shortcut);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
        return macro;
    }

    private static final MacroDescription findByShortcut(Map<String, MacroDescription> macros, KeyStroke ... shortcut) {
        for (MacroDescription m : macros.values()) {
            block1: for (MultiKeyBinding multiKeyBinding : m.getShortcuts()) {
                if (multiKeyBinding.getKeyStrokeCount() != shortcut.length) continue;
                for (int i = 0; i < shortcut.length; ++i) {
                    if (!multiKeyBinding.getKeyStroke(i).equals(shortcut[i])) continue block1;
                }
                return m;
            }
        }
        return null;
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet<String> runningActions = new HashSet();
        public static final String runMacroAction = "run-macro";

        public RunMacroAction() {
            super(runMacroAction, 64);
        }

        protected void error(JTextComponent target, String messageKey, Object ... params) {
            String message;
            try {
                message = NbBundle.getMessage(RunMacroAction.class, (String)messageKey, (Object[])params);
            }
            catch (MissingResourceException e) {
                message = "Error in macro: " + messageKey;
            }
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, 0);
            Toolkit.getDefaultToolkit().beep();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, null, new Throwable(message));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("actionCommand='" + evt.getActionCommand() + "', modifiers=" + evt.getModifiers() + ", when=" + evt.getWhen() + ", paramString='" + evt.paramString() + "'");
            }
            if (target == null) {
                return;
            }
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            if (doc == null) {
                return;
            }
            AWTEvent maybeKeyEvent = EventQueue.getCurrentEvent();
            if (!(maybeKeyEvent instanceof KeyEvent)) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent((KeyEvent)maybeKeyEvent);
            MimePath mimeType = MimePath.parse((String)NbEditorUtilities.getMimeType((JTextComponent)target));
            MacroDescription macro = MacroDialogSupport.findMacro(mimeType, keyStroke);
            if (macro == null) {
                KeyStroke[] shortcut = StorageSupport.stringToKeyStrokes((String)evt.getActionCommand(), (boolean)false);
                macro = MacroDialogSupport.findMacro(mimeType, shortcut);
            }
            if (macro == null) {
                this.error(target, "macro-not-found", StorageSupport.keyStrokesToString(Collections.singleton(keyStroke), (boolean)false));
                return;
            }
            if (!runningActions.add(macro.getName())) {
                this.error(target, "macro-loop", macro.getName());
                return;
            }
            try {
                this.runMacro(target, doc, kit, macro);
            }
            finally {
                runningActions.remove(macro.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMacro(JTextComponent component, BaseDocument doc, BaseKit kit, MacroDescription macro) {
            StringBuffer actionName = new StringBuffer();
            char[] command = macro.getCode().toCharArray();
            int len = command.length;
            doc.atomicLock();
            try {
                for (int i = 0; i < len; ++i) {
                    if (Character.isWhitespace(command[i])) continue;
                    if (command[i] == '\"') {
                        while (++i < len && command[i] != '\"') {
                            Action a;
                            char ch = command[i];
                            if (ch == '\\') {
                                if (++i >= len) {
                                    this.error(component, "macro-malformed", macro.getName());
                                    return;
                                }
                                ch = command[i];
                                if (ch != '\"' && ch != '\\') {
                                    this.error(component, "macro-malformed", macro.getName());
                                    return;
                                }
                            }
                            if ((a = component.getKeymap().getDefaultAction()) == null) continue;
                            ActionEvent newEvt = new ActionEvent(component, 0, new String(new char[]{ch}));
                            if (a instanceof BaseAction) {
                                ((BaseAction)a).updateComponent(component);
                                ((BaseAction)a).actionPerformed(newEvt, component);
                                continue;
                            }
                            a.actionPerformed(newEvt);
                        }
                        continue;
                    }
                    actionName.setLength(0);
                    while (i < len && !Character.isWhitespace(command[i])) {
                        char ch;
                        if ((ch = command[i++]) == '\\') {
                            if (i >= len) {
                                this.error(component, "macro-malformed", macro.getName());
                                return;
                            }
                            if ((ch = command[i++]) != '\\' && !Character.isWhitespace(ch)) {
                                this.error(component, "macro-malformed", macro.getName());
                                return;
                            }
                        }
                        actionName.append(ch);
                    }
                    Action a = kit.getActionByName(actionName.toString());
                    if (a != null) {
                        ActionEvent fakeEvt = new ActionEvent(component, 0, "");
                        if (a instanceof BaseAction) {
                            ((BaseAction)a).updateComponent(component);
                            ((BaseAction)a).actionPerformed(fakeEvt, component);
                        } else {
                            a.actionPerformed(fakeEvt);
                        }
                        if (!"insert-break".equals(actionName.toString())) continue;
                        Action def = component.getKeymap().getDefaultAction();
                        ActionEvent fakeEvt10 = new ActionEvent(component, 0, new String(new byte[]{10}));
                        if (def instanceof BaseAction) {
                            ((BaseAction)def).updateComponent(component);
                            ((BaseAction)def).actionPerformed(fakeEvt10, component);
                            continue;
                        }
                        def.actionPerformed(fakeEvt10);
                        continue;
                    }
                    this.error(component, "macro-unknown-action", macro.getName(), actionName.toString());
                    return;
                }
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    public static final class StopMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/macros/stop_macro_recording.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                final String macro = this.stopRecording(target);
                if (macro == null) {
                    target.getToolkit().beep();
                } else {
                    final MacrosPanel panel = new MacrosPanel(Lookup.getDefault());
                    panel.setBorder(new EmptyBorder(10, 10, 10, 10));
                    panel.addAncestorListener(new AncestorListener(){

                        @Override
                        public void ancestorAdded(AncestorEvent event) {
                            panel.forceAddMacro(macro);
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent event) {
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent event) {
                        }
                    });
                    panel.getModel().load();
                    final DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(MacroDialogSupport.class, (String)"Macros_Dialog_title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                    descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
                    descriptor.setValid(false);
                    panel.getModel().addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName() == null || "changed".equals(evt.getPropertyName())) {
                                descriptor.setValid(panel.getModel().isChanged());
                            }
                        }
                    });
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                        panel.save();
                    }
                }
            }
        }

        private String stopRecording(JTextComponent c) {
            try {
                Method m = BaseAction.class.getDeclaredMethod("stopRecording", JTextComponent.class);
                m.setAccessible(true);
                return (String)m.invoke((Object)this, c);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't call BaseAction.stopRecording", e);
                return null;
            }
        }
    }

    public static class StartMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/macros/start_macro_recording.png");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && !this.startRecording(target)) {
                target.getToolkit().beep();
            }
        }

        private boolean startRecording(JTextComponent c) {
            try {
                Method m = BaseAction.class.getDeclaredMethod("startRecording", JTextComponent.class);
                m.setAccessible(true);
                return (Boolean)m.invoke((Object)this, c);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't call BaseAction.startRecording", e);
                return false;
            }
        }
    }
}

