/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.macros.storage.ui.MacrosNamePanel;
import org.netbeans.modules.editor.macros.storage.ui.TableSorter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MacrosPanel
extends JPanel {
    private final MacrosModel model = MacrosModel.get();
    private TableSorter sorter;
    private JButton bNew;
    private JButton bRemove;
    private JButton bSetShortcut;
    private JEditorPane epMacroCode;
    private JLabel lMacroCode;
    private JLabel lMacros;
    private JScrollPane sMacroCode;
    private JScrollPane spMacros;
    private JTable tMacros;

    public MacrosPanel(Lookup lookup) {
        this.initComponents();
        this.tMacros.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macros_Table"));
        this.tMacros.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macros_Table"));
        this.epMacroCode.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macro"));
        this.epMacroCode.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macro"));
        this.bRemove.setEnabled(false);
        this.bSetShortcut.setEnabled(false);
        MacrosPanel.loc(this.bNew, "New_Macro");
        MacrosPanel.loc(this.bRemove, "Remove_Macro");
        MacrosPanel.loc(this.bSetShortcut, "Shortcut");
        this.tMacros.getSelectionModel().setSelectionMode(0);
        this.tMacros.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MacrosPanel.this.tMacrosValueChanged(evt);
            }
        });
        this.tMacros.getTableHeader().setReorderingAllowed(false);
        this.sorter = new TableSorter(this.model.getTableModel());
        this.tMacros.setModel(this.sorter);
        this.sorter.setTableHeader(this.tMacros.getTableHeader());
        this.sorter.getTableHeader().setReorderingAllowed(false);
        this.tMacros.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                MacrosPanel.this.tMacrosTableChanged(evt);
            }
        });
        this.tMacros.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    MacrosPanel.this.epMacroCode.requestFocusInWindow();
                    e.consume();
                }
            }
        });
        this.epMacroCode.setEnabled(false);
        this.epMacroCode.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        this.epMacroCode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MacrosPanel.this.epMacroCodeDocumentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MacrosPanel.this.epMacroCodeDocumentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        MacrosPanel.loc(this.lMacros, "Macro_List");
        this.lMacros.setLabelFor(this.tMacros);
        MacrosPanel.loc(this.lMacroCode, "Macro_Code");
        this.lMacroCode.setLabelFor(this.epMacroCode);
    }

    public MacrosModel getModel() {
        return this.model;
    }

    public void forceAddMacro(String code) {
        MacrosModel.Macro macro = this.addMacro();
        if (macro != null) {
            macro.setCode(code);
        }
    }

    private void initComponents() {
        this.lMacros = new JLabel();
        this.spMacros = new JScrollPane();
        this.tMacros = new JTable();
        this.bNew = new JButton();
        this.bSetShortcut = new JButton();
        this.bRemove = new JButton();
        this.lMacroCode = new JLabel();
        this.sMacroCode = new JScrollPane();
        this.epMacroCode = new JEditorPane();
        this.lMacros.setText("Macros:");
        this.tMacros.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.spMacros.setViewportView(this.tMacros);
        this.bNew.setText("New");
        this.bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacrosPanel.this.bNewActionPerformed(evt);
            }
        });
        this.bSetShortcut.setText("Set Shortcut...");
        this.bSetShortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacrosPanel.this.bSetShortcutActionPerformed(evt);
            }
        });
        this.bRemove.setText("Remove");
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacrosPanel.this.bRemoveActionPerformed(evt);
            }
        });
        this.lMacroCode.setText("Macro Code:");
        this.sMacroCode.setViewportView(this.epMacroCode);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lMacros).addComponent(this.lMacroCode).addComponent(this.spMacros, -1, 352, Short.MAX_VALUE).addComponent(this.sMacroCode, -1, 352, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.bNew, -1, 128, Short.MAX_VALUE).addComponent(this.bSetShortcut, -1, -1, Short.MAX_VALUE).addComponent(this.bRemove, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lMacros).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSetShortcut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRemove).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.spMacros, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lMacroCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sMacroCode, -1, 147, Short.MAX_VALUE)))));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MacrosPanel.class, (String)"AN_MacrosPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacrosPanel.class, (String)"AD_MacrosPanel"));
    }

    private void bNewActionPerformed(ActionEvent evt) {
        this.addMacro();
    }

    private void bSetShortcutActionPerformed(ActionEvent evt) {
        ShortcutsFinder shortcutsFinder = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        assert (shortcutsFinder != null) : "Can't find ShortcutsFinder";
        int selectedRow = this.tMacros.getSelectedRow();
        shortcutsFinder.refreshActions();
        String shortcut = shortcutsFinder.showShortcutsDialog();
        ShortcutAction act = shortcutsFinder.findActionForShortcut(shortcut);
        List<MacrosModel.Macro> list = this.model.getAllMacros();
        for (MacrosModel.Macro m : list) {
            String sc;
            if (m.getShortcuts().size() <= 0 || !(sc = StorageSupport.keyStrokesToString((Collection)m.getShortcuts().get(0).getKeyStrokeList(), (boolean)false)).equals(shortcut)) continue;
            m.setShortcuts(Collections.<String>emptySet());
        }
        if (act != null) {
            Set<String> set = Collections.emptySet();
            if (act instanceof MacrosModel.Macro) {
                ((MacrosModel.Macro)act).setShortcuts(set);
            }
            shortcutsFinder.setShortcuts(act, set);
        }
        if (shortcut != null) {
            int modelRow = this.sorter.modelIndex(selectedRow);
            MacrosModel.Macro macro = this.model.getMacroByIndex(modelRow);
            macro.setShortcut(shortcut);
            shortcutsFinder.setShortcuts((ShortcutAction)macro, Collections.singleton(shortcut));
        }
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        ShortcutsFinder shortcutsFinder = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        int modelIndex = this.sorter.modelIndex(this.tMacros.getSelectedRow());
        shortcutsFinder.setShortcuts((ShortcutAction)this.model.getMacroByIndex(modelIndex), Collections.emptySet());
        this.model.deleteMacro(modelIndex);
    }

    private void tMacrosValueChanged(ListSelectionEvent evt) {
        int index = this.tMacros.getSelectedRow();
        if (index < 0 || index >= this.tMacros.getRowCount()) {
            this.epMacroCode.setText("");
            this.epMacroCode.setEnabled(false);
            this.bRemove.setEnabled(false);
            this.bSetShortcut.setEnabled(false);
        } else {
            int modelIndex = this.sorter.modelIndex(index);
            this.epMacroCode.setText(this.model.getMacroByIndex(modelIndex).getCode());
            this.epMacroCode.getCaret().setDot(0);
            this.epMacroCode.setEnabled(true);
            this.bRemove.setEnabled(true);
            this.bSetShortcut.setEnabled(true);
        }
    }

    private void tMacrosTableChanged(final TableModelEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (evt.getType() == 1) {
                    MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(evt.getFirstRow(), evt.getFirstRow());
                } else if (evt.getType() == -1) {
                    int tableRow = evt.getLastRow();
                    if (tableRow < MacrosPanel.this.tMacros.getModel().getRowCount()) {
                        MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(tableRow, tableRow);
                    } else {
                        tableRow = evt.getFirstRow() - 1;
                        if (tableRow >= 0) {
                            MacrosPanel.this.tMacros.getSelectionModel().setSelectionInterval(tableRow, tableRow);
                        } else {
                            MacrosPanel.this.tMacros.getSelectionModel().clearSelection();
                        }
                    }
                }
            }
        });
    }

    private void epMacroCodeDocumentChanged() {
        int index = this.tMacros.getSelectedRow();
        if (index >= 0) {
            this.model.getMacroByIndex(this.sorter.modelIndex(index)).setCode(this.epMacroCode.getText());
        }
    }

    private static String loc(String key) {
        return NbBundle.getMessage(MacrosPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)MacrosPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)MacrosPanel.loc("CTL_" + key));
        }
    }

    private MacrosModel.Macro addMacro() {
        final MacrosNamePanel panel = new MacrosNamePanel();
        final DialogDescriptor descriptor = new DialogDescriptor((Object)panel, MacrosPanel.loc("CTL_New_macro_dialog_title"));
        panel.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String name = panel.getNameValue().trim();
                String err = MacrosPanel.this.model.validateMacroName(name);
                descriptor.setValid(err == null);
                panel.setErrorMessage(err);
            }
        });
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == DialogDescriptor.OK_OPTION) {
            String macroName = panel.getNameValue().trim();
            return this.model.createMacro(MimePath.EMPTY, macroName);
        }
        return null;
    }

    public void save() {
        this.getModel().save();
        ShortcutsFinder f = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        f.apply();
    }
}

