/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public final class MavenEmbedder {
    private static final Logger LOG = Logger.getLogger(MavenEmbedder.class.getName());
    private final PlexusContainer plexus;
    private final DefaultMaven maven;
    private final ProjectBuilder projectBuilder;
    private final RepositorySystem repositorySystem;
    private final MavenExecutionRequestPopulator populator;
    private final SettingsBuilder settingsBuilder;
    private final EmbedderConfiguration embedderConfiguration;
    private final SettingsDecrypter settingsDecrypter;
    private long settingsTimestamp;
    private Settings settings;

    MavenEmbedder(EmbedderConfiguration configuration) throws ComponentLookupException {
        this.embedderConfiguration = configuration;
        this.plexus = configuration.getContainer();
        this.maven = (DefaultMaven)this.plexus.lookup(Maven.class);
        this.projectBuilder = (ProjectBuilder)this.plexus.lookup(ProjectBuilder.class);
        this.repositorySystem = (RepositorySystem)this.plexus.lookup(RepositorySystem.class);
        this.settingsBuilder = (SettingsBuilder)this.plexus.lookup(SettingsBuilder.class);
        this.populator = (MavenExecutionRequestPopulator)this.plexus.lookup(MavenExecutionRequestPopulator.class);
        this.settingsDecrypter = (SettingsDecrypter)this.plexus.lookup(SettingsDecrypter.class);
    }

    public PlexusContainer getPlexus() {
        return this.plexus;
    }

    public Properties getSystemProperties() {
        return this.embedderConfiguration.getSystemProperties();
    }

    boolean isOffline() {
        return this.embedderConfiguration.isOffline();
    }

    public ArtifactRepository getLocalRepository() {
        try {
            String localRepositoryPath = this.getSettings().getLocalRepository();
            if (localRepositoryPath != null) {
                return this.repositorySystem.createLocalRepository(new File(localRepositoryPath));
            }
            return this.repositorySystem.createLocalRepository(RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized Settings getSettings() {
        File settingsXml = this.embedderConfiguration.getSettingsXml();
        long newSettingsTimestamp = (long)settingsXml.hashCode() ^ settingsXml.lastModified() ^ MavenCli.DEFAULT_USER_SETTINGS_FILE.lastModified();
        if (this.settings != null && this.settingsTimestamp == newSettingsTimestamp) {
            LOG.log(Level.FINER, "settings.xml cache hit for {0}", this);
            return this.settings;
        }
        LOG.log(Level.FINE, "settings.xml cache miss for {0}", this);
        DefaultSettingsBuildingRequest req = new DefaultSettingsBuildingRequest();
        req.setGlobalSettingsFile(settingsXml);
        req.setUserSettingsFile(MavenCli.DEFAULT_USER_SETTINGS_FILE);
        req.setSystemProperties(this.getSystemProperties());
        try {
            this.settings = this.settingsBuilder.build((SettingsBuildingRequest)req).getEffectiveSettings();
            this.settingsTimestamp = newSettingsTimestamp;
            return this.settings;
        }
        catch (SettingsBuildingException x) {
            LOG.log(Level.FINE, null, x);
            return new Settings();
        }
    }

    public MavenExecutionResult readProjectWithDependencies(MavenExecutionRequest req) {
        req.setWorkspaceReader(new WorkspaceReader(){
            final WorkspaceRepository repo = new WorkspaceRepository("ide", this.getClass());
            final Collection<? extends ArtifactFixer> fixers = Lookup.getDefault().lookupAll(ArtifactFixer.class);

            public WorkspaceRepository getRepository() {
                return this.repo;
            }

            public File findArtifact(Artifact artifact) {
                for (ArtifactFixer artifactFixer : this.fixers) {
                    File f = artifactFixer.resolve(artifact);
                    if (f == null) continue;
                    return f;
                }
                return null;
            }

            public List<String> findVersions(Artifact artifact) {
                return Collections.emptyList();
            }
        });
        File pomFile = req.getPom();
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            ProjectBuildingRequest configuration = req.getProjectBuildingRequest();
            configuration.setValidationLevel(0);
            configuration.setResolveDependencies(true);
            configuration.setRepositorySession(this.maven.newRepositorySession(req));
            ProjectBuildingResult projectBuildingResult = this.projectBuilder.build(pomFile, configuration);
            result.setProject(projectBuildingResult.getProject());
            result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
        }
        catch (ProjectBuildingException ex) {
            return result.addException((Throwable)ex);
        }
        return result;
    }

    public org.apache.maven.artifact.Artifact createArtifactWithClassifier(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, String type, String classifier) {
        return this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public org.apache.maven.artifact.Artifact createArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull String packaging) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, packaging);
    }

    public org.apache.maven.artifact.Artifact createArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, String scope, String type) {
        return this.repositorySystem.createArtifact(groupId, artifactId, version, scope, type);
    }

    public org.apache.maven.artifact.Artifact createProjectArtifact(@NonNull String groupId, @NonNull String artifactId, @NonNull String version) {
        return this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
    }

    public void resolve(org.apache.maven.artifact.Artifact sources, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.setUpLegacySupport();
        ArtifactResolutionRequest req = new ArtifactResolutionRequest();
        req.setLocalRepository(localRepository);
        req.setRemoteRepositories(remoteRepositories);
        req.setArtifact(sources);
        req.setOffline(this.isOffline());
        this.repositorySystem.resolve(req);
    }

    public ProjectBuildingResult buildProject(org.apache.maven.artifact.Artifact art, ProjectBuildingRequest req) throws ProjectBuildingException {
        if (req.getLocalRepository() == null) {
            req.setLocalRepository(this.getLocalRepository());
        }
        MavenExecutionRequest request = this.createMavenExecutionRequest();
        req.setProcessPlugins(false);
        req.setRepositorySession(this.maven.newRepositorySession(request));
        return this.projectBuilder.build(art, req);
    }

    public MavenExecutionResult execute(MavenExecutionRequest req) {
        return this.maven.execute(req);
    }

    public List<String> getLifecyclePhases() {
        LifecycleMapping lifecycleMapping = this.lookupComponent(LifecycleMapping.class);
        if (lifecycleMapping != null) {
            TreeSet phases = new TreeSet();
            Map lifecycles = lifecycleMapping.getLifecycles();
            for (Lifecycle lifecycle : lifecycles.values()) {
                phases.addAll(lifecycle.getPhases().keySet());
            }
            return new ArrayList<String>(phases);
        }
        return Collections.emptyList();
    }

    public <T> T lookupComponent(Class<T> clazz) {
        try {
            return (T)this.plexus.lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            LOG.warning(ex.getMessage());
            return null;
        }
    }

    public MavenExecutionRequest createMavenExecutionRequest() {
        File settingsXml;
        DefaultMavenExecutionRequest req = new DefaultMavenExecutionRequest();
        ArtifactRepository localRepository = this.getLocalRepository();
        req.setLocalRepository(localRepository);
        req.setLocalRepositoryPath(localRepository.getBasedir());
        if (req.getRemoteRepositories() == null) {
            req.setRemoteRepositories(Collections.emptyList());
        }
        if ((settingsXml = this.embedderConfiguration.getSettingsXml()) != null && settingsXml.exists()) {
            req.setGlobalSettingsFile(settingsXml);
        }
        if (MavenCli.DEFAULT_USER_SETTINGS_FILE != null && MavenCli.DEFAULT_USER_SETTINGS_FILE.exists()) {
            req.setUserSettingsFile(MavenCli.DEFAULT_USER_SETTINGS_FILE);
        }
        req.setSystemProperties(this.getSystemProperties());
        try {
            this.populator.populateDefaults((MavenExecutionRequest)req);
            this.populator.populateFromSettings((MavenExecutionRequest)req, this.getSettings());
        }
        catch (MavenExecutionRequestPopulationException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        req.setOffline(this.isOffline());
        return req;
    }

    public void setUpLegacySupport() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        session.setOffline(this.isOffline());
        session.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(this.getLocalRepository().getBasedir()));
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        Settings _settings = this.getSettings();
        for (Mirror m : _settings.getMirrors()) {
            mirrorSelector.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(_settings));
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy p : decryptionResult.getProxies()) {
            proxySelector.add(new Proxy(null, p.getHost(), p.getPort(), new Authentication(p.getUsername(), p.getPassword())), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector authenticationSelector = new DefaultAuthenticationSelector();
        for (Server s : decryptionResult.getServers()) {
            authenticationSelector.add(s.getId(), new Authentication(s.getUsername(), s.getPassword(), s.getPrivateKey(), s.getPassphrase()));
        }
        session.setAuthenticationSelector((AuthenticationSelector)authenticationSelector);
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequest.setOffline(this.isOffline());
        this.lookupComponent(LegacySupport.class).setSession(new MavenSession(this.getPlexus(), (RepositorySystemSession)session, (MavenExecutionRequest)mavenExecutionRequest, (MavenExecutionResult)new DefaultMavenExecutionResult()));
    }
}

