/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.text.NbDocument;

public class CustomTargetPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -5820333613938630399L;
    private JTextField dependsOn;
    private JEditorPane actionText;
    private StyledDocument actionDoc;
    private String depends;
    private boolean initialized;
    private boolean inAddNotify = false;
    private int key;

    CustomTargetPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_CustomTargetPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        JLabel label = new JLabel(this.getString("LBL_DependsOn"));
        label.setDisplayedMnemonic(this.getString("MNEM_DependsOn").charAt(0));
        grid.anchor = 17;
        grid.gridx = 0;
        grid.gridy = 0;
        panel.add((Component)label, grid);
        this.dependsOn = new JTextField();
        label.setLabelFor(this.dependsOn);
        grid.gridx = 1;
        grid.gridwidth = 0;
        grid.weightx = 1.0;
        grid.fill = 2;
        grid.anchor = 18;
        grid.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.dependsOn, grid);
        label = new JLabel(this.getString("LBL_ActionDisplay"));
        label.setDisplayedMnemonic(this.getString("MNEM_ActionDisplay").charAt(0));
        grid.gridx = 0;
        grid.gridy = 1;
        grid.gridwidth = 1;
        grid.weightx = 0.0;
        grid.fill = 0;
        grid.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)label, grid);
        this.add((Component)panel, "North");
        this.actionText = new JEditorPane("text/x-make", "");
        label.setLabelFor(this.actionText);
        if (!(this.actionText.getDocument() instanceof StyledDocument)) {
            this.actionText.setDocument(new DefaultStyledDocument());
        }
        this.actionDoc = (StyledDocument)this.actionText.getDocument();
        JScrollPane s = new JScrollPane(this.actionText);
        s.setHorizontalScrollBarPolicy(30);
        s.setVerticalScrollBarPolicy(20);
        s.setMinimumSize(s.getPreferredSize());
        this.add((Component)s, "Center");
        this.dependsOn.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CustomTargetPanel.this.insertActionDisplay(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CustomTargetPanel.this.removeActionDisplay(e);
            }
        });
    }

    private void insertActionDisplay(DocumentEvent e) {
        if (!this.inAddNotify) {
            Element elem;
            String nueDependsOn;
            TargetData target;
            block3: {
                target = this.getMakefileData().getCurrentTarget();
                int off = e.getOffset();
                nueDependsOn = this.dependsOn.getText();
                String nuePart = nueDependsOn.substring(off, off + e.getLength());
                off += target.getName().length() + 2;
                elem = this.actionDoc.getParagraphElement(0);
                NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)elem.getStartOffset(), (int)(elem.getEndOffset() - elem.getStartOffset() + 1));
                try {
                    this.actionDoc.insertString(off, nuePart, null);
                }
                catch (BadLocationException ex) {
                    if (!CndPathUtilitities.IfdefDiagnostics) break block3;
                    System.out.println("BadLocationException: " + ex.getMessage() + "\n\toffset = " + ex.offsetRequested());
                    ex.printStackTrace();
                }
            }
            this.depends = nueDependsOn;
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)elem.getStartOffset(), (int)(target.getName().length() + this.depends.length() + 3));
        }
    }

    private void removeActionDisplay(DocumentEvent e) {
        if (!this.inAddNotify) {
            Element elem;
            TargetData target;
            block3: {
                target = this.getMakefileData().getCurrentTarget();
                int off = target.getName().length() + 2 + e.getOffset();
                elem = this.actionDoc.getParagraphElement(0);
                NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)elem.getStartOffset(), (int)(elem.getEndOffset() - elem.getStartOffset() + 1));
                try {
                    this.actionDoc.remove(off, e.getLength());
                }
                catch (BadLocationException ex) {
                    if (!CndPathUtilitities.IfdefDiagnostics) break block3;
                    System.out.println("BadLocationException[6]: " + ex.getMessage() + "\n\toffset = " + ex.offsetRequested());
                    ex.printStackTrace();
                }
            }
            this.depends = this.dependsOn.getText();
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)elem.getStartOffset(), (int)(target.getName().length() + this.depends.length() + 3));
        }
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        String action;
        int invalidLines;
        int extraLines;
        block6: {
            AbstractDocument doc = (AbstractDocument)this.actionText.getDocument();
            extraLines = 0;
            invalidLines = 0;
            try {
                action = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                action = "";
                if (!CndPathUtilitities.IfdefDiagnostics) break block6;
                System.out.println("BadLocationException validating target");
                e.printStackTrace();
            }
        }
        StringTokenizer st = new StringTokenizer(action, "\n");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.length() == 0 || extraLines > 0) {
                ++extraLines;
                continue;
            }
            if (line.startsWith("\t")) continue;
            ++invalidLines;
        }
        if (extraLines > 0) {
            this.warn(msgs, WARN_EXTRA_LINES_IN_TARGET, String.valueOf(extraLines));
        }
        if (invalidLines > 0) {
            this.warn(msgs, WARN_INVALID_LINES_IN_TARGET, String.valueOf(invalidLines));
        }
    }

    @Override
    public void addNotify() {
        block15: {
            StringBuilder depline;
            TargetData target;
            block14: {
                block13: {
                    target = this.getMakefileData().getCurrentTarget();
                    if (!this.initialized) {
                        this.create();
                        this.initialized = true;
                    }
                    this.key = target.getKey();
                    this.inAddNotify = true;
                    this.depends = target.getDependsOn();
                    if (this.depends == null) {
                        this.depends = "";
                    }
                    this.dependsOn.setText(this.depends);
                    Element elem = this.actionDoc.getParagraphElement(0);
                    NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)elem.getStartOffset(), (int)(elem.getEndOffset() - elem.getStartOffset() + 1));
                    try {
                        this.actionDoc.remove(0, this.actionDoc.getLength());
                    }
                    catch (BadLocationException e) {
                        if (!CndPathUtilitities.IfdefDiagnostics) break block13;
                        System.out.println("BadLocationException[1]: " + e.getMessage() + "\n\toffset = " + e.offsetRequested());
                        e.printStackTrace();
                    }
                }
                depline = new StringBuilder(target.getName());
                if (target.getName().equals("clean")) {
                    depline.append(":: ");
                } else {
                    depline.append(": ");
                }
                if (this.depends.length() > 0) {
                    depline.append(this.depends);
                }
                depline.append("\n");
                try {
                    this.actionDoc.insertString(0, depline.toString(), null);
                }
                catch (BadLocationException e) {
                    if (!CndPathUtilitities.IfdefDiagnostics) break block14;
                    System.out.println("BadLocationException[2]: " + e.getMessage() + "\n\toffset = " + e.offsetRequested());
                    e.printStackTrace();
                }
            }
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)0, (int)depline.length());
            ArrayList list = target.getActions();
            StringBuilder action = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                String line = list.get(i).toString();
                action.append("\t").append(line).append("\n");
            }
            if (action.length() == 0) {
                action.append("\t");
            }
            try {
                this.actionDoc.insertString(depline.length(), action.toString(), null);
            }
            catch (BadLocationException e) {
                if (!CndPathUtilitities.IfdefDiagnostics) break block15;
                System.out.println("BadLocationException[3]: " + e.getMessage() + "\n\toffset = " + e.offsetRequested());
                e.printStackTrace();
            }
        }
        super.addNotify();
        this.inAddNotify = false;
    }

    @Override
    public void removeNotify() {
        String action;
        TargetData target;
        block4: {
            super.removeNotify();
            target = this.getMakefileData().getTarget(this.key);
            action = null;
            target.setDependsOn(this.depends);
            try {
                action = this.actionDoc.getText(0, this.actionDoc.getLength());
            }
            catch (BadLocationException e) {
                if (!CndPathUtilitities.IfdefDiagnostics) break block4;
                System.out.println("BadLocationException[4]: " + e.getMessage() + "\n\toffset = " + e.offsetRequested());
                e.printStackTrace();
            }
        }
        if (action != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(action, "\n");
            st.nextToken();
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken().trim();
                if (tmp.length() <= 0) continue;
                list.add(tmp);
            }
            target.setActions(list);
        }
    }
}

