/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makefile.wizard.ItemChooser;
import org.netbeans.modules.cnd.makefile.wizard.MakefileData;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;

public class TargetNamePanel
extends ItemChooser {
    private String label;
    private char mnemonic;
    private String tname;
    static final long serialVersionUID = 6653452210904639697L;
    private boolean initialized = false;

    TargetNamePanel(MakefileWizard wd) {
        super(wd, true);
        String subtitle = this.getString("TITLE_TargetName");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        TargetData target = this.getMakefileData().getTarget(key);
        String cwd = this.getMakefileData().getBaseDirectory(true);
        File bindir = null;
        File outdir = null;
        File outpar = null;
        String bname = CndPathUtilitities.expandPath((String)target.getName());
        String odir = CndPathUtilitities.expandPath((String)target.getOutputDirectory());
        if (bname.length() > 0) {
            File btmp = bname.startsWith(File.separator) ? new File(bname) : new File(cwd, bname);
            bindir = btmp.getParentFile();
        }
        if (odir.length() > 0 && !odir.equals(cwd) && !odir.equals(bname)) {
            outdir = odir.startsWith(File.separator) ? new File(odir) : new File(cwd, odir);
            outpar = outdir.getParentFile();
        }
        if (bindir != null && !bindir.getPath().equals(cwd) && bindir.exists() && !bindir.canWrite()) {
            this.warn(msgs, WARN_BINDIR_NOT_WRITABLE, bindir.getPath(), bname);
        }
        if (outdir != null && !outdir.equals(bindir)) {
            if (!outdir.exists()) {
                if (outpar == null || !outpar.canWrite()) {
                    this.warn(msgs, WARN_CANNOT_CREATE_OUTPUT_DIR, outdir.getPath());
                }
            } else if (!outdir.canWrite()) {
                this.warn(msgs, WARN_CANNOT_WRITE_TO_OUTPUT_DIR, outdir.getPath());
            }
        }
    }

    private TargetData convertOrCreate(int type, List<TargetData> tlist) {
        TargetData target = tlist.get(0);
        if (target.getTargetType() != type) {
            for (int i = 0; i < tlist.size(); ++i) {
                target = tlist.get(i);
                if (!target.isConvertable(type)) continue;
                target.convert(type);
                if (i > 0) {
                    while (i > 0) {
                        tlist.set(i, tlist.get(i - 1));
                        --i;
                    }
                    tlist.set(0, target);
                }
                this.setup(this.getMakefileData(), type, true);
                return target;
            }
            tlist.add(1, tlist.get(0));
            target = this.createTarget(type);
            tlist.add(0, target);
        }
        return target;
    }

    private void setup(MakefileData makefileData, int type, boolean reinit) {
        if (type == 1) {
            this.label = this.getString("LBL_ExecutableName");
            this.mnemonic = this.getString("MNEM_ExecutableName").charAt(0);
            this.tname = this.getString("DFLT_ExecutableName");
        } else if (type == 2) {
            this.label = this.getString("LBL_ArchiveName");
            this.mnemonic = this.getString("MNEM_ArchiveName").charAt(0);
            this.tname = this.getString("DFLT_ArchiveName");
        } else if (type == 3) {
            String suffix = makefileData.getMakefileOS() == 3 ? ".dll" : (makefileData.getMakefileOS() == 4 ? ".dylib" : ".so");
            this.label = this.getString("LBL_ShobjName");
            this.mnemonic = this.getString("MNEM_ShobjName").charAt(0);
            this.tname = this.getString("DFLT_ShobjName") + suffix;
        } else {
            throw new IllegalStateException();
        }
        if (reinit) {
            this.getNameLabel().setText(this.label);
            this.getNameLabel().setDisplayedMnemonic(this.mnemonic);
        }
    }

    private TargetData createTarget(int type) {
        this.setup(this.getMakefileData(), type, true);
        String dir = this.getMakefileData().defaultOutputDirectory();
        return new TargetData(type, this.tname, dir, 0);
    }

    @Override
    public void addNotify() {
        TargetData target;
        int type = this.getMakefileData().getMakefileType();
        if (!this.initialized) {
            this.setup(this.getMakefileData(), type, false);
            this.create(this.getString("LBL_TargetDirectory"), this.getString("MNEM_TargetDirectory").charAt(0), this.label, this.mnemonic);
            target = this.createTarget(type);
            target.setTargetName(this.tname);
            this.getMakefileData().getTargetList().add(target);
            this.initialized = true;
        } else {
            List<TargetData> tlist = this.getMakefileData().getTargetList();
            target = tlist.get(0);
            if (target.getTargetType() != type) {
                target = this.convertOrCreate(type, tlist);
            }
        }
        MakefileWizard.getMakefileWizard().initDirPaths();
        MakefileWizard.getMakefileWizard().initMakefileName();
        String dir = target.getOutputDirectory();
        this.getText().setText(target.getTargetName());
        int pos = dir.lastIndexOf(47);
        if (pos == -1) {
            this.getDirText().setText(this.getMakefileData().getBaseDirectory() + File.separator + target.getOutputDirectory());
        } else {
            this.getDirText().setText(dir);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        MakefileData md = this.getMakefileData();
        TargetData target = md.getTargetList().get(0);
        String name = this.getText().getText();
        String dir = this.getDirText().getText();
        String base = md.getBaseDirectory();
        try {
            if (dir.startsWith(base) && (dir.length() == base.length() || dir.charAt(base.length()) == '/')) {
                if (!dir.substring(base.length() + 1).equals(target.getOutputDirectory())) {
                    target.setOutputDirectory(dir.substring(base.length() + 1));
                }
            } else {
                target.setOutputDirectory(dir);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            target.setOutputDirectory(dir);
        }
        if (!name.equals(target.getTargetName())) {
            target.setTargetName(name);
            target.setName(name);
        }
    }
}

